/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.texture;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Cylinder;
import org.xith3d.scenegraph.primitives.GeometryType;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Texture coordinates generation test"}, authors={"Yuri Vl. Gushchin (aka YVG)"})
public class TexCoordGenerationTest
extends Xith3DTest {
    private Material mat;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                this.mat.setLightingEnabled(!this.mat.isLightingEnabled());
            }
        }
    }

    private void createSceneGraph(GroupNode rootBranch, Animator animator) {
        Group objRoot = new Group();
        AmbientLight light = new AmbientLight(true, Colorf.WHITE);
        objRoot.addChild(light);
        Transform3D testTranslateZ = new Transform3D();
        TransformGroup testTranslateZGroup = new TransformGroup();
        testTranslateZ.setTranslation(0.0f, 0.0f, -10.0f);
        testTranslateZGroup.setTransform(testTranslateZ);
        objRoot.addChild(testTranslateZGroup);
        RotatableGroup testRotateXGroup = new RotatableGroup(new TransformationDirectives(0.1f, 0.0f, 0.0f));
        testTranslateZGroup.addChild(testRotateXGroup);
        RotatableGroup testRotateX1Group = new RotatableGroup(new TransformationDirectives(0.1f, 0.0f, 0.0f));
        testTranslateZGroup.addChild(testRotateX1Group);
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        testRotateXGroup.addChild(testRotateYGroup);
        RotatableGroup testRotateY1Group = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        testRotateX1Group.addChild(testRotateY1Group);
        TransformGroup sceneRootTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        sceneRootTransform.setTransform(t);
        testRotateYGroup.addChild(sceneRootTransform);
        Texture2D textureBG = TextureLoader.getInstance().getTexture("reflectbg.jpg", Texture.MipmapMode.BASE_LEVEL);
        Texture2D texture = TextureLoader.getInstance().getTexture("reflect.jpg", Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
        this.mat = new Material();
        this.mat.setAmbientColor(0.8f, 0.8f, 0.8f);
        this.mat.setLightingEnabled(true);
        Rectangle rect = new Rectangle(30.0f, 20.0f, (Texture)textureBG);
        StaticTransform.translate(rect, 0.0f, 0.0f, -20.0f);
        Appearance rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        objRoot.addChild(rect);
        Cylinder.setGeometryConstructionTypeHint(GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY);
        Cylinder cylinder = new Cylinder(1.0f, 4.0f, 1.0f, false, 32, 3, false, 2);
        StaticTransform.rotateX(cylinder, 1.5707964f);
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        a.setTexture(texture);
        TexCoordGeneration texGen = new TexCoordGeneration(TexCoordGeneration.SPHERE_MAP, TexCoordGeneration.TEXTURE_COORDINATE_2);
        a.setTexCoordGeneration(texGen);
        a.setMaterial(this.mat);
        cylinder.setAppearance(a);
        sceneRootTransform.addChild(cylinder);
        Cube cube = new Cube(1.7f, 3, false, 2);
        StaticTransform.translate(cube, 0.0f, 3.5f, 0.0f);
        a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        texGen = new TexCoordGeneration(TexCoordGeneration.SPHERE_MAP, TexCoordGeneration.TEXTURE_COORDINATE_2);
        a.setTexCoordGeneration(texGen);
        a.setMaterial(this.mat);
        cube.setAppearance(a);
        testRotateY1Group.addChild(cube);
        rootBranch.addChild(objRoot);
        animator.addAnimatableObject(testRotateXGroup);
        animator.addAnimatableObject(testRotateYGroup);
        animator.addAnimatableObject(testRotateX1Group);
        animator.addAnimatableObject(testRotateY1Group);
    }

    public TexCoordGenerationTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = new BranchGroup();
        this.createSceneGraph(rootBranch, this.getAnimator());
        env.addPerspectiveBranch(rootBranch);
        RenderPass renderPass = new RenderPass(rootBranch, new BaseRenderPassConfig());
        renderPass.getConfig().setFieldOfView(FastMath.toRad(22.5f));
        env.addRenderPass(renderPass);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        TexCoordGenerationTest test = new TexCoordGenerationTest(TexCoordGenerationTest.parseCommandLine(args));
        test.begin();
    }
}

