/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.texture;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Texture BLEND test"}, authors={"Yuri Vl. Gushchin (aka YVG)"})
public class TextureBlendTest
extends Xith3DTest {
    private RenderPass renderPass;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.renderPass.getConfig().getProjectionPolicy() == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
                    break;
                }
                this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            }
        }
    }

    private byte[] getSample16x16LATexture() {
        byte[] data = new byte[512];
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                float a = 1.0f;
                float l = 1.0f;
                if (x == y) {
                    a = 0.15f;
                }
                if (x == 15 - y) {
                    l = 0.15f;
                }
                data[(x + 16 * y) * 2] = (byte)(255.0f * l);
                data[(x + 16 * y) * 2 + 1] = (byte)(255.0f * a);
            }
        }
        return data;
    }

    private BranchGroup createSceneGraph(Animator animator) {
        BranchGroup root = new BranchGroup();
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        TransformGroup scaleTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        scaleTransform.setTransform(t);
        testRotateYGroup.addChild(scaleTransform);
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg");
        Rectangle rect = new Rectangle(0.6f, 0.6f, (Texture)texture);
        StaticTransform.translate(rect, -0.4f, -0.4f, 0.0f);
        Appearance rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        scaleTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, (Texture)texture);
        StaticTransform.translate(rect, 0.4f, -0.4f, 0.0f);
        rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        ColoringAttributes ca = new ColoringAttributes();
        ca.setColor(Colorf.RED);
        ca.setShadeModel(ColoringAttributes.SHADE_FLAT);
        rectApp.setColoringAttributes(ca);
        TextureAttributes ta = new TextureAttributes();
        ta.setTextureMode(TextureAttributes.REPLACE);
        rectApp.setTextureAttributes(ta);
        scaleTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, (Texture)texture);
        StaticTransform.translate(rect, -0.4f, 0.4f, 0.0f);
        rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        ca = new ColoringAttributes();
        ca.setColor(Colorf.RED);
        ca.setShadeModel(ColoringAttributes.SHADE_FLAT);
        rectApp.setColoringAttributes(ca);
        ta = new TextureAttributes();
        ta.setTextureMode(TextureAttributes.MODULATE);
        rectApp.setTextureAttributes(ta);
        scaleTransform.addChild(rect);
        byte[] texData = this.getSample16x16LATexture();
        TextureImage2D imgc1 = new TextureImage2D(TextureImageFormat.LUMINANCE_ALPHA, 16, 16, texData);
        Texture2D t2d = new Texture2D(TextureFormat.RGBA);
        t2d.setBoundaryModes(TextureBoundaryMode.CLAMP, TextureBoundaryMode.CLAMP);
        t2d.setFilter(TextureFilter.TRILINEAR);
        t2d.setImage(0, imgc1);
        t2d.setEnabled(true);
        rect = new Rectangle(0.6f, 0.6f, (Texture)t2d);
        StaticTransform.translate(rect, 0.4f, 0.4f, 0.0f);
        rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        ca = new ColoringAttributes();
        ca.setColor(Colorf.RED);
        ca.setShadeModel(ColoringAttributes.SHADE_FLAT);
        rectApp.setColoringAttributes(ca);
        ta = new TextureAttributes();
        ta.setTextureMode(TextureAttributes.BLEND);
        rectApp.setTextureAttributes(ta);
        TransparencyAttributes tra = new TransparencyAttributes();
        tra.setMode(TransparencyAttributes.BLENDED);
        tra.setTransparency(0.0f);
        rectApp.setTransparencyAttributes(tra);
        scaleTransform.addChild(rect);
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        Cube cube = new Cube(0.8f, a);
        StaticTransform.translate(cube, 0.0f, 0.0f, -0.6f);
        scaleTransform.addChild(cube);
        root.addChild(testRotateYGroup);
        animator.addAnimatableObject(testRotateYGroup);
        return root;
    }

    public TextureBlendTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = this.createSceneGraph(this.getAnimator());
        this.renderPass = env.addPerspectiveBranch(rootBranch);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        TextureBlendTest test = new TextureBlendTest(TextureBlendTest.parseCommandLine(args));
        test.begin();
    }
}

