/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.texture;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;

@Xith3DTest.Description(fulltext={"Simple Xith3D Texture transform test"}, authors={"Yuri Vl. Gushchin (aka YVG)"})
public class TextureTransformTest
extends Xith3DTest {
    private RenderPass renderPass;
    private Transform3D texTransform = new Transform3D();
    private Transform3D rot0 = new Transform3D();
    private Transform3D translate0 = new Transform3D();
    private Transform3D translate1 = new Transform3D();
    private AngleInterpolater texAngle;
    private TextureAttributes ta;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.renderPass.getConfig().getProjectionPolicy() == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
                    break;
                }
                this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            }
        }
    }

    private BranchGroup createSceneGraph(Animator animator) {
        BranchGroup root = new BranchGroup();
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        TransformGroup scaleTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        scaleTransform.setTransform(t);
        testRotateYGroup.addChild(scaleTransform);
        AmbientLight light = new AmbientLight(true, Colorf.GRAY50);
        DirectionalLight dlight = new DirectionalLight(true, Colorf.GRAY70, new Vector3f(-2.0f, -1.0f, -2.0f));
        scaleTransform.addChild(light);
        scaleTransform.addChild(dlight);
        Cube cube = new Cube(1.0f, 11, false, 2);
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK, 0.0f));
        Texture2D tex = TextureLoader.getInstance().getTexture("jplogo.jpg");
        tex.setBoundaryModeS(TextureBoundaryMode.CLAMP);
        tex.setBoundaryModeT(TextureBoundaryMode.CLAMP);
        a.setTexture(tex);
        this.ta = new TextureAttributes();
        this.adjustTexTransform(0.0f);
        this.ta.setTextureTransform(this.texTransform);
        a.setTextureAttributes(this.ta);
        Material mat = new Material();
        mat.setAmbientColor(Colorf.GRAY25);
        mat.setDiffuseColor(Colorf.GRAY25);
        mat.setLightingEnabled(true);
        a.setMaterial(mat);
        cube.setAppearance(a);
        scaleTransform.addChild(cube);
        root.addChild(testRotateYGroup);
        animator.addAnimatableObject(testRotateYGroup);
        return root;
    }

    private void adjustTexTransform(float angle) {
        this.texTransform.setIdentity();
        this.translate1.setTranslation(new Vector3f(0.5f, 0.5f, 0.0f));
        this.texTransform.mul(this.translate1);
        this.rot0.rotZ(angle);
        this.texTransform.mul(this.rot0);
        this.translate0.setTranslation(new Vector3f(-0.5f, -0.5f, 0.0f));
        this.texTransform.mul(this.translate0);
    }

    protected void onRenderLoopStarted() {
        this.texAngle = new AngleInterpolater(0.0f, 1.0f, 0.0f, (float)Math.PI * 2, true);
        this.texAngle.startIncreasing(0L);
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.adjustTexTransform(this.texAngle.getValue(timingMode.getMicroSeconds(gameTime)));
        this.ta.setTextureTransform(this.texTransform);
    }

    public TextureTransformTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = this.createSceneGraph(this.getAnimator());
        this.renderPass = env.addPerspectiveBranch(rootBranch);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        TextureTransformTest test = new TextureTransformTest(TextureTransformTest.parseCommandLine(args));
        test.begin();
    }
}

