/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.twodee;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.openmali.types.twodee.Dim2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Point3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.picking.PickingLibrary;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase demonstrates the use of a 2D-environment."}, authors={"Marvin Froehlich (aka Qudus)"})
public class TwoDeeTest1
extends Xith3DTest
implements NearestPickListener {
    private RenderPassConfig passConfig;
    private Canvas3D canvas;
    private GroupNode pickGroup;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        if (button == MouseButtons.LEFT_BUTTON) {
            PickingLibrary.pickNearest(this.passConfig, this.pickGroup, this.canvas, button, e.getX(), e.getY(), this);
        }
    }

    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        System.out.println("You picked shape: " + nearest.getNode());
    }

    public void onPickingMissed(Object userObject, long pickTime) {
        System.out.println("Picking missed!");
    }

    private RenderPass createScene(Animator animator) {
        Dim2i resolution = new Dim2i(800, 600);
        BranchGroup scene = new BranchGroup();
        Rectangle rect0 = new Rectangle((float)resolution.getWidth(), (float)resolution.getHeight(), Rectangle.ZeroPointLocation.TOP_LEFT, "precision.png");
        rect0.setPickable(false);
        scene.addChild(rect0);
        Point3f pos1 = new Point3f(0.0f, 0.0f, 0.001f);
        Rectangle rect1 = new Rectangle(100.0f, 100.0f, Rectangle.ZeroPointLocation.TOP_LEFT, "stone.jpg");
        rect1.setName("rect1");
        TransformGroup tg1 = new TransformGroup(new Transform3D(pos1));
        tg1.addChild(rect1);
        scene.addChild(tg1);
        Point3f pos2 = new Point3f(300.0f, -200.0f, 0.001f);
        Rectangle rect2 = new Rectangle(200.0f, 50.0f, Rectangle.ZeroPointLocation.TOP_LEFT, "rustycan.jpg");
        rect2.setName("rect2");
        TransformGroup tg2 = new TransformGroup(new Transform3D(pos2));
        tg2.addChild(rect2);
        scene.addChild(tg2);
        Point3f pos3 = new Point3f((float)resolution.getHeight() / 2.0f - 30.0f, 0.0f, 0.002f);
        Rectangle rect3 = new Rectangle(50.0f, 50.0f, Rectangle.ZeroPointLocation.CENTER_CENTER, "crate.png");
        rect3.setName("rect3");
        TransformGroup tg3 = new TransformGroup(new Transform3D(pos3));
        tg3.addChild(rect3);
        RotatableGroup rg3 = new RotatableGroup(new TransformationDirectives(0.0f, 0.0f, 0.1f));
        rg3.setTranslation((float)resolution.getWidth() / 2.0f, (float)(-resolution.getHeight()) / 2.0f, 0.0f);
        rg3.addChild(tg3);
        scene.addChild(rg3);
        animator.addAnimatableObject(rg3);
        this.pickGroup = scene;
        RenderPass renderPass = RenderPass.create2D(scene, (Sized2iRO)resolution);
        this.passConfig = renderPass.getConfig();
        return renderPass;
    }

    public TwoDeeTest1(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addRenderPass(this.createScene(this.getAnimator()));
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        TwoDeeTest1 test = new TwoDeeTest1(TwoDeeTest1.parseCommandLine(args));
        test.begin();
    }
}

