/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.twodee;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase demonstrates, that multiple overlappingtransparent shapes really do work :)."}, authors={"Marvin Froehlich (aka Qudus)"})
public class TwoDeeTest2
extends Xith3DTest {
    private static final boolean USE_SHARED_COPIES = false;
    private TransformGroup[] tgs = new TransformGroup[5];

    private static void setZValue(TransformGroup tg, float z) {
        tg.getTransform().getMatrix4f().m23(z);
        tg.updateTransform();
    }

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case _1: {
                float newZ = (this.tgs[0].getTransform().getMatrix4f().m23() + 0.1f) % 0.5f;
                System.out.println("Setting z-value of the 1st picture to " + newZ + "...");
                TwoDeeTest2.setZValue(this.tgs[0], newZ);
                break;
            }
            case _2: {
                float newZ = (this.tgs[1].getTransform().getMatrix4f().m23() + 0.1f) % 0.5f;
                System.out.println("Setting z-value of the 2nd picture to " + newZ + "...");
                TwoDeeTest2.setZValue(this.tgs[1], newZ);
                break;
            }
            case _3: {
                float newZ = (this.tgs[2].getTransform().getMatrix4f().m23() + 0.1f) % 0.5f;
                System.out.println("Setting z-value of the 3rd picture to " + newZ + "...");
                TwoDeeTest2.setZValue(this.tgs[2], newZ);
                break;
            }
            case _4: {
                float newZ = (this.tgs[3].getTransform().getMatrix4f().m23() + 0.1f) % 0.5f;
                System.out.println("Setting z-value of the 4th picture to " + newZ + "...");
                TwoDeeTest2.setZValue(this.tgs[3], newZ);
                break;
            }
            case _5: {
                float newZ = (this.tgs[4].getTransform().getMatrix4f().m23() + 0.1f) % 0.5f;
                System.out.println("Setting z-value of the 5th picture to " + newZ + "...");
                TwoDeeTest2.setZValue(this.tgs[4], newZ);
                break;
            }
            case SPACE: {
                System.out.println("Setting all pictures to the same z-value...");
                for (int i = 0; i < this.tgs.length; ++i) {
                    TwoDeeTest2.setZValue(this.tgs[i], 0.0f);
                }
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private RenderPass createScene() {
        BranchGroup scene = new BranchGroup();
        Rectangle rect0 = new Rectangle(100.0f, 100.0f, Rectangle.ZeroPointLocation.TOP_LEFT, "jplogo.png");
        this.tgs[0] = new TransformGroup(100.0f, -100.0f, 0.0f);
        this.tgs[0].addChild(rect0);
        scene.addChild(this.tgs[0]);
        for (int i = 1; i < this.tgs.length; ++i) {
            Rectangle recti = null;
            recti = new Rectangle(100.0f, 100.0f, Rectangle.ZeroPointLocation.TOP_LEFT, "jplogo.png");
            this.tgs[i] = new TransformGroup(100.0f + 50.0f * (float)i, -100.0f - 50.0f * (float)i, (float)i * 0.1f);
            this.tgs[i].addChild(recti);
            scene.addChild(this.tgs[i]);
        }
        return RenderPass.create2D(scene, 800, 600);
    }

    public TwoDeeTest2(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addRenderPass(this.createScene());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        TwoDeeTest2 test = new TwoDeeTest2(TwoDeeTest2.parseCommandLine(args));
        test.begin();
    }
}

