/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.render.FourViewsPanel;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.RenderableSceneGraph;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.awt.WindowHelper;
import org.xith3d.utility.commandline.BasicApplicationArguments;

@Xith3DTest.Description(fulltext={"Simple test of the FourViewsPanel which will be needed in", "most 3D-modeler applications."}, authors={"Marvin Froehlich (aka Qudus)"})
public class FourViewsPanelTest
extends Xith3DTest {
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private JFrame initGUI(RenderableSceneGraph env, OpenGLLayer layer, Sized2iRO res, String title) throws Exception {
        JFrame f = new JFrame(title);
        f.setLayout(new GridLayout(1, 1));
        f.setDefaultCloseOperation(2);
        f.setSize(res.getWidth(), res.getHeight());
        WindowHelper.center(f);
        layer = layer.isJOGL() ? OpenGLLayer.JOGL_AWT : OpenGLLayer.LWJGL_AWT;
        FourViewsPanel fvp = new FourViewsPanel(layer);
        f.getContentPane().add((Component)fvp, null);
        View nwView = new View();
        env.addView(nwView);
        InputSystem.getInstance().registerNewKeyboardAndMouse(fvp.getNWPanel().getCanvas().getPeer());
        env.addCanvas(fvp.getNWPanel(), nwView);
        View neView = new View();
        env.addView(neView);
        InputSystem.getInstance().registerNewKeyboardAndMouse(fvp.getNEPanel().getCanvas().getPeer());
        env.addCanvas(fvp.getNEPanel(), neView);
        View swView = new View();
        env.addView(swView);
        InputSystem.getInstance().registerNewKeyboardAndMouse(fvp.getSWPanel().getCanvas().getPeer());
        env.addCanvas(fvp.getSWPanel(), swView);
        View seView = env.getView();
        InputSystem.getInstance().registerNewKeyboardAndMouse(fvp.getSEPanel().getCanvas().getPeer());
        env.addCanvas(fvp.getSEPanel(), seView);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FourViewsPanelTest.this.end();
            }
        });
        return f;
    }

    private Cube createTestCube() {
        Cube testCube = new Cube(3.0f, "jplogo.jpg");
        return testCube;
    }

    public FourViewsPanelTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch().getBranchGroup().addChild(this.createTestCube());
        JFrame frame = this.initGUI(env, arguments.getOpenGLLayer(), arguments.getDisplayMode(), this.getClass().getSimpleName());
        frame.setVisible(true);
    }

    public static void main(String[] args) throws Throwable {
        FourViewsPanelTest test = new FourViewsPanelTest(FourViewsPanelTest.parseCommandLine(args));
        test.begin();
    }
}

