/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.AbstractList;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.borders.ColoredBorder;
import org.xith3d.ui.hud.borders.RoundedCornersBorder;
import org.xith3d.ui.hud.borders.TexturedBorder;
import org.xith3d.ui.hud.dialogs.MsgBox;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.listeners.DialogListener;
import org.xith3d.ui.hud.listeners.ListSelectionListener;
import org.xith3d.ui.hud.utils.ButtonGroup;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.MultilineText;
import org.xith3d.ui.hud.utils.WidgetZIndexGroup;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.Checkbox;
import org.xith3d.ui.hud.widgets.ComboBox;
import org.xith3d.ui.hud.widgets.Dialog;
import org.xith3d.ui.hud.widgets.FPSCounter;
import org.xith3d.ui.hud.widgets.Frame;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.List;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.ProgressBar;
import org.xith3d.ui.hud.widgets.RadioButton;
import org.xith3d.ui.hud.widgets.ScrollPanel;
import org.xith3d.ui.hud.widgets.TextField;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test tries to demonstrate all of the HUD's features.", "The Xith3D HUD is more than a head-up-display for games,since it provides a full-featured basic Widget set.It is intended to be used as a game user-interface toolkit."}, authors={"Marvin Froehlich (aka Qudus)"})
public class HUD3DTest
extends Xith3DTest
implements ButtonListener,
DialogListener {
    public void onButtonClicked(AbstractButton button, Object userObject) {
        HUD hud = button.getHUD();
        if (userObject instanceof Object[] && ((Object[])userObject)[0].equals("INPUT_FRAME")) {
            Object[] uo = (Object[])userObject;
            int nextFrameIndex = (Integer)uo[1];
            uo[1] = nextFrameIndex + 1;
            TestHUDFrame frame = new TestHUDFrame(300.0f, 320.0f, nextFrameIndex);
            hud.addWindowCentered(frame);
        } else if (userObject.equals("TEST_PROGRESSBAR")) {
            TestProgressDialog dialog = new TestProgressDialog(400.0f, 170.0f);
            dialog.addDialogListener(this);
            hud.addWindowCentered(dialog);
        } else if (userObject.equals("TEST_SCROLLPANE")) {
            TestScrollPaneFrame frame = new TestScrollPaneFrame(400.0f, 170.0f);
            hud.addWindowCentered(frame);
        } else if (userObject.equals("TEST_LIST")) {
            TestListFrame frame = new TestListFrame(450.0f, 215.0f);
            hud.addWindowCentered(frame);
        } else if (userObject.equals("TEST_PIP")) {
            TestPanelInPanelFrame frame = new TestPanelInPanelFrame(500.0f, 520.0f);
            hud.addWindowCentered(frame);
        } else if (userObject.equals("ADD_DOTS")) {
            ((Button)button).setText(((Button)button).getText() + ".");
        } else if (userObject.equals("BLUE_RISEN")) {
            MsgBox.show("You clicked on the BlueRisen Button.", hud);
        } else if (userObject.equals("COOL_IMAGE_BUTTON")) {
            MsgBox.show("You clicked on the CoolImageButton.", hud);
        } else if (userObject.equals("ANOTHER_COOL_IMAGE_BUTTON")) {
            MsgBox.show("You clicked on the other CoolImageButton.", hud);
        } else if (userObject.equals("EXIT")) {
            System.out.println("Exiting...");
            this.end();
        }
    }

    public void onDialogClosed(Dialog dialog, Object closeCommand) {
        if (closeCommand != null && closeCommand.equals("CLOSE")) {
            dialog.detach();
        }
    }

    private HUD createHUD(Sized2iRO resolution) {
        HUD hud = new HUD(resolution, 1024.0f);
        hud.getContentPane().setBorder(new TexturedBorder(6, 6, 6, 6, "border-black.png"));
        Button exitButton = new Button(100.0f, 40.0f, "HUD/BlueButtonNormal.png", "HUD/BlueButtonHovered.png", "HUD/BlueButtonPressed.png", "Exit", HUDFont.getFont("Monospace", HUDFont.BOLD, 24), Colorf.WHITE);
        exitButton.setUserObject("EXIT");
        exitButton.addButtonListener(this);
        hud.getContentPane().addWidget(exitButton, hud.getResX() - exitButton.getWidth() - 16.0f, 16.0f);
        Button frameOpener = new Button(170.0f, 56.0f, "Test Input-Widgets");
        frameOpener.setUserObject(new Object[]{"INPUT_FRAME", 1});
        frameOpener.addButtonListener(this);
        hud.getContentPane().addWidget(frameOpener, 20.0f, 20.0f);
        Button progressbarOpener = new Button(170.0f, 56.0f, "Test ProgressBar");
        progressbarOpener.setUserObject("TEST_PROGRESSBAR");
        progressbarOpener.addButtonListener(this);
        hud.getContentPane().addWidget(progressbarOpener, 20.0f, 86.0f);
        Button scrollpaneOpener = new Button(170.0f, 56.0f, "Test ScrollPane");
        scrollpaneOpener.setUserObject("TEST_SCROLLPANE");
        scrollpaneOpener.addButtonListener(this);
        hud.getContentPane().addWidget(scrollpaneOpener, 20.0f, 152.0f);
        Button listOpener = new Button(170.0f, 56.0f, "Test List");
        listOpener.setUserObject("TEST_LIST");
        listOpener.addButtonListener(this);
        hud.getContentPane().addWidget(listOpener, 20.0f, 218.0f);
        Button pipOpener = new Button(170.0f, 56.0f, "Panel-in-Panel");
        pipOpener.setUserObject("TEST_PIP");
        pipOpener.addButtonListener(this);
        hud.getContentPane().addWidget(pipOpener, 20.0f, 284.0f);
        ZIndexTestPanel ziPanel = new ZIndexTestPanel(260.0f, 300.0f);
        hud.getContentPane().addWidget(ziPanel, 20.0f, 370.0f);
        Button dotsButton = new Button(384.0f, 56.0f, "Click to add dots", HUDFont.getFont("Agent Orange", HUDFont.ITALIC, 22));
        dotsButton.setUserObject("ADD_DOTS");
        dotsButton.addButtonListener(this);
        hud.getContentPane().addWidget(dotsButton, 550.0f, 80.0f);
        Button brButton = new Button(180.0f, 50.0f, "HUD/blue_risen_button/normal.png", "HUD/blue_risen_button/hovered.png", "HUD/blue_risen_button/pressed.png", "BlueRisen", HUDFont.getFont("Monospace", HUDFont.BOLD, 24), null);
        brButton.setUserObject("BLUE_RISEN");
        brButton.addButtonListener(this);
        hud.getContentPane().addWidget(brButton, 790.0f, 180.0f);
        brButton.setToolTip("Yet another ToolTip");
        Button imageButton = new Button(200.0f, 100.0f, "HUD/CoolImageButtonNormal.png", "HUD/CoolImageButtonHovered.png", "HUD/CoolImageButtonPressed.png");
        imageButton.setUserObject("COOL_IMAGE_BUTTON");
        imageButton.addButtonListener(this);
        hud.getContentPane().addWidget(imageButton, 670.0f, 280.0f);
        imageButton.setToolTip("bla bla");
        Button aciButton = new Button(170.0f, 130.0f, "HUD/RoundBlackBorder.png", "HUD/RoundLightBlackBorder.png", "HUD/RoundLightRedBorder.png", "Another\ncool\nbutton", HUDFont.getFont("Monospace", HUDFont.BOLD, 24), Colorf.WHITE);
        aciButton.setUserObject("ANOTHER_COOL_IMAGE_BUTTON");
        aciButton.addButtonListener(this);
        hud.getContentPane().addWidget(aciButton, 800.0f, 420.0f);
        FPSCounter fpsCounter = new FPSCounter(100.0f, 30.0f, "HUD/YellowBorder.png");
        fpsCounter.setFontColor(new Colorf(0.8f, 0.0f, 0.0f));
        fpsCounter.setName("FPSCounter");
        this.addFPSListener(fpsCounter);
        hud.getContentPane().addWidget(fpsCounter, hud.getResX() - fpsCounter.getWidth() - 15.0f, hud.getResY() - fpsCounter.getHeight() - 15.0f);
        Label fpsDesc = new Label(350.0f, fpsCounter.getHeight(), "Limited to 120 FPS:", new Colorf(0.55f, 1.0f, 0.8f), TextAlignment.CENTER_RIGHT){

            protected void drawText(MultilineText multiLineText, Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
                super.drawText(multiLineText, texCanvas, offsetX, offsetY, width, height);
                for (int i = 0; i < multiLineText.getNumLines(); ++i) {
                    texCanvas.drawLineOffset(offsetX + multiLineText.getPosX(i), offsetY + multiLineText.getPosY(i) + multiLineText.getLineOffsetY(i) / 2 + 2, multiLineText.getWidth(i), 0);
                }
            }
        };
        hud.getContentPane().addWidget(fpsDesc, fpsCounter.getLeft() - fpsDesc.getWidth() - 10.0f, fpsCounter.getTop());
        hud.setCursor("HUD/cursors/cursor1.png");
        hud.setCrosshair("HUD/CrosshairWhite.png");
        hud.getContentPane().setToolTip("The HUD's ContentPane-ToolTip.");
        return hud;
    }

    private void init(SceneGraph sg, Sized2iRO resolution) throws Exception {
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL();
        resLoc.createAndAddTSL("HUD");
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("models");
        BranchGroup scene = new BranchGroup();
        Cube cube = new Cube(3.0f, "crate.png");
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.2f, 0.2f, 0.0f));
        rg.addChild(cube);
        scene.addChild(rg);
        this.getAnimator().addAnimatableObject(rg);
        RenderPass scenePass = sg.addPerspectiveBranch(scene);
        scenePass.setFrustumCullingEnabled(false);
        HUD hud = this.createHUD(resolution);
        sg.addHUD(hud);
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    public HUD3DTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        this.init(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        canvas.setCursor(null);
        this.addFPSListener(new CanvasFPSListener(canvas));
    }

    public static void main(String[] args) throws Throwable {
        HUD3DTest test = new HUD3DTest(HUD3DTest.parseCommandLine(args));
        test.begin();
    }

    private class ZIndexTestPanel
    extends ScrollPanel {
        private WidgetZIndexGroup ziGroup;

        public ZIndexTestPanel(float width, float height) {
            super(width, height, Colorf.parseColor("#908191"));
            this.setBorder(new ColoredBorder(3, Colorf.parseColor("#B72323")));
            this.ziGroup = new WidgetZIndexGroup();
            Image deathStar = new Image(120.0f, 120.0f, "deathstar.jpg");
            deathStar.setZIndex(1);
            this.addWidget(deathStar, 30.0f, 30.0f);
            this.ziGroup.add(deathStar);
            Image stone = new Image(120.0f, 120.0f, "stone.jpg");
            stone.setZIndex(2);
            this.addWidget(stone, 40.0f, 40.0f);
            this.ziGroup.add(stone);
            Image jeep = new Image(120.0f, 120.0f, "jeep1.jpg");
            jeep.setZIndex(3);
            this.addWidget(jeep, 50.0f, 50.0f);
            this.ziGroup.add(jeep);
            Image william = new Image(120.0f, 120.0f, "William.jpg");
            william.setZIndex(4);
            this.addWidget(william, 60.0f, 60.0f);
            this.ziGroup.add(william);
            Label infoText = new Label(-1.0f, -1.0f, "Click on the images to bring them to front!", HUDFont.getFont("Verdana", HUDFont.PLAIN, 14), Colorf.BLACK, TextAlignment.TOP_CENTER);
            this.addWidget(infoText, 0.0f, 220.0f);
            this.setHasDropShadow(true);
        }
    }

    private class TestPanelInPanelFrame
    extends Frame {
        public TestPanelInPanelFrame(float width, float height) {
            super(width, height, "Panel-in-Panel example");
            Panel p1 = new Panel(400.0f, 400.0f, Colorf.RED);
            this.getContentPane().addWidget(p1, 80.0f, 80.0f);
            Panel p2 = new Panel(300.0f, 300.0f, Colorf.GREEN);
            p1.addWidget(p2, 80.0f, 80.0f);
            Panel p3 = new Panel(200.0f, 200.0f, Colorf.BLUE);
            p2.addWidget(p3, 80.0f, 80.0f);
            Label l0 = new Label(120.0f, 20.0f, "Label in Panel0");
            l0.setName("L0");
            this.getContentPane().addWidget(l0, 10.0f, 10.0f);
            Label l1 = new Label(120.0f, 20.0f, "Label in Panel1");
            l1.setName("L1");
            p1.addWidget(l1, 10.0f, 10.0f);
            Label l2 = new Label(120.0f, 20.0f, "Label in Panel2");
            l2.setName("L2");
            p2.addWidget(l2, 10.0f, 10.0f);
            Label l3 = new Label(120.0f, 20.0f, "Label in Panel3");
            l3.setName("L3");
            p3.addWidget(l3, 10.0f, 10.0f);
        }
    }

    private class TestListFrame
    extends Frame
    implements ListSelectionListener {
        private List list;
        private Label prevSelected1;
        private Label currSelected1;
        private ComboBox comboBox;
        private Label prevSelected2;
        private Label currSelected2;

        public void onListItemClicked(AbstractList list, Object item, int itemIndex) {
        }

        public void onListSelectionChanged(AbstractList list, Object oldSelectedItem, Object newSelectedItem, int oldSelectedIndex, int newSelectedIndex) {
            if (list == this.comboBox) {
                if (oldSelectedIndex == -1) {
                    this.prevSelected1.setText("<none>");
                } else {
                    this.prevSelected1.setText(String.valueOf(oldSelectedItem));
                }
                this.currSelected1.setText(String.valueOf(newSelectedItem));
            } else if (list == this.list) {
                if (oldSelectedIndex == -1) {
                    this.prevSelected2.setText("<none>");
                } else {
                    this.prevSelected2.setText(String.valueOf(oldSelectedItem));
                }
                this.currSelected2.setText(String.valueOf(newSelectedItem));
            }
        }

        public TestListFrame(float width, float height) {
            int i;
            super((WidgetContainer)Panel.createContentPane(width, height), "List example");
            this.list = List.newTextList(150.0f, 170.0f);
            for (i = 0; i < 6; ++i) {
                this.list.addItem("Item " + i, Colorf.RED);
            }
            this.list.addItem(4, "Item X");
            for (i = 7; i < 20; ++i) {
                this.list.addItem("Item " + i);
            }
            this.getContentPane().addWidget(this.list, 10.0f, 10.0f);
            this.list.addSelectionListener(this);
            this.comboBox = ComboBox.newTextCombo(260.0f, 25.0f);
            for (i = 0; i < 20; ++i) {
                this.comboBox.addItem("Item" + i);
            }
            this.comboBox.addSelectionListener(this);
            this.getContentPane().addWidget(this.comboBox, 170.0f, 10.0f);
            Panel infoPanel = new Panel(260.0f, 140.0f);
            infoPanel.setBorder(new RoundedCornersBorder());
            infoPanel.setPadding(3);
            this.getContentPane().addWidget(infoPanel, 170.0f, 40.0f);
            Label l1 = new Label(infoPanel.getResX() * 0.6f, 20.0f, "Pre-Sel (Combo):");
            infoPanel.addWidget(l1, 0.0f, 0.0f);
            this.prevSelected1 = new Label(infoPanel.getResX() - l1.getWidth(), 20.0f, "");
            infoPanel.addWidget(this.prevSelected1, l1.getWidth(), l1.getTop());
            Label l2 = new Label(infoPanel.getResX() * 0.6f, 20.0f, "Curr-Sel (Combo):");
            infoPanel.addWidget(l2, 0.0f, l1.getTop() + l1.getHeight());
            this.currSelected1 = new Label(infoPanel.getResX() - l2.getWidth(), 20.0f, "");
            infoPanel.addWidget(this.currSelected1, l2.getWidth(), l2.getTop());
            Label l3 = new Label(infoPanel.getResX() * 0.6f, 20.0f, "Pre-Sel (List):");
            infoPanel.addWidget(l3, 0.0f, 70.0f);
            this.prevSelected2 = new Label(infoPanel.getResX() - l3.getWidth(), 20.0f, "");
            infoPanel.addWidget(this.prevSelected2, l3.getWidth(), l3.getTop());
            Label l4 = new Label(infoPanel.getResX() * 0.6f, 20.0f, "Curr-Sel (List):");
            infoPanel.addWidget(l4, 0.0f, l3.getTop() + l3.getHeight());
            this.currSelected2 = new Label(infoPanel.getResX() - l4.getWidth(), 20.0f, "");
            infoPanel.addWidget(this.currSelected2, l4.getWidth(), l4.getTop());
        }
    }

    private class TestScrollPaneFrame
    extends Frame {
        public TestScrollPaneFrame(float width, float height) {
            super((WidgetContainer)Panel.createContentPane(width, height, true), "Clipping example");
            this.getContentPane().setPadding(3);
            Label spLabel = new Label(-1.0f, -1.0f, "This text is much too large and will therefore be scrolled on the ScrollPane.\nTo also show, that\ncontent can be\nscrolled vertically, too\nthis text is\neven longer and\nmultiline\nwith an additional\nline to scroll further.\nAnd here comes some more text\nto ensure, that the text\nis forcing the scrollpanel\nto scroll.", TextAlignment.TOP_LEFT);
            this.getContentPane().addWidget(spLabel);
        }
    }

    private class TestProgressDialog
    extends Dialog
    implements Runnable,
    ButtonListener {
        private ProgressBar pb;
        private Button closeButton;

        public void run() {
            int value = 0;
            while (value < 100 && this.getHUD() != null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.pb.setValue(++value);
            }
            this.closeButton.setVisible(true);
        }

        public void onButtonClicked(AbstractButton button, Object userObject) {
            if (button.getUserObject().equals("CLOSE")) {
                this.notifyDialogListeners("CLOSE");
            }
        }

        protected void init() {
            super.init();
            Label text = new Label(this.getResX(), 50.0f, "This Dialog will block the whole\nrest of the HUD for 5 seconds.", TextAlignment.CENTER_CENTER);
            this.getContentPane().addWidget(text, 0.0f, 5.0f);
            this.pb = new ProgressBar(this.getResX() * 0.9f, 46.0f);
            this.pb.setZIndex(1);
            this.pb.setValue(0);
            this.getContentPane().addWidget(this.pb, (this.getResX() - this.pb.getWidth()) / 2.0f, 50.0f);
            this.closeButton = new Button(96.0f, 28.0f, "Close");
            this.closeButton.setUserObject("CLOSE");
            this.closeButton.addButtonListener(this);
            this.closeButton.setVisible(false);
            this.getContentPane().addWidget(this.closeButton, (this.getResX() - this.closeButton.getWidth()) / 2.0f, this.getResY() - 15.0f - this.closeButton.getHeight());
            new Thread(this).start();
        }

        public TestProgressDialog(float width, float height) {
            super((WidgetContainer)new Panel(width, height, Colorf.parseColor("#EEEEEE")), "Progress Dialog");
        }
    }

    private class TestHUDFrame
    extends Frame {
        public TestHUDFrame(float width, float height, int frameIndex) {
            super((WidgetContainer)Panel.createContentPane(width, height), "Input Frame #" + frameIndex);
            Panel p1 = new Panel(this.getContentPane().getResX() - 20.0f, 50.0f);
            p1.setName("p1");
            p1.setBorder(new RoundedCornersBorder());
            TextField tf = new TextField(p1.getResX() - 20.0f, 30.0f, "Klick me to type text!");
            p1.addWidget(tf, 10.0f, 5.0f);
            this.getContentPane().addWidget(p1, 10.0f, 10.0f);
            Panel p2 = new Panel(this.getContentPane().getResX() - 20.0f, 95.0f);
            p2.setName("p2");
            p2.setBorder(new RoundedCornersBorder());
            Checkbox chkBox1 = new Checkbox(100.0f, 20.0f, "Check 1");
            p2.addWidget(chkBox1, 10.0f, 5.0f);
            Checkbox chkBox2 = new Checkbox(100.0f, 20.0f, "Check 2");
            p2.addWidget(chkBox2, 10.0f, 30.0f);
            Checkbox chkBox3 = new Checkbox(100.0f, 20.0f, "Check 3");
            p2.addWidget(chkBox3, 10.0f, 55.0f);
            this.getContentPane().addWidget(p2, 10.0f, p1.getTop() + p1.getHeight() + 10.0f);
            Panel p3 = new Panel(this.getContentPane().getResX() - 20.0f, 95.0f);
            p3.setName("p3");
            p3.setBorder(new RoundedCornersBorder());
            RadioButton rdoButton1 = new RadioButton(100.0f, 20.0f, "Option A");
            p3.addWidget(rdoButton1, 10.0f, 5.0f);
            RadioButton rdoButton2 = new RadioButton(100.0f, 20.0f, "Option B");
            p3.addWidget(rdoButton2, 10.0f, 30.0f);
            RadioButton rdoButton3 = new RadioButton(100.0f, 20.0f, "Option C");
            p3.addWidget(rdoButton3, 10.0f, 55.0f);
            ButtonGroup stateGroup = new ButtonGroup();
            stateGroup.addStateButton(rdoButton1);
            stateGroup.addStateButton(rdoButton2);
            stateGroup.addStateButton(rdoButton3);
            this.getContentPane().addWidget(p3, 10.0f, p2.getTop() + p2.getHeight() + 10.0f);
            tf.requestFocus();
        }
    }
}

