/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.commands.Command;
import org.jagatoo.commands.CommandException;
import org.jagatoo.commands.CommandLine;
import org.jagatoo.commands.CommandProcessor;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.logging.Log;
import org.jagatoo.logging.LogChannel;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.layout.ListLayout;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.assemblies.ConsoleListener;
import org.xith3d.ui.hud.widgets.assemblies.HUDConsole;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.commands.ExitCommand;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test demonstrates the HUDConsole,that catches logging output from the logging systemand gives you the possibility to type commands."}, authors={"Marvin Froehlich (aka Qudus)"})
public class HUDConsoleTest1
extends Xith3DTest
implements ConsoleListener,
ButtonListener {
    private final LogChannel logChannel = new LogChannel("HUDConsoleTest");
    private final CommandProcessor commandProcessor = new CommandProcessor(this.logChannel);
    private final CommandLine tmpCommandLine = new CommandLine();
    private static final String REGULAR = "REGULAR";
    private static final String EXCEPTION = "EXCEPTION";
    private static final String ERROR = "ERROR";
    private HUDConsole console;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case CIRCUMFLEX: 
            case F5: {
                this.console.popUp(!this.console.isPoppedUp());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onCommandEntered(HUDConsole console, String commandLine) {
        console.println("received command: " + commandLine);
        this.tmpCommandLine.parse(commandLine);
        Command command = this.commandProcessor.getRegisteredCommand(this.tmpCommandLine.getKey());
        if (command != null) {
            try {
                command.execute(null, this.tmpCommandLine);
            }
            catch (CommandException e) {
                e.printStackTrace();
            }
        }
    }

    public void onButtonClicked(AbstractButton button, Object userObject) {
        if (userObject == REGULAR) {
            Log.println(this.logChannel, 0, new Object[]{"This is a random log message (" + System.currentTimeMillis() + ")"});
        } else if (userObject == EXCEPTION) {
            Log.println(this.logChannel, -1, new Object[]{"This is a random log message (" + System.currentTimeMillis() + ")"});
        } else if (userObject == ERROR) {
            Log.println(this.logChannel, -2, new Object[]{"This is a random log message (" + System.currentTimeMillis() + ")"});
        }
    }

    private void createHUD(Xith3DEnvironment env, Sized2iRO resolusion) {
        HUD hud = new HUD(resolusion, 800.0f);
        this.console = new HUDConsole(hud.getResX(), 200.0f, this.logChannel.getID(), false);
        this.console.addConsoleListener(this);
        hud.getContentPane().addWidget(this.console);
        Log.getLogManager().registerLog(this.console);
        this.commandProcessor.registerCommand(new ExitCommand(this));
        this.console.registerCommands(this.commandProcessor.getRegisteredCommands());
        Label info = new Label(hud.getResX(), hud.getResY(), "Press Circumflex (^) or F5 to toggle the Console.", HUDFont.getFont("Verdana", HUDFont.PLAIN, 24), Colorf.WHITE, TextAlignment.CENTER_CENTER);
        hud.getContentPane().addWidget(info);
        Panel buttons = new Panel(hud.getResX(), 50.0f);
        buttons.setLayout(new ListLayout(ListLayout.Orientation.HORIZONTAL, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f));
        Button b1 = new Button(200.0f, 0.0f, "Random REGULAR log");
        b1.setUserObject(REGULAR);
        b1.addButtonListener(this);
        buttons.addWidget(b1);
        Button b2 = new Button(200.0f, 0.0f, "Random EXCEPTION log");
        b2.setUserObject(EXCEPTION);
        b2.addButtonListener(this);
        buttons.addWidget(b2);
        Button b3 = new Button(200.0f, 0.0f, "Random ERROR log");
        b3.setUserObject(ERROR);
        b3.addButtonListener(this);
        buttons.addWidget(b3);
        hud.getContentPane().addWidget(buttons, 0.0f, hud.getResY() - buttons.getHeight());
        env.addHUD(hud);
    }

    public HUDConsoleTest1(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createHUD(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
    }

    public static void main(String[] args) throws Throwable {
        HUDConsoleTest1 test = new HUDConsoleTest1(HUDConsoleTest1.parseCommandLine(args));
        test.begin();
    }
}

