/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.commands.Command;
import org.jagatoo.commands.CommandException;
import org.jagatoo.commands.CommandLine;
import org.jagatoo.commands.CommandProcessor;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.logging.LogChannel;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.widgets.assemblies.ConsoleListener;
import org.xith3d.ui.hud.widgets.assemblies.HUDConsole;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.commands.ExitCommand;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test demonstrates the HUDConsole,that catches logging output from the logging systemand gives you the possibility to type commands."}, authors={"Marvin Froehlich (aka Qudus)"})
public class HUDConsoleTest2
extends Xith3DTest
implements ConsoleListener {
    private final LogChannel logChannel = new LogChannel("HUDConsoleTest");
    private final CommandProcessor commandProcessor = new CommandProcessor(this.logChannel);
    private final CommandLine tmpCommandLine = new CommandLine();
    private HUDConsole console;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case CIRCUMFLEX: 
            case F5: {
                this.console.popUp(!this.console.isPoppedUp());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onCommandEntered(HUDConsole console, String commandLine) {
        console.println("received command: " + commandLine);
        this.tmpCommandLine.parse(commandLine);
        Command command = this.commandProcessor.getRegisteredCommand(this.tmpCommandLine.getKey());
        if (command != null) {
            try {
                command.execute(null, this.tmpCommandLine);
            }
            catch (CommandException e) {
                e.printStackTrace();
            }
        }
    }

    private void createHUD(Xith3DEnvironment env, Sized2iRO resolusion) {
        HUD hud = new HUD(resolusion, 800.0f);
        HUDConsole.Description desc = new HUDConsole.Description();
        desc.getBorderDescription().setSizes(30, 30, 30, 30);
        this.console = new HUDConsole(600.0f, 500.0f, this.logChannel.getID(), desc, true);
        this.console.addConsoleListener(this);
        hud.getContentPane().addWidgetCentered(this.console);
        this.console.setDraggable(true);
        this.commandProcessor.registerCommand(new ExitCommand(this));
        this.console.registerCommands(this.commandProcessor.getRegisteredCommands());
        env.addHUD(hud);
    }

    public HUDConsoleTest2(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createHUD(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        HUDConsoleTest2 test = new HUDConsoleTest2(HUDConsoleTest2.parseCommandLine(args));
        test.begin();
    }
}

