/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.contextmenu.ContextMenu;
import org.xith3d.ui.hud.contextmenu.ContextMenuItem;
import org.xith3d.ui.hud.contextmenu.ContextMenuListener;
import org.xith3d.ui.hud.contextmenu.DefaultContextMenu;
import org.xith3d.ui.hud.contextmenu.DefaultContextMenuItem;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test demonstrates the (default) HUD ContextMenu."}, authors={"Marvin Froehlich (aka Qudus)"})
public class HUDContextMenuTest
extends Xith3DTest
implements ContextMenuListener {
    private ContextMenu contextMenu;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.contextMenu.removeAllItems();
                for (int i = 0; i < 5; ++i) {
                    this.contextMenu.addItem(new DefaultContextMenuItem(String.valueOf(FastMath.randomInt())));
                }
                break;
            }
            case A: {
                this.contextMenu.removeAllItems();
                break;
            }
            case S: {
                this.contextMenu.removeAllItems();
                this.contextMenu.addItem(new DefaultContextMenuItem("A"));
                this.contextMenu.addItem(new DefaultContextMenuItem("B"));
                this.contextMenu.addItem(new DefaultContextMenuItem("C"));
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onContextMenuItemClicked(ContextMenuItem item) {
        if ("EXIT".equals(item.getUserObject())) {
            System.out.println("Exited app by menu-click!");
            this.end();
            return;
        }
        System.out.println("Clicked ContextMenuItem " + item + " (user-object: " + item.getUserObject() + ")");
    }

    protected ContextMenu createMainContextMenu() {
        DefaultContextMenu contextMenu = new DefaultContextMenu();
        contextMenu.addItem(new DefaultContextMenuItem("Item1", "Item1"));
        contextMenu.addItem(new DefaultContextMenuItem("Item2", "Item2"));
        contextMenu.addItem(new DefaultContextMenuItem("Item3", "Item3"));
        contextMenu.addItem(new DefaultContextMenuItem("Exit", "EXIT"));
        return contextMenu;
    }

    protected ContextMenu createImageContextMenu() {
        DefaultContextMenu contextMenu = new DefaultContextMenu();
        contextMenu.addItem(new DefaultContextMenuItem("Special", "Special"));
        contextMenu.addItem(new DefaultContextMenuItem("menu", "menu"));
        contextMenu.addItem(new DefaultContextMenuItem("for", "for"));
        contextMenu.addItem(new DefaultContextMenuItem("the", "the"));
        contextMenu.addItem(new DefaultContextMenuItem("Image", "Image"));
        return contextMenu;
    }

    private void createHUD(SceneGraph sceneGraph, Sized2iRO canvasRes) {
        HUD hud = new HUD(canvasRes, 800.0f);
        ContextMenu contextMenu = this.createMainContextMenu();
        contextMenu.addContextMenuListener(this);
        hud.setContextMenu(contextMenu);
        Image image = new Image(100.0f, 100.0f, "stone.jpg");
        ContextMenu contextMenu2 = this.createImageContextMenu();
        contextMenu2.addContextMenuListener(this);
        image.setContextMenu(contextMenu2);
        this.contextMenu = contextMenu2;
        Panel p = new Panel(300.0f, 300.0f);
        p.addWidgetCentered(image);
        hud.getContentPane().addWidgetCentered(p);
        sceneGraph.addHUD(hud);
    }

    public HUDContextMenuTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createHUD(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
    }

    public static void main(String[] args) throws Throwable {
        HUDContextMenuTest test = new HUDContextMenuTest(HUDContextMenuTest.parseCommandLine(args));
        test.begin();
    }
}

