/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.FPSCounter;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase demonstrates the performance of a NumberLabel Widget."}, authors={"Marvin Froehlich (aka Qudus)"})
public class NumberLabelTest
extends Xith3DTest {
    private static final float PADDING_X = 20.0f;
    private static final float PADDING_Y = 20.0f;
    private static final float LABEL_WIDTH = 50.0f;
    private static final float LABEL_HEIGHT = 20.0f;
    private static final float LABEL_GAP_X = 26.0f;
    private static final float LABEL_GAP_Y = 10.0f;
    private static final long MIN_INTERVAL = 300000L;
    private static final long MAX_INTERVAL = 2000000L;
    private static final Colorf LABEL_BACKGROUND = null;
    private static final TextAlignment LABEL_ALIGNMENT = TextAlignment.TOP_LEFT;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    void addCounterTextLabel(HUDFont font, Colorf color, float offsetX, float offsetY, WidgetContainer container, long countInterval) {
        boolean initialValue = false;
        final Label label = new Label(50.0f, 20.0f, String.valueOf(0), font, color, LABEL_ALIGNMENT);
        if (LABEL_BACKGROUND != null) {
            label.setBackgroundColor(LABEL_BACKGROUND);
        }
        container.addWidget(label, offsetX, offsetY);
        this.getOperationScheduler().addInterval(new Interval(countInterval){
            private int numberValue;
            {
                super(x0);
                this.numberValue = 0;
            }

            protected void onIntervalHit(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                label.setText(String.valueOf(++this.numberValue));
            }
        });
    }

    void addCounterFPSCounter(HUDFont font, Colorf color, float offsetX, float offsetY, WidgetContainer container, long countInterval) {
        boolean initialValue = false;
        final FPSCounter counter = new FPSCounter(50.0f, 20.0f);
        counter.setFont(font);
        counter.setFontColor(color);
        counter.setDecimalSeparator('\u0000');
        container.addWidget(counter, offsetX, offsetY);
        this.getOperationScheduler().addInterval(new Interval(countInterval){
            private int numberValue;
            {
                super(x0);
                this.numberValue = 0;
            }

            protected void onIntervalHit(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                counter.onFPSCountIntervalHit(++this.numberValue);
            }
        });
    }

    private void addHUDLabels(Xith3DEnvironment env, Sized2iRO resolution, HUDFont font) {
        HUD hud = new HUD(resolution, 800.0f);
        int numLabelsX = (int)Math.floor((hud.getResX() - 20.0f + 26.0f) / 76.0f);
        int numLabelsY = (int)Math.floor((hud.getResY() - 20.0f + 10.0f) / 30.0f);
        long deltaIntervalX = 1700000L / (long)(numLabelsX - 1);
        long deltaIntervalY = 1700000L / (long)(numLabelsY - 1);
        long M = (long)(numLabelsX - 1) * deltaIntervalX + (long)(numLabelsY - 1) * deltaIntervalY;
        deltaIntervalX = deltaIntervalX * 1700000L / M;
        deltaIntervalY = deltaIntervalY * 1700000L / M;
        float x = 20.0f;
        float y = 20.0f;
        for (int j = 0; j < numLabelsY; ++j) {
            x = 20.0f;
            for (int i = 0; i < numLabelsX; ++i) {
                long interval = 300000L + (long)i * deltaIntervalX + (long)j * deltaIntervalY;
                this.addCounterTextLabel(font, Colorf.RED, x, y, hud.getContentPane(), interval);
                x += 76.0f;
            }
            y += 30.0f;
        }
        env.addHUD(hud);
    }

    private void createSceneGraph(Xith3DEnvironment env, Sized2iRO resolution) throws Exception {
        HUDFont font = HUDFont.getFont("DejaVu Sans Mono", HUDFont.PLAIN, 18);
        this.addHUDLabels(env, resolution, font);
    }

    public NumberLabelTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        NumberLabelTest test = new NumberLabelTest(NumberLabelTest.parseCommandLine(args));
        test.begin();
    }
}

