/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.swingui.UIEventAdapter;
import org.xith3d.ui.swingui.UIWindow;
import org.xith3d.ui.swingui.UIWindowManager;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test to demonstrate SwingUI."}, authors={"Yuri Vl. Gushchin (aka YVG)"})
public class SwingOverlayTest
extends Xith3DTest {
    private View view;
    private UIWindowManager windowMgr;
    private Material mat;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.windowMgr.newFrame(this.view);
    }

    private void init3DScene(Xith3DEnvironment env) {
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        TransformGroup scaleTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        scaleTransform.setTransform(t);
        testRotateYGroup.addChild(scaleTransform);
        AmbientLight light = new AmbientLight(true, Colorf.BLUE);
        scaleTransform.addChild(light);
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg");
        this.mat = new Material();
        this.mat.setAmbientColor(Colorf.createGray(0.75f));
        this.mat.setLightingEnabled(true);
        Rectangle rect = new Rectangle(0.6f, 0.6f, Colorf.WHITE);
        StaticTransform.translate(rect, -0.4f, -0.4f, 0.0f);
        Appearance app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        scaleTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, Colorf.RED);
        StaticTransform.translate(rect, 0.4f, -0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        scaleTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, Colorf.GREEN);
        StaticTransform.translate(rect, -0.4f, 0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        scaleTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, Colorf.BLUE);
        StaticTransform.translate(rect, 0.4f, 0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        scaleTransform.addChild(rect);
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        a.setMaterial(this.mat);
        Cube cube = new Cube(0.8f, a);
        StaticTransform.translate(cube, 0.0f, 0.0f, -0.6f);
        scaleTransform.addChild(cube);
        env.addPerspectiveBranch().getBranchGroup().addChild(testRotateYGroup);
        this.getAnimator().addAnimatableObject(testRotateYGroup);
    }

    private void initGUI(SceneGraph sg, Canvas3D canvas) {
        this.windowMgr = new UIWindowManager(canvas);
        TestWindow testWindow = new TestWindow(100, 200);
        this.windowMgr.addOverlay(testWindow);
        this.windowMgr.setPosition(testWindow, 10, 10);
        this.windowMgr.setVisible(testWindow, true);
        UIEventAdapter eventAdapter = new UIEventAdapter(this.windowMgr);
        Component c = (Component)canvas.getPeer().getComponent();
        c.addKeyListener(eventAdapter);
        c.addMouseListener(eventAdapter);
        c.addMouseMotionListener(eventAdapter);
        c.setFocusable(true);
        sg.addRenderPass(this.windowMgr);
    }

    public SwingOverlayTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        if (!arguments.getOpenGLLayer().isAWTorSwing()) {
            throw new IllegalArgumentException("The UIWindowManager can only be used with AWT or Swing based OpenGLLayers. (" + arguments.getOpenGLLayer() + " was not accepted.)");
        }
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        this.view = env.getView();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.init3DScene(env);
        this.initGUI(env, canvas);
    }

    public static void main(String[] args) throws Throwable {
        SwingOverlayTest test = new SwingOverlayTest(SwingOverlayTest.parseCommandLine(args));
        test.begin();
    }

    private class TestWindow
    extends UIWindow {
        private JComponent buildGUI(int width, int height) {
            JPanel p = new JPanel();
            p.setDoubleBuffered(true);
            p.setBounds(0, 0, width, height);
            p.setBackground(Color.DARK_GRAY);
            final JButton lightButton = new JButton();
            lightButton.setText("Lighting Off");
            lightButton.setMargin(new Insets(0, 0, 0, 0));
            lightButton.setPreferredSize(new Dimension(90, 25));
            lightButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingOverlayTest.this.mat.setLightingEnabled(!SwingOverlayTest.this.mat.isLightingEnabled());
                    lightButton.setText(SwingOverlayTest.this.mat.isLightingEnabled() ? "Lighting Off" : "Lighting On");
                }
            });
            p.add(lightButton);
            JButton exitButton = new JButton();
            exitButton.setPreferredSize(new Dimension(80, 25));
            exitButton.setText("Exit");
            exitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
            p.add(exitButton);
            JTextField textField = new JTextField("Test Text", 6);
            textField.setPreferredSize(new Dimension(80, 25));
            p.add(textField);
            return p;
        }

        public TestWindow(int width, int height) {
            super(width, height, false, false);
            this.setRoot(this.buildGUI(width, height));
        }
    }
}

