/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.ui;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.borders.ColoredBorder;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.listeners.ScrollbarListener;
import org.xith3d.ui.hud.listeners.SliderListener;
import org.xith3d.ui.hud.listmodels.StateButtonListModel;
import org.xith3d.ui.hud.listmodels.TextListModel;
import org.xith3d.ui.hud.utils.ButtonGroup;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.Checkbox;
import org.xith3d.ui.hud.widgets.ComboBox;
import org.xith3d.ui.hud.widgets.Dialog;
import org.xith3d.ui.hud.widgets.Frame;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.List;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.ProgressBar;
import org.xith3d.ui.hud.widgets.RadioButton;
import org.xith3d.ui.hud.widgets.ScrollPanel;
import org.xith3d.ui.hud.widgets.Scrollbar;
import org.xith3d.ui.hud.widgets.Slider;
import org.xith3d.ui.hud.widgets.TextField;
import org.xith3d.ui.hud.widgets.ToggleButton;
import org.xith3d.ui.hud.widgets.Widget3D;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase proofs many Widget types."}, authors={"Marvin Froehlich (aka Qudus)"})
public class WidgetsTest1
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private RenderPass create3DScene() {
        BranchGroup bg = new BranchGroup();
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.3f, 0.2f, 0.0f, TransformationDirectives.AxisOrder.XYZ));
        Sphere sph = new Sphere(2.0f, 32, 32, "deathstar.jpg");
        sph.setName("the rotating sphere");
        Material mat = new Material();
        mat.setEmissiveColor(Colorf.GRAY90);
        mat.setColorTarget(Material.NONE);
        mat.setLightingEnabled(true);
        sph.getAppearance().setMaterial(mat);
        rg.addChild(sph);
        bg.addChild(rg);
        bg.addChild(new DirectionalLight(true, Colorf.WHITE, new Vector3f(-1.0f, -1.0f, -1.0f)));
        this.getAnimator().addAnimatableObject(rg);
        return RenderPass.createPerspective(bg);
    }

    private void createHUD(Sized2iRO resolution, Xith3DEnvironment env) {
        final HUD hud = new HUD(resolution, 800.0f);
        WidgetContainer contentPane = hud.getContentPane();
        ComboBox combo = ComboBox.newTextCombo(200.0f, 22.0f);
        for (int i = 0; i < 20; ++i) {
            combo.getModel().addItem("Combo item " + i);
        }
        combo.getModel().setSelectedIndex(0);
        combo.getModel().markListDirty();
        contentPane.addWidget(combo, 100.0f, 50.0f);
        Button button = new Button(100.0f, 40.0f, "Open Window");
        button.addButtonListener(new ButtonListener(){

            public void onButtonClicked(AbstractButton button, Object userObject) {
                Dialog frame = new Dialog((WidgetContainer)Frame.createDefaultContentPane(300.0f, 300.0f), "My First Window");
                frame.getContentPane().addWidget(new Button(50.0f, 30.0f, "hello"), 249.0f, 269.0f);
                hud.addWindow(frame);
            }
        });
        contentPane.addWidget(button, 100.0f, 100.0f);
        ToggleButton toggleButton = new ToggleButton(100.0f, 40.0f, "hallo");
        contentPane.addWidget(toggleButton, 210.0f, 100.0f);
        Button button2 = new Button(100.0f, 40.0f, "CoolImageButtonNormal.png", "CoolImageButtonHovered.png", "CoolImageButtonPressed.png");
        contentPane.addWidget(button2, 100.0f, 150.0f);
        ToggleButton toggleButton2 = new ToggleButton(100.0f, 40.0f, "CoolImageButtonNormal.png", "CoolImageButtonHovered.png", "CoolImageButtonPressed.png");
        contentPane.addWidget(toggleButton2, 210.0f, 150.0f);
        Image image1 = new Image(100.0f, 40.0f, "precision.png");
        contentPane.addWidget(image1, 100.0f, 200.0f);
        Image image2 = new Image(100.0f, 40.0f, "precision2.png");
        image2.setBorder(HUD.getTheme().getLoweredBevelBorderDescription());
        contentPane.addWidget(image2, 100.0f, 250.0f);
        Checkbox cb = new Checkbox(100.0f, 20.0f, "Check it out!");
        contentPane.addWidget(cb, 100.0f, 300.0f);
        ButtonGroup bg = new ButtonGroup();
        RadioButton rb = new RadioButton(135.0f, 20.0f, "Turn up the radio!");
        bg.addStateButton(rb);
        contentPane.addWidget(rb, 100.0f, 320.0f);
        rb = new RadioButton(135.0f, 20.0f, "Turn up the radio2!");
        bg.addStateButton(rb);
        contentPane.addWidget(rb, 100.0f, 340.0f);
        rb = new RadioButton(135.0f, 20.0f, "Turn up the radio3!");
        bg.addStateButton(rb);
        contentPane.addWidget(rb, 100.0f, 360.0f);
        rb = new RadioButton(135.0f, 20.0f, "Turn up the radio4!");
        bg.addStateButton(rb);
        contentPane.addWidget(rb, 100.0f, 380.0f);
        Label iconLabel = new Label(-1.0f, -1.0f, "Label with\nIcon");
        iconLabel.setBackgroundColor(Colorf.GREEN);
        iconLabel.setAlignment(TextAlignment.TOP_RIGHT);
        iconLabel.setIcon("userconfig_48x48.png");
        contentPane.addWidget(iconLabel, 50.0f, 410.0f);
        TextField tf = new TextField(200.0f, 24.0f, "Type text here.");
        contentPane.addWidget(tf, 400.0f, 70.0f);
        Panel panel0 = Panel.createContentPane(200.0f, 100.0f);
        Panel panel = new Panel(180.0f, 80.0f);
        panel.setBorder(HUD.getTheme().getRoundedCornersBorderDescription());
        HUDFont font = HUDFont.getFont("DejaVu Sans Mono", HUDFont.PLAIN, 18);
        Label label = new Label(150.0f, 40.0f, "Test Text\nin two lines", font, Colorf.BLACK, TextAlignment.CENTER_CENTER);
        panel.addWidgetCentered(label);
        panel0.addWidgetCentered(panel);
        contentPane.addWidget(panel0, 400.0f, 100.0f);
        ScrollPanel scrollPanel = new ScrollPanel(true, 200.0f, 200.0f, Colorf.GREEN);
        scrollPanel.setPadding(1);
        scrollPanel.setBorder(new ColoredBorder(3, Colorf.RED));
        Label l1 = new Label(false, 100.0f, 20.0f, "lightweight", null, null, TextAlignment.CENTER_RIGHT);
        scrollPanel.addWidget(l1, 92.0f, 100.0f);
        l1.setBackgroundColor(Colorf.YELLOW);
        Label l2 = new Label(true, 100.0f, 20.0f, "heavyweight");
        l2.setBackgroundColor(Colorf.RED);
        scrollPanel.addWidget(l2, 0.0f, 230.0f);
        contentPane.addWidget(scrollPanel, 270.0f, 220.0f);
        TextListModel listModel = new TextListModel();
        listModel.addItem("0hello");
        listModel.addItem("1lala");
        listModel.addItem("2Blah blub");
        listModel.addItem("3A longer line1");
        listModel.addItem("4A longer line2");
        listModel.addItem("5A longer line3");
        listModel.addItem("6A longer line4");
        listModel.addItem("7A longer line5");
        listModel.addItem("8A longer line6");
        listModel.addItem("9A longer line7");
        listModel.addItem("10A longer line8");
        listModel.addItem("11A longer line9");
        listModel.setSelectedIndex(2);
        List list = new List(120.0f, 120.0f, listModel);
        contentPane.addWidget(list, 620.0f, 70.0f);
        list.setTopIndex(3);
        StateButtonListModel listModel2 = new StateButtonListModel();
        listModel2.addItem("0hello");
        listModel2.addItem("1lala");
        listModel2.addItem("2Blah blub");
        listModel2.addItem("3A longer line1");
        listModel2.addItem("4A longer line2");
        listModel2.addItem("5A longer line3");
        listModel2.addItem("6A longer line4");
        listModel2.addItem("7A longer line5");
        listModel2.addItem("8A longer line6");
        listModel2.addItem("9A longer line7");
        listModel2.addItem("10A longer line8");
        listModel2.addItem("11A longer line9");
        listModel.setSelectedIndex(2);
        List list2 = new List(120.0f, 120.0f, listModel2);
        contentPane.addWidget(list2, 620.0f, 200.0f);
        list2.setTopIndex(3);
        Label lfs20 = new Label(100.0f, 23.0f, "Hellog\u00d6", HUDFont.getFont("Verdana", HUDFont.PLAIN, 20), Colorf.YELLOW, TextAlignment.CENTER_CENTER);
        lfs20.setBackgroundColor(Colorf.RED);
        contentPane.addWidget(lfs20, 500.0f, 230.0f);
        Label lfs16 = new Label(100.0f, 18.0f, "Hellog\u00d6", HUDFont.getFont("Verdana", HUDFont.PLAIN, 16), Colorf.YELLOW, TextAlignment.CENTER_CENTER);
        lfs16.setBackgroundColor(Colorf.GREEN);
        contentPane.addWidget(lfs16, 500.0f, 280.0f);
        final ProgressBar pb = new ProgressBar(200.0f, 23.0f, 0, 20);
        pb.setValue(5);
        contentPane.addWidget(pb, 10.0f, hud.getResY() - 60.0f);
        Button btDec = new Button(28.0f, 23.0f, "dec");
        btDec.addButtonListener(new ButtonListener(){

            public void onButtonClicked(AbstractButton button, Object userObject) {
                pb.setValue(pb.getValue() - 1);
            }
        });
        contentPane.addWidget(btDec, 220.0f, pb.getTop());
        Button btInc = new Button(28.0f, 23.0f, "inc");
        btInc.addButtonListener(new ButtonListener(){

            public void onButtonClicked(AbstractButton button, Object userObject) {
                pb.setValue(pb.getValue() + 1);
            }
        });
        contentPane.addWidget(btInc, 250.0f, pb.getTop());
        Slider sl = new Slider(200.0f);
        sl.setMinMaxAndValue(0, 20, 0);
        contentPane.addWidget(sl, 10.0f, hud.getResY() - 26.0f);
        final Label slValue = new Label(30.0f, 16.0f, String.valueOf(sl.getValue()));
        contentPane.addWidget(slValue, 220.0f, hud.getResY() - 26.0f);
        sl.addSliderListener(new SliderListener(){

            public void onSliderValueChanged(Slider slider, int newValue) {
                slValue.setText(String.valueOf(newValue));
            }
        });
        Scrollbar sbH = new Scrollbar(200.0f, Scrollbar.Direction.HORIZONTAL);
        sbH.setMinMaxAndValue(0, 20, 0, 5);
        contentPane.addWidget(sbH, hud.getResX() - 50.0f - sbH.getWidth(), hud.getResY() - 26.0f);
        final Label sbHValue = new Label(30.0f, 16.0f, String.valueOf(sbH.getValue()));
        contentPane.addWidget(sbHValue, hud.getResX() - 40.0f, hud.getResY() - 26.0f);
        sbH.addScrollbarListener(new ScrollbarListener(){

            public void onScrollbarValueChanged(Scrollbar scrollbar, int newValue) {
                sbHValue.setText(String.valueOf(newValue));
            }
        });
        Scrollbar sbV = new Scrollbar(200.0f, Scrollbar.Direction.VERTICAL);
        sbV.setMinMaxAndValue(0, 20, 0, 5);
        sbV.setSmoothScrolling(false);
        contentPane.addWidget(sbV, hud.getResX() - 26.0f, hud.getResY() - 100.0f - sbV.getHeight());
        final Label sbVValue = new Label(30.0f, 16.0f, String.valueOf(sbV.getValue()));
        contentPane.addWidget(sbVValue, hud.getResX() - 40.0f, hud.getResY() - 66.0f);
        sbV.addScrollbarListener(new ScrollbarListener(){

            public void onScrollbarValueChanged(Scrollbar scrollbar, int newValue) {
                sbVValue.setText(String.valueOf(newValue));
            }
        });
        RenderPass td = this.create3DScene();
        Widget3D w3d = new Widget3D(256.0f, 192.0f, td.getConfig());
        w3d.setBorder(new ColoredBorder(2, Colorf.YELLOW));
        contentPane.addWidget(w3d, 500.0f, 330.0f);
        env.addRenderPass(td);
        env.addHUD(hud);
    }

    private void createSceneGraph(Xith3DEnvironment env, Sized2iRO resolution) {
        this.createHUD(resolution, env);
    }

    public WidgetsTest1(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("HUD");
        this.createSceneGraph(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        WidgetsTest1 test = new WidgetsTest1(WidgetsTest1.parseCommandLine(args));
        test.begin();
    }
}

