/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.util;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;

public class RotatingSphere
extends RotatableGroup {
    private Colorf currentColor = null;
    private DirectionalLight light = null;

    public void switchColor(Colorf c) {
        this.currentColor = c;
        this.light.setColor(this.currentColor);
    }

    public void switchColor() {
        if (this.currentColor == Colorf.GREEN) {
            this.switchColor(Colorf.RED);
        } else {
            this.switchColor(Colorf.GREEN);
        }
    }

    private void initSphere(float radius) {
        Appearance a = new Appearance();
        Texture2D t = TextureLoader.getInstance().getTexture("deathstar.jpg");
        a.setTexture(t);
        Material mat = new Material();
        mat.setEmissiveColor(Colorf.GRAY90);
        mat.setColorTarget(Material.NONE);
        mat.setLightingEnabled(true);
        a.setMaterial(mat);
        Sphere sph = new Sphere(radius, 32, 32, a);
        sph.setName("the rotating sphere");
        this.light = new DirectionalLight(true, Colorf.YELLOW, new Vector3f(-1.0f, -1.0f, -1.0f));
        this.switchColor();
        this.addChild(sph);
        this.addChild(this.light);
    }

    public RotatingSphere(TransformationDirectives rotDirecs, float radius) {
        super(rotDirecs);
        this.initSphere(radius);
    }

    public RotatingSphere(TransformationDirectives rotDirecs) {
        this(rotDirecs, 2.0f);
    }

    public RotatingSphere(float radius) {
        this(new TransformationDirectives(0.3f, 0.2f, 0.0f, TransformationDirectives.AxisOrder.XYZ), radius);
    }

    public RotatingSphere() {
        this(2.0f);
    }
}

