/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.xith3d.input.modules.fpih.FPIHConfig;

public class TestFPIHConfig
extends FPIHConfig {
    private Boolean initializing = true;
    private final File confFile = this.getConfFile(TestFPIHConfig.getTestName());

    private File getPropertiesFileFolder() {
        File userHomeDir = new File((String)System.getProperties().get("user.home"));
        return new File(userHomeDir, ".xith3d");
    }

    private File getConfFile(String testName) {
        File xith3dConfigFolder = this.getPropertiesFileFolder();
        return new File(xith3dConfigFolder, "fpih_config." + testName + ".properties");
    }

    private void saveSettings() {
        if (this.initializing == null || this.initializing.booleanValue()) {
            return;
        }
        Properties props = new Properties();
        props.setProperty("MouseXSpeed", String.valueOf(this.getMouseXSpeed()));
        props.setProperty("MouseYSpeed", String.valueOf(this.getMouseYSpeed()));
        props.setProperty("MovementSpeedForward", String.valueOf(this.getMovementSpeedForward()));
        props.setProperty("MovementSpeedBackward", String.valueOf(this.getMovementSpeedBackward()));
        props.setProperty("MovementSpeedSideward", String.valueOf(this.getMovementSpeedSideward()));
        try {
            props.store(new FileOutputStream(this.confFile), "FirstPersonInputHandler config values");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadSettings() {
        this.initializing = true;
        if (this.confFile.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(this.confFile));
                if (props.containsKey("MouseXSpeed")) {
                    this.setMouseXSpeed(Float.parseFloat(props.getProperty("MouseXSpeed")));
                }
                if (props.containsKey("MouseYSpeed")) {
                    this.setMouseYSpeed(Float.parseFloat(props.getProperty("MouseYSpeed")));
                }
                if (props.containsKey("MovementSpeedForward")) {
                    this.setMovementSpeedForward(Float.parseFloat(props.getProperty("MovementSpeedForward")));
                }
                if (props.containsKey("MovementSpeedBackward")) {
                    this.setMovementSpeedBackward(Float.parseFloat(props.getProperty("MovementSpeedBackward")));
                }
                if (props.containsKey("MovementSpeedSideward")) {
                    this.setMovementSpeedSideward(Float.parseFloat(props.getProperty("MovementSpeedSideward")));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.initializing = false;
    }

    protected void onSettingChanged(String setting, float oldValue, float value) {
        super.onSettingChanged(setting, oldValue, value);
        this.saveSettings();
    }

    private static String getTestName() {
        boolean b = false;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (b) {
                String[] parts = ste.getClassName().split("\\.");
                return parts[parts.length - 1];
            }
            if (!ste.getMethodName().equals("getFPIHConfig")) continue;
            b = true;
        }
        return "";
    }

    public TestFPIHConfig() {
        this.loadSettings();
        if (!this.confFile.exists()) {
            this.saveSettings();
        }
    }

    public TestFPIHConfig(float mouseXSpeed, float mouseYSpeed, float movementSpeedForeward, float movementSpeedBackward, float movementSpeedSideward) {
        super(mouseXSpeed, mouseYSpeed, movementSpeedForeward, movementSpeedBackward, movementSpeedSideward);
        if (mouseYSpeed >= 0.0f && !this.confFile.exists()) {
            this.setMouseYSpeed(-mouseYSpeed);
        }
        this.loadSettings();
        if (this.getMouseXSpeed() != mouseXSpeed) {
            this.setMouseXSpeed(mouseXSpeed);
        }
        if (Math.abs(this.getMouseYSpeed()) != Math.abs(mouseYSpeed)) {
            this.setMouseYSpeed(mouseYSpeed);
        }
        if (this.getMovementSpeedForward() != movementSpeedForeward) {
            this.setMovementSpeedForward(movementSpeedForeward);
        }
        if (this.getMovementSpeedBackward() != movementSpeedBackward) {
            this.setMovementSpeedBackward(movementSpeedBackward);
        }
        if (this.getMovementSpeedSideward() != movementSpeedSideward) {
            this.setMovementSpeedSideward(movementSpeedSideward);
        }
        if (!this.confFile.exists()) {
            this.saveSettings();
        }
    }

    public TestFPIHConfig(float mouseXSpeed, float mouseYSpeed, float movementSpeed) {
        this(mouseXSpeed, mouseYSpeed, movementSpeed, movementSpeed, movementSpeed);
    }
}

