/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.util;

import org.jagatoo.input.actions.LabeledInputAction;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.opengl.enums.TestFunction;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TriangleFanArray;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.layout.GridLayout;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.text2d.TextAlignment;

public class TestUtils {
    private static final RenderingAttributes RENDERING_ATTRIBUTES = new RenderingAttributes();
    private static final float HUD_RES_X = 800.0f;
    private static final float HUD_RES_Y = 600.0f;

    public static ResourceLocator createResourceLocator() {
        return ResourceLocator.create("test-resources/");
    }

    private static Shape3D createTextureGeom(float x, float y, float width, float height, Texture2D texture) {
        TriangleFanArray geom = new TriangleFanArray(4);
        geom.setCoordinate(0, x, -y - height, 0.0f);
        geom.setCoordinate(1, x + width, -y - height, 0.0f);
        geom.setCoordinate(2, x + width, -y, 0.0f);
        geom.setCoordinate(3, x, -y, 0.0f);
        geom.setTextureCoordinate(0, 0, 0.0f, 0.0f);
        geom.setTextureCoordinate(0, 1, 1.0f, 0.0f);
        geom.setTextureCoordinate(0, 2, 1.0f, 1.0f);
        geom.setTextureCoordinate(0, 3, 0.0f, 1.0f);
        Appearance app = new Appearance(texture);
        app.setRenderingAttributes(RENDERING_ATTRIBUTES);
        return new Shape3D(geom, app);
    }

    public static void displayDebugTextures(Sized2iRO hudSize, float texWidth, RenderPass renderPass, Texture2D ... textures) {
        float texHeight = texWidth / hudSize.getAspect();
        if (textures.length <= 4) {
            if (textures.length >= 1) {
                renderPass.getBranchGroup().addChild(TestUtils.createTextureGeom(10.0f, 10.0f, texWidth, texHeight, textures[0]));
            }
            if (textures.length >= 2) {
                renderPass.getBranchGroup().addChild(TestUtils.createTextureGeom(800.0f - texWidth - 10.0f, 10.0f, texWidth, texHeight, textures[1]));
            }
            if (textures.length >= 3) {
                renderPass.getBranchGroup().addChild(TestUtils.createTextureGeom(10.0f, 600.0f - texHeight - 10.0f, texWidth, texHeight, textures[2]));
            }
            if (textures.length >= 4) {
                renderPass.getBranchGroup().addChild(TestUtils.createTextureGeom(800.0f - texWidth - 10.0f, 600.0f - texHeight - 10.0f, texWidth, texHeight, textures[3]));
            }
        }
    }

    public static RenderPass displayDebugTextures(Sized2iRO hudSize, float texWidth, SceneGraph sg, Texture2D ... textures) {
        RenderPass renderPass = RenderPass.create2D(800, 600);
        TestUtils.displayDebugTextures(hudSize, texWidth, renderPass, textures);
        if (sg != null) {
            sg.addRenderPass(renderPass);
        }
        return renderPass;
    }

    public static void displayInputBindings(DeviceComponent[] comps, String[] descriptions, HUD hud) {
        if (comps == null) {
            comps = new DeviceComponent[]{};
        }
        if (descriptions == null) {
            descriptions = new String[]{};
        }
        Panel panel = new Panel(100.0f, 100.0f, new Colorf(Colorf.GRAY60, 0.3f));
        GridLayout layout = new GridLayout(comps.length + 1, 2, 10.0f, 2.0f, 10.0f, 10.0f, 10.0f, 10.0f);
        panel.setLayout(layout);
        HUDFont font = HUDFont.getFont("DejaVu Sans Mono", HUDFont.PLAIN, 12);
        for (int i = 0; i < comps.length; ++i) {
            panel.addWidget(new Label(-1.0f, -1.0f, comps[i] == null ? "---" : comps[i].getName(), font, Colorf.WHITE, TextAlignment.CENTER_LEFT));
            panel.addWidget(new Label(-1.0f, -1.0f, descriptions[i], font, Colorf.WHITE, TextAlignment.CENTER_LEFT));
        }
        panel.addWidget(new Label(-1.0f, -1.0f, "ESC", font, Colorf.WHITE, TextAlignment.CENTER_LEFT));
        panel.addWidget(new Label(-1.0f, -1.0f, "Exit", font, Colorf.WHITE, TextAlignment.CENTER_LEFT));
        hud.getContentPane().addWidget(panel);
        Dim2f dim = Dim2f.fromPool();
        float widthA = 0.0f;
        float widthB = 0.0f;
        for (int i = 0; i < comps.length + 1; ++i) {
            Label labelA = (Label)panel.getWidgets().get(i * 2 + 0);
            labelA.getMinimalSize(dim);
            if (dim.getWidth() > widthA) {
                widthA = dim.getWidth();
            }
            Label labelB = (Label)panel.getWidgets().get(i * 2 + 1);
            labelB.getMinimalSize(dim);
            if (!(dim.getWidth() > widthB)) continue;
            widthB = dim.getWidth();
        }
        layout.setColWeights(widthA, widthB);
        float width = layout.getBorderLeft() + widthA + layout.getHGap() + widthB + layout.getBorderRight();
        float height = layout.getBorderTop() + layout.getBorderBottom() + (dim.getHeight() + layout.getVGap()) * (float)(comps.length + 1);
        Dim2f.toPool(dim);
        panel.setSize(width, height);
        panel.setLocation(10.0f, hud.getResY() - 10.0f - height);
    }

    public static HUD displayInputBindings(Sized2iRO hudSize, DeviceComponent[] comps, String[] descriptions, SceneGraph sg) {
        HUD hud = new HUD(hudSize, 800.0f);
        TestUtils.displayInputBindings(comps, descriptions, hud);
        if (sg != null) {
            sg.addHUD(hud);
        }
        return hud;
    }

    public static HUD displayInputBindings(Sized2iRO hudSize, DeviceComponent[] comps, LabeledInputAction[] actions, SceneGraph sg) {
        if (comps.length == 0) {
            return null;
        }
        String[] descriptions = new String[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            descriptions[i] = actions[i].getLocalizedText();
        }
        return TestUtils.displayInputBindings(hudSize, comps, descriptions, sg);
    }

    public static long dumpAction(String action) {
        long t0 = System.currentTimeMillis();
        System.out.print(action);
        return t0;
    }

    public static void dumpDoneIn(long t0) {
        System.out.println("done in " + (float)(System.currentTimeMillis() - t0) / 1000.0f + " seconds.");
    }

    static {
        RENDERING_ATTRIBUTES.setDepthTestFunction(TestFunction.ALWAYS);
    }
}

