/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import java.util.List;
import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.BackgroundSettableWidget;
import org.xith3d.ui.hud.base.ListModel;
import org.xith3d.ui.hud.base.PaddingSettable;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.listeners.ListSelectionListener;
import org.xith3d.ui.hud.utils.TileMode;
import org.xith3d.ui.text2d.TextAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractList
extends BackgroundSettableWidget
implements PaddingSettable {
    protected static final boolean DEFAULT_HEAVYWEIGHT = false;
    private ListModel model;

    protected void afterModelSetWidthItems(ListModel model) {
    }

    public void setModel(ListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        if (model == this.model) {
            return;
        }
        if (this.model != null) {
            for (Widget widget : this.model.getUsedWidgets()) {
                this.getWidgetAssembler().removeWidget(widget);
            }
            this.model.setList(null);
        }
        this.model = model;
        this.model.setList(this);
        for (Widget widget : model.getUsedWidgets()) {
            this.getWidgetAssembler().addUnmanagedWidget(widget);
        }
        if (this.getHUD() != null && model.getItemsCount() > 0) {
            this.afterModelSetWidthItems(model);
        }
    }

    public ListModel getModel() {
        return this.model;
    }

    @Override
    public final boolean setPadding(int padding) {
        return this.setPadding(padding, padding, padding, padding);
    }

    public abstract void setHoverBackgroundColor(Colorf var1);

    public abstract Colorf getHoverBackgroundColor();

    public abstract void setSelectionBackgroundColor(Colorf var1);

    public abstract Colorf getSelectionBackgroundColor();

    public abstract void setAlignment(TextAlignment var1);

    public abstract TextAlignment getAlignment();

    public abstract void addSelectionListener(ListSelectionListener var1);

    public abstract void removeSelectionListener(ListSelectionListener var1);

    public void setSelectedIndex(int itemIndex) {
        ListModel model = this.getModel();
        model.setSelectedIndex(itemIndex);
        model.markListDirty();
    }

    public final int getSelectedIndex() {
        return this.getModel().getSelectedIndex();
    }

    public Object getSelectedItem() {
        return this.getModel().getSelectedItem();
    }

    public int findItem(Object item) {
        ListModel model = this.getModel();
        int n = model.getItemsCount();
        for (int i = 0; i < n; ++i) {
            if (!model.getItem(i).equals(item)) continue;
            return i;
        }
        return -1;
    }

    public final int selectPreviousItem() {
        int selIndex = this.getSelectedIndex();
        if (selIndex > 0) {
            this.setSelectedIndex(--selIndex);
        }
        return selIndex;
    }

    public final int selectNextItem() {
        int selIndex = this.getSelectedIndex();
        if (selIndex < this.getItemsCount() - 1) {
            this.setSelectedIndex(++selIndex);
        }
        return selIndex;
    }

    public abstract void setAddItemSetsSelectedItem(boolean var1);

    public abstract boolean addItemSetsSelectedItem();

    public abstract void scrollSelectedItemIntoView();

    protected void afterItemAddedToEnd() {
    }

    protected void afterFirstItemAdded() {
    }

    public Object addItem(int index, Object item) {
        ListModel model = this.getModel();
        model.addItem(index, item);
        if (this.addItemSetsSelectedItem()) {
            this.setSelectedIndex(index);
        } else if (this.getSelectedIndex() >= index) {
            this.setSelectedIndex(this.getSelectedIndex() + 1);
        }
        if (index == model.getItemsCount() - 2) {
            this.afterItemAddedToEnd();
        }
        model.markListDirty();
        if (this.getHUD() != null && model.getItemsCount() == 1) {
            this.afterFirstItemAdded();
        }
        return item;
    }

    public final int addItem(Object item) {
        int index = this.getItemsCount();
        this.addItem(index, item);
        return index;
    }

    public void addItems(List<?> items) {
        ListModel model = this.getModel();
        int index = model.getItemsCount();
        model.addItems(items);
        if (this.addItemSetsSelectedItem()) {
            this.setSelectedIndex(index);
        }
        this.afterItemAddedToEnd();
        model.markListDirty();
        if (this.getHUD() != null && model.getItemsCount() == items.size()) {
            this.afterFirstItemAdded();
        }
    }

    public void addItems(Object[] items) {
        ListModel model = this.getModel();
        int index = model.getItemsCount();
        model.addItems(items);
        if (this.addItemSetsSelectedItem()) {
            this.setSelectedIndex(index);
        }
        this.afterItemAddedToEnd();
        model.markListDirty();
        if (this.getHUD() != null && model.getItemsCount() == items.length) {
            this.afterFirstItemAdded();
        }
    }

    public Object removeItem(int index) {
        ListModel model = this.getModel();
        Object item = model.removeItem(index);
        model.markListDirty();
        return item;
    }

    public void clear() {
        ListModel model = this.getModel();
        model.clear();
        model.markListDirty();
    }

    public final int getItemsCount() {
        return this.getModel().getItemsCount();
    }

    protected final Widget getWidget(float contentWidth, int itemIndex) {
        return this.getModel().getWidget(contentWidth, itemIndex);
    }

    public Object getItem(int index) {
        return this.getModel().getItem(index);
    }

    public abstract void setTopIndex(int var1);

    public abstract int getTopIndex();

    public abstract int getBottomIndex();

    protected void updateSizesAndMarkDirty() {
    }

    @Override
    protected void onAttachedToHUD(HUD hud) {
        super.onAttachedToHUD(hud);
        this.updateSizesAndMarkDirty();
    }

    protected AbstractList(boolean isHeavyWeight, Colorf backgroundColor, Texture2D backgroundTexture, TileMode tileMode, ListModel model) {
        super(isHeavyWeight, true, backgroundColor, backgroundTexture, tileMode);
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        this.setBackground(backgroundColor, backgroundTexture, tileMode);
        this.setModel(model);
        this.getWidgetAssembler().setPickDispatched(true);
    }

    protected AbstractList(boolean isHeavyWeight, float width, float height, Colorf backgroundColor, Texture2D backgroundTexture, TileMode tileMode, ListModel model) {
        super(isHeavyWeight, true, width, height, backgroundColor, backgroundTexture, tileMode);
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        this.setBackground(backgroundColor, backgroundTexture, tileMode);
        this.setModel(model);
        this.getWidgetAssembler().setPickDispatched(true);
    }
}

