/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import java.util.ArrayList;
import org.jagatoo.datatypes.Enableable;
import org.jagatoo.input.devices.components.MouseButton;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.listeners.WidgetStateListener;
import org.xith3d.ui.hud.utils.ButtonGroup;

public abstract class StateButton
extends Widget
implements Enableable {
    private boolean state = false;
    private final ArrayList<WidgetStateListener> listeners = new ArrayList(3);
    private ButtonGroup stateGroup = null;
    private boolean enabled = true;

    public void setStateGroup(ButtonGroup sg) {
        this.stateGroup = sg;
    }

    public final ButtonGroup getStateGroup() {
        return this.stateGroup;
    }

    protected final void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onButtonStateChanged(this, this.state, this.getUserObject());
        }
    }

    protected abstract void onExtendedStateChanged(boolean var1, boolean var2);

    public void setState(boolean state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        if (this.getStateGroup() != null && state) {
            this.getStateGroup().onButtonActivated(this);
        }
        this.onExtendedStateChanged(this.state, this.isHovered());
        this.notifyListeners();
    }

    public final boolean getState() {
        return this.state;
    }

    protected void onMouseEntered(boolean isTopMost, boolean hasFocus) {
        super.onMouseEntered(isTopMost, hasFocus);
        if (isTopMost) {
            this.onExtendedStateChanged(this.state, this.isHovered());
        }
    }

    protected void onMouseExited(boolean isTopMost, boolean hasFocus) {
        super.onMouseExited(isTopMost, hasFocus);
        if (isTopMost) {
            this.onExtendedStateChanged(this.state, this.isHovered());
        }
    }

    protected void cycleState() {
        this.setState(!this.getState());
    }

    protected void onMouseButtonPressed(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        super.onMouseButtonPressed(button, x, y, when, lastWhen, isTopMost, hasFocus);
        if (isTopMost && this.isEnabled()) {
            this.cycleState();
        }
    }

    public void addStateListener(WidgetStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeStateListener(WidgetStateListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract void setEnabledImpl(boolean var1);

    public final void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        this.setEnabledImpl(enabled);
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public StateButton(boolean isHeavyWeight, boolean hasWidgetAssembler, float width, float height) {
        super(isHeavyWeight, hasWidgetAssembler, width, height);
    }
}

