/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import java.util.ArrayList;
import java.util.Collections;
import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.devices.components.ControllerButton;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.types.twodee.Dim2i;
import org.openmali.vecmath2.Tuple2i;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.utils.HUDPickResult;
import org.xith3d.ui.hud.utils.LocalZIndexComparator;

public class WidgetAssembler {
    private static final LocalZIndexComparator Z_INDEX_COMPARATOR = new LocalZIndexComparator();
    private final Widget owner;
    private final ArrayList<Widget> managedWidgets = new ArrayList();
    private final ArrayList<Widget> widgets = new ArrayList();
    private boolean widgetsSorted = true;
    private int additionalContentLeft = 0;
    private int additionalContentTop = 0;
    private int additionalContentWidth = 0;
    private int additionalContentHeight = 0;
    private ArrayList<HUDPickResult> pickedWidgets = null;
    private Widget currentHoveredWidget = null;
    private Widget currentFocussedWidget = null;
    private boolean keyEventsDispatched = false;
    private boolean pickDispatched = false;

    final void setHUD(HUD hud) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            this.widgets.get(i).setHUD(hud);
        }
    }

    final void setContainer(WidgetContainer container) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            this.widgets.get(i).setContainer(container, this.owner);
        }
    }

    public void setAdditionalContentSize(int additionalContentLeft, int additionalContentTop, int additionalContentWidth, int additionalContentHeight) {
        this.additionalContentLeft = additionalContentLeft;
        this.additionalContentTop = additionalContentTop;
        this.additionalContentWidth = additionalContentWidth;
        this.additionalContentHeight = additionalContentHeight;
        this.owner.updateSizeFactors();
    }

    public final int getAdditionalContentLeft() {
        return this.additionalContentLeft;
    }

    public final int getAdditionalContentTop() {
        return this.additionalContentTop;
    }

    public final int getAdditionalContentWidth() {
        return this.additionalContentWidth;
    }

    public final int getAdditionalContentHeight() {
        return this.additionalContentHeight;
    }

    public final Widget getCurrentFocussedWidget() {
        return this.currentFocussedWidget;
    }

    public void setTransparency(float transparency, boolean childrenToo) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            Widget widget = this.widgets.get(i);
            if (widget instanceof WidgetContainer) {
                ((WidgetContainer)widget).setTransparency(transparency, childrenToo);
                continue;
            }
            widget.setTransparency(transparency);
        }
    }

    public void setKeyEventsDispatched(boolean b) {
        this.keyEventsDispatched = b;
    }

    public final boolean areKeyEventsDispatched() {
        return this.keyEventsDispatched;
    }

    public void onKeyPressed(Key key, int modifierMask, long when) {
        if (this.areKeyEventsDispatched() && this.currentFocussedWidget != null) {
            this.currentFocussedWidget.onKeyPressed(key, modifierMask, when);
        }
    }

    public void onKeyReleased(Key key, int modifierMask, long when) {
        if (this.areKeyEventsDispatched() && this.currentFocussedWidget != null) {
            this.currentFocussedWidget.onKeyReleased(key, modifierMask, when);
        }
    }

    public void onKeyTyped(char ch, int modifierMask, long when) {
        if (this.areKeyEventsDispatched() && this.currentFocussedWidget != null) {
            this.currentFocussedWidget.onKeyTyped(ch, modifierMask, when);
        }
    }

    public void onControllerButtonPressed(ControllerButton button, long when) {
        if (this.areKeyEventsDispatched() && this.currentFocussedWidget != null) {
            this.currentFocussedWidget.onControllerButtonPressed(button, when);
        }
    }

    public void onControllerButtonReleased(ControllerButton button, long when) {
        if (this.areKeyEventsDispatched() && this.currentFocussedWidget != null) {
            this.currentFocussedWidget.onControllerButtonReleased(button, when);
        }
    }

    public void onControllerAxisChanged(ControllerAxis axis, int axisDelta, long when) {
        if (this.areKeyEventsDispatched() && this.currentFocussedWidget != null) {
            this.currentFocussedWidget.onControllerAxisChanged(axis, axisDelta, when);
        }
    }

    public void onInputStateChanged(DeviceComponent comp, int delta, int state, long when, boolean isTopMost, boolean hasFocus) {
        if (this.areKeyEventsDispatched() && this.currentFocussedWidget != null) {
            this.currentFocussedWidget.onInputStateChanged(comp, delta, state, when, isTopMost, hasFocus);
        }
    }

    public void setPickDispatched(boolean b) {
        this.pickDispatched = b;
    }

    public final boolean isPickingDispatched() {
        return this.pickDispatched;
    }

    public boolean pick(int canvasX, int canvasY, float widgetX, float widgetY, HUDPickResult.HUDPickReason pickReason, MouseButton button, long when, long meta, int flags) {
        int i;
        this.ensureWidgetsSortedByZIndex();
        boolean eventsSuppressed = (flags & 2) != 0;
        HUDPickResult tmpHPR = null;
        HUDPickResult topMost = null;
        if (this.pickedWidgets != null) {
            this.pickedWidgets.clear();
        } else {
            this.pickedWidgets = new ArrayList();
        }
        for (i = this.managedWidgets.size() - 1; i >= 0; --i) {
            Widget widget = this.managedWidgets.get(i);
            if (!widget.isVisible() || !widget.isPickable() || (tmpHPR = widget.pick(canvasX, canvasY, pickReason, button, when, meta, flags)) == null) continue;
            this.pickedWidgets.add(tmpHPR);
            if (topMost != null && topMost.getWidget().getZIndex() > tmpHPR.getWidget().getZIndex()) continue;
            topMost = tmpHPR;
        }
        if (this.currentHoveredWidget != null && (topMost == null || topMost.getWidget() != this.currentHoveredWidget)) {
            this.currentHoveredWidget.onMouseExited(true, false);
            this.currentHoveredWidget = null;
        }
        if (!eventsSuppressed) {
            for (i = 0; i < this.pickedWidgets.size(); ++i) {
                HUDPickResult hpr = this.pickedWidgets.get(i);
                Widget pickedWidget = hpr.getWidget();
                boolean isTopMost = pickedWidget == topMost.getWidget();
                boolean hasFocus = pickedWidget == this.currentFocussedWidget;
                float pickXHUD_ = widgetX - pickedWidget.getLeft() + this.owner.getLeft();
                float pickYHUD_ = widgetY - pickedWidget.getTop() + this.owner.getTop();
                switch (pickReason) {
                    case BUTTON_PRESSED: {
                        if (isTopMost && this.currentFocussedWidget != pickedWidget && pickedWidget.isFocussable()) {
                            if (this.currentFocussedWidget != null) {
                                this.currentFocussedWidget.onFocusLost();
                            }
                            this.currentFocussedWidget = pickedWidget;
                            this.currentFocussedWidget.onFocusGained();
                            hasFocus = true;
                        }
                        pickedWidget.onMouseButtonPressed(button, pickXHUD_, pickYHUD_, when, meta, isTopMost, hasFocus);
                        break;
                    }
                    case BUTTON_RELEASED: {
                        pickedWidget.onMouseButtonReleased(button, pickXHUD_, pickYHUD_, when, meta, isTopMost, hasFocus);
                        break;
                    }
                    case MOUSE_MOVED: {
                        pickedWidget.onMouseMoved(pickXHUD_, pickYHUD_, (int)meta, when, isTopMost, hasFocus);
                        if (this.currentHoveredWidget != null || !isTopMost) break;
                        this.currentHoveredWidget = pickedWidget;
                        this.currentHoveredWidget.onMouseEntered(isTopMost, hasFocus);
                        break;
                    }
                    case MOUSE_WHEEL_MOVED_UP: {
                        pickedWidget.onMouseWheelMoved(1, meta != 0L, pickXHUD_, pickYHUD_, when, isTopMost);
                        break;
                    }
                    case MOUSE_WHEEL_MOVED_DOWN: {
                        pickedWidget.onMouseWheelMoved(-1, meta != 0L, pickXHUD_, pickYHUD_, when, isTopMost);
                    }
                }
                HUDPickResult.toPool(hpr);
            }
        } else {
            for (i = 0; i < this.pickedWidgets.size(); ++i) {
                HUDPickResult.toPool(this.pickedWidgets.get(i));
            }
        }
        this.pickedWidgets.clear();
        return topMost != null;
    }

    public Widget pick(float relX, float relY) {
        this.ensureWidgetsSortedByZIndex();
        Widget topMost = null;
        float ownerLeft = this.owner.getLeft();
        float ownerTop = this.owner.getTop();
        for (int i = 0; i < this.managedWidgets.size(); ++i) {
            Widget widget = this.managedWidgets.get(i);
            if (!widget.isVisible() || !widget.isPickable() || !(widget.getLeft() - ownerLeft <= relX) || !(relX <= widget.getLeft() - ownerLeft + widget.getWidth()) || !(widget.getTop() - ownerTop <= relY) || !(relY <= widget.getTop() - ownerTop + widget.getHeight()) || topMost != null && topMost.getZIndex() > widget.getZIndex()) continue;
            topMost = widget;
        }
        return topMost;
    }

    public void reposition(Widget widget, float posX, float posY) {
        widget.setLocation(this.owner.getLeft() + posX, this.owner.getTop() + posY);
    }

    public void onOwnerMoved(float deltaX, float deltaY, boolean needsTextureRefresh) {
        for (int i = 0; i < this.managedWidgets.size(); ++i) {
            Widget widget = this.managedWidgets.get(i);
            widget.setLocation(widget.getLeft() + deltaX, widget.getTop() + deltaY, false, needsTextureRefresh);
        }
    }

    public final float getPositionX(Widget widget) {
        return widget.getLeft() - this.owner.getLeft();
    }

    public final float getPositionY(Widget widget) {
        return widget.getTop() - this.owner.getTop();
    }

    public boolean contains(Widget widget) {
        return this.widgets.contains(widget);
    }

    private void ensureWidgetsSortedByZIndex() {
        if (this.widgetsSorted) {
            return;
        }
        Collections.sort(this.widgets, Z_INDEX_COMPARATOR);
        this.widgetsSorted = true;
    }

    public void addWidget(Widget widget, float locX, float locY) {
        if (widget.isHeavyWeight()) {
            throw new IllegalArgumentException("You cannot add a heavyweight Widget to the WidgetAssembler.");
        }
        this.widgets.add(widget);
        this.managedWidgets.add(widget);
        this.reposition(widget, locX, locY);
        widget.setContainer(this.owner.getContainer(), this.owner);
        widget.setHUD(this.owner.getHUD());
        widget.setHostWidget(this.owner);
        this.widgetsSorted = false;
    }

    public final void addWidget(Widget widget) {
        this.addWidget(widget, widget.getLeft(), widget.getTop());
    }

    public void addUnmanagedWidget(Widget widget) {
        if (widget.isHeavyWeight()) {
            throw new IllegalArgumentException("You cannot add a heavyweight Widget to the WidgetAssembler.");
        }
        this.widgets.add(widget);
        widget.setPassive(true);
        widget.setContainer(this.owner.getContainer(), this.owner);
        widget.setHUD(this.owner.getHUD());
    }

    public void removeWidget(Widget widget) {
        if (widget.getAssembly() != this.owner) {
            throw new Error("The given Widget doesn't belong to this owner Widget.");
        }
        this.managedWidgets.remove(widget);
        this.widgets.remove(widget);
        widget.setPassive(false);
        widget.setHostWidget(null);
        widget.setHUD(null);
        widget.setContainer(null, null);
    }

    public void update() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            this.widgets.get(i).update();
        }
    }

    final void setWidgetsPassive(boolean passive) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            this.widgets.get(i).setPassive(passive);
        }
    }

    protected void setWidgetsDirty() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            this.widgets.get(i).setWidgetDirty();
        }
    }

    protected void draw(Texture2DCanvas texCanvas, int offsetX, int offsetY) {
        this.ensureWidgetsSortedByZIndex();
        Tuple2i tmpLoc = Tuple2i.fromPool();
        Dim2i tmpSize = Dim2i.fromPool();
        float ownerLeft = this.owner.getLeft();
        float ownerTop = this.owner.getTop();
        for (int i = 0; i < this.managedWidgets.size(); ++i) {
            Widget widget = this.managedWidgets.get(i);
            if (!widget.isVisible()) continue;
            widget.getRelLocationHUD2Pixels_(widget.getLeft() - ownerLeft, widget.getTop() - ownerTop, tmpLoc);
            widget.getSizeHUD2Pixels_(widget.getWidth(), widget.getHeight(), tmpSize);
            widget.drawAndUpdateWidget(texCanvas, offsetX + tmpLoc.getX(), offsetY + tmpLoc.getY(), tmpSize.getWidth(), tmpSize.getHeight(), false);
        }
        Dim2i.toPool(tmpSize);
        Tuple2i.toPool(tmpLoc);
    }

    public WidgetAssembler(Widget owner) {
        this.owner = owner;
    }
}

