/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.borders;

import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.ui.hud.base.Border;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.utils.HUDTextureUtils;

public class TexturedBorder
extends Border {
    private Texture2D texture;
    private Border.Description desc;

    public void setTexture(Texture2D texture) {
        if (texture == null) {
            throw new NullPointerException("texture parameter MUST NOT be null.");
        }
        this.texture = texture;
    }

    public final Texture2D getTexture() {
        return this.texture;
    }

    public void drawBorder(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, Widget hostWidget) {
        Texture2D texture = this.getTexture();
        TextureImage2D image = texture.getImage0();
        int srcW = HUDTextureUtils.getTextureWidth(texture);
        int srcH = HUDTextureUtils.getTextureHeight(texture);
        int srcBottomH = this.getBottomHeight();
        int srcRightW = this.getRightWidth();
        int srcTopH = this.getTopHeight();
        int srcLeftW = this.getLeftWidth();
        int ll_upper = this.desc.getLLupperHeight();
        int ll_right = this.desc.getLLrightWidth();
        int lr_left = this.desc.getLRleftWidth();
        int lr_upper = this.desc.getLRupperHeight();
        int ur_lower = this.desc.getURlowerHeight();
        int ur_left = this.desc.getURleftWidth();
        int ul_right = this.desc.getULrightWidth();
        int ul_lower = this.desc.getULlowerHeight();
        int srcRightLeft = srcW - srcRightW;
        int srcBottomTop = srcH - srcBottomH;
        int trgRightLeft = width - srcRightW;
        int trgBottomTop = height - srcBottomH;
        TextureImage2D ti = texCanvas.getImage();
        if (srcLeftW > 0 && srcBottomH > 0) {
            ti.drawImage(image, 0, srcBottomTop, srcLeftW, srcBottomH, offsetX + 0, offsetY + trgBottomTop, true, null);
        }
        if (srcRightW > 0 && srcBottomH > 0) {
            ti.drawImage(image, srcRightLeft, srcBottomTop, srcRightW, srcBottomH, offsetX + trgRightLeft, offsetY + trgBottomTop, true, null);
        }
        if (srcRightW > 0 && srcTopH > 0) {
            ti.drawImage(image, srcRightLeft, 0, srcRightW, srcTopH, offsetX + trgRightLeft, offsetY, true, null);
        }
        if (srcLeftW > 0 && srcTopH > 0) {
            ti.drawImage(image, 0, 0, srcLeftW, srcTopH, offsetX, offsetY, true, null);
        }
        if (ll_right > 0) {
            ti.drawImage(image, srcLeftW, srcBottomTop, ll_right, srcBottomH, offsetX + srcLeftW, offsetY + trgBottomTop, ll_right, srcBottomH, true, null);
        }
        if (lr_left > 0) {
            ti.drawImage(image, srcRightLeft - lr_left, srcBottomTop, lr_left, srcBottomH, offsetX + trgRightLeft - lr_left, offsetY + trgBottomTop, lr_left, srcBottomH, true, null);
        }
        if (lr_upper > 0) {
            ti.drawImage(image, srcRightLeft, srcBottomTop - lr_upper, srcRightW, lr_upper, offsetX + trgRightLeft, offsetY + trgBottomTop - lr_upper, srcRightW, lr_upper, true, null);
        }
        if (ur_lower > 0) {
            ti.drawImage(image, srcRightLeft, srcTopH, srcRightW, ul_lower, offsetX + trgRightLeft, offsetY + srcTopH, srcRightW, ul_lower, true, null);
        }
        if (ur_left > 0) {
            ti.drawImage(image, srcRightLeft - ur_left, 0, ur_left, srcTopH, offsetX + trgRightLeft - ur_left, offsetY, ur_left, srcTopH, true, null);
        }
        if (ul_right > 0) {
            ti.drawImage(image, srcLeftW, 0, ul_right, srcTopH, offsetX + srcLeftW, offsetY, ul_right, srcTopH, true, null);
        }
        if (ul_lower > 0) {
            ti.drawImage(image, 0, srcTopH, srcLeftW, ul_lower, offsetX, offsetY + srcTopH, srcLeftW, ul_lower, true, null);
        }
        if (ll_upper > 0) {
            ti.drawImage(image, 0, srcBottomTop - ll_upper, srcLeftW, ll_upper, offsetX, offsetY + trgBottomTop - ll_upper, srcLeftW, ll_upper, true, null);
        }
        if (srcBottomH > 0) {
            ti.drawImage(image, srcLeftW + ll_right, srcBottomTop, srcW - srcLeftW - ll_right - lr_left - srcRightW, srcBottomH, offsetX + srcLeftW + ll_right, offsetY + trgBottomTop, width - srcLeftW - ll_right - lr_left - srcRightW, srcBottomH, true, null);
        }
        if (srcRightW > 0) {
            ti.drawImage(image, srcRightLeft, srcTopH + ur_lower, srcRightW, srcH - srcTopH - ur_lower - lr_upper - srcBottomH, offsetX + trgRightLeft, offsetY + srcTopH + ur_lower, srcRightW, height - srcTopH - ur_lower - lr_upper - srcBottomH, true, null);
        }
        if (srcTopH > 0) {
            ti.drawImage(image, srcLeftW + ul_right, 0, srcW - ul_right - ur_left - srcLeftW - srcRightW, srcTopH, offsetX + srcLeftW + ul_right, offsetY, width - srcLeftW - ul_right - ur_left - srcRightW, srcTopH, true, null);
        }
        if (srcLeftW > 0) {
            ti.drawImage(image, 0, srcTopH + ul_lower, srcLeftW, srcH - srcTopH - ul_lower - ll_upper - srcBottomH, offsetX, offsetY + srcTopH + ul_lower, srcLeftW, height - srcTopH - ul_lower - ll_upper - srcBottomH, true, null);
        }
    }

    private TexturedBorder(Border.Description description, int bottomHeight, int rightWidth, int topHeight, int leftWidth, Texture2D texture) {
        super(bottomHeight, rightWidth, topHeight, leftWidth);
        this.setTexture(texture);
        this.desc = description == null ? new Border.Description(bottomHeight, rightWidth, topHeight, leftWidth, texture) : description.clone();
        this.desc.setTexture(texture);
    }

    public TexturedBorder(int bottomHeight, int rightWidth, int topHeight, int leftWidth, Texture2D texture) {
        this(null, bottomHeight, rightWidth, topHeight, leftWidth, texture);
    }

    public TexturedBorder(int width, Texture2D texture) {
        this(width, width, width, width, texture);
    }

    public TexturedBorder(Border.Description description) {
        this(description, description.getBottomHeight(), description.getRightWidth(), description.getTopHeight(), description.getLeftWidth(), description.getTexture());
    }

    private TexturedBorder(Border.Description description, int bottomHeight, int rightWidth, int topHeight, int leftWidth, String texture) {
        this(description, bottomHeight, rightWidth, topHeight, leftWidth, HUDTextureUtils.getTexture(texture));
    }

    public TexturedBorder(int bottomHeight, int rightWidth, int topHeight, int leftWidth, String texture) {
        this(null, bottomHeight, rightWidth, topHeight, leftWidth, texture);
    }

    public TexturedBorder(int width, String texture) {
        this(width, width, width, width, texture);
    }
}

