/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.contextmenu;

import java.util.ArrayList;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.Mouse;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.__HUD_PrivilegedAccess;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.contextmenu.ContextMenuItem;
import org.xith3d.ui.hud.contextmenu.ContextMenuListener;
import org.xith3d.ui.hud.utils.PopUpable;

public class ContextMenu
implements PopUpable {
    private HUD hud;
    private final WidgetContainer menuItemsContainer;
    private final ArrayList<ContextMenuItem> items = new ArrayList();
    private final ArrayList<ContextMenuListener> listeners = new ArrayList();
    private boolean poppedUp = false;
    private long nextAllowedPopUpTime = -1L;

    public void setHUD(HUD hud) {
        this.hud = hud;
    }

    public final HUD getHUD() {
        return this.hud;
    }

    public final WidgetContainer getMenuItemsContainer() {
        return this.menuItemsContainer;
    }

    public void addContextMenuListener(ContextMenuListener l) {
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void removeContextMenuListener(ContextMenuListener l) {
        this.listeners.remove(l);
    }

    protected void onItemAdded(ContextMenuItem item, WidgetContainer menuItemsContainer) {
    }

    public void addItem(ContextMenuItem item) {
        if (this.isPoppedUp()) {
            throw new Error("The ContextMenu must be invisible to be manipulated!");
        }
        if (item.getContextMenu() != null) {
            throw new Error("This item is already attached to a ContextMenu.");
        }
        this.items.add(item);
        item.setContextMenu(this);
        this.onItemAdded(item, this.menuItemsContainer);
    }

    protected void onItemRemoved(ContextMenuItem item, WidgetContainer menuItemsContainer) {
    }

    public void removeItem(ContextMenuItem item) {
        if (this.isPoppedUp()) {
            throw new Error("The ContextMenu must be invisible to be manipulated!");
        }
        if (item.getContextMenu() != this) {
            throw new Error("This item is not attached to this ContextMenu.");
        }
        this.items.remove(item);
        item.setContextMenu(null);
        this.onItemRemoved(item, this.menuItemsContainer);
    }

    public final void removeAllItems() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            this.removeItem(this.items.get(i));
        }
    }

    public void popUp(float posX, float posY) {
        if (!this.poppedUp && System.currentTimeMillis() < this.nextAllowedPopUpTime) {
            return;
        }
        if (this.menuItemsContainer.getHUD() == null) {
            __HUD_PrivilegedAccess.addVolatilePopup(this.hud, this.menuItemsContainer, null, posX, posY);
        } else {
            this.menuItemsContainer.setLocation(posX, posY);
        }
        this.poppedUp = true;
    }

    public void popUp(int canvasX, int canvasY) {
        Tuple2f buffer = Tuple2f.fromPool();
        this.hud.getCoordinatesConverter().getLocationPixels2HUD(canvasX, canvasY, buffer);
        float posX = buffer.getX();
        float posY = buffer.getY();
        Tuple2f.toPool(buffer);
        this.popUp(posX, posY);
    }

    public void popUp(boolean p) {
        if (p == this.poppedUp) {
            return;
        }
        if (!p) {
            this.poppedUp = false;
            this.nextAllowedPopUpTime = System.currentTimeMillis() + 20L;
            __HUD_PrivilegedAccess.removeVolatilePopup(this.hud);
        }
        if (!InputSystem.hasInstance()) {
            this.popUp(0.0f, 0.0f);
            return;
        }
        Mouse mouse = InputSystem.getInstance().getMouse();
        if (mouse == null) {
            this.popUp(0.0f, 0.0f);
            return;
        }
        Tuple2f buffer = Tuple2f.fromPool();
        this.hud.getCoordinatesConverter().getLocationPixels2HUD(mouse.getCurrentX(), mouse.getCurrentY(), buffer);
        float posX = buffer.getX();
        float posY = buffer.getY();
        Tuple2f.toPool(buffer);
        this.popUp(posX, posY);
    }

    public boolean isPoppedUp() {
        return this.poppedUp;
    }

    public void onItemClicked(ContextMenuItem item) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onContextMenuItemClicked(item);
        }
        if (item.clickCausesMenuHide()) {
            this.popUp(false);
        }
    }

    protected WidgetContainer createMenuItemsContainer() {
        throw new Error("You must implement createMenuItemsContainer, if a null value is passed to the Constructor!");
    }

    public ContextMenu(HUD hud, WidgetContainer menuItemsContainer) {
        this.hud = hud;
        this.menuItemsContainer = menuItemsContainer == null ? this.createMenuItemsContainer() : menuItemsContainer;
        this.menuItemsContainer.setName("Context Menu");
    }
}

