/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.layout;

import java.util.ArrayList;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.layout.BorderSettableLayoutManagerBase;

public class GridLayout
extends BorderSettableLayoutManagerBase {
    private int rows;
    private int cols;
    private float hgap;
    private float vgap;
    private float[] colWeights = null;
    private float[] rowWeights = null;
    private float[] recColWeights = null;
    private float[] recRowWeights = null;

    public void setRows(int rows) {
        this.rows = rows;
    }

    public final int getRows() {
        return this.rows;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public final int getCols() {
        return this.cols;
    }

    public void setHGap(float hgap) {
        this.hgap = hgap;
    }

    public final float getHGap() {
        return this.hgap;
    }

    public void setVGap(float vgap) {
        this.vgap = vgap;
    }

    public final float getVGap() {
        return this.vgap;
    }

    public void setColWeights(float ... weights) {
        this.colWeights = weights;
        if (this.colWeights != null) {
            int i;
            if (this.recColWeights == null || this.recColWeights.length != this.colWeights.length) {
                this.recColWeights = new float[this.colWeights.length];
            }
            float sum = 0.0f;
            for (i = 0; i < this.colWeights.length; ++i) {
                sum += this.colWeights[i];
            }
            for (i = 0; i < this.colWeights.length; ++i) {
                this.recColWeights[i] = this.colWeights[i] / sum;
            }
        }
    }

    public final float[] getColWeights() {
        return this.colWeights;
    }

    public void setRowWeights(float ... weights) {
        this.rowWeights = weights;
        if (this.rowWeights != null) {
            int i;
            if (this.recRowWeights == null || this.recRowWeights.length != this.rowWeights.length) {
                this.recRowWeights = new float[this.rowWeights.length];
            }
            float sum = 0.0f;
            for (i = 0; i < this.rowWeights.length; ++i) {
                sum += this.rowWeights[i];
            }
            for (i = 0; i < this.rowWeights.length; ++i) {
                this.recRowWeights[i] = this.rowWeights[i] / sum;
            }
        }
    }

    public final float[] getRowWeights() {
        return this.rowWeights;
    }

    protected void doLayout(float left0, float top0, float containerResX, float containerResY) {
        block14: {
            ArrayList<Widget> widgets;
            block15: {
                block13: {
                    widgets = this.getWidgets();
                    if (this.rows <= 0 || this.cols <= 0) break block13;
                    float totalWidth = containerResX - (float)(this.getCols() - 1) * this.getHGap();
                    float totalHeight = containerResY - (float)(this.getRows() - 1) * this.getVGap();
                    float width = 0.0f;
                    float height = 0.0f;
                    if (this.getColWeights() == null) {
                        width = totalWidth / (float)this.getCols();
                    }
                    if (this.getRowWeights() == null) {
                        height = totalHeight / (float)this.getRows();
                    }
                    float left = left0;
                    float top = top0;
                    int row = 0;
                    int col = 0;
                    for (int i = 0; i < widgets.size(); ++i) {
                        Widget widget = widgets.get(i);
                        if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                        if (this.getColWeights() != null) {
                            width = totalWidth * this.recColWeights[col];
                        }
                        if (this.getRowWeights() != null) {
                            height = totalHeight * this.recRowWeights[row];
                        }
                        widget.setSize(width, height);
                        widget.setLocation(left, top);
                        left += width + this.getHGap();
                        if (++col < this.getCols()) continue;
                        col = 0;
                        ++row;
                        left = left0;
                        top += height + this.getVGap();
                    }
                    break block14;
                }
                if (this.rows != 0 || this.cols <= 0) break block15;
                float totalWidth = containerResX - (float)(this.getCols() - 1) * this.getHGap();
                float width = 0.0f;
                float height = 0.0f;
                if (this.getColWeights() == null) {
                    width = totalWidth / (float)this.getCols();
                }
                float left = left0;
                float top = top0;
                int row = 0;
                int col = 0;
                for (int i = 0; i < widgets.size(); ++i) {
                    Widget widget = widgets.get(i);
                    if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                    if (this.getColWeights() != null) {
                        width = totalWidth * this.recColWeights[col];
                    }
                    if (widget.getHeight() > height) {
                        height = widget.getHeight();
                    }
                    widget.setSize(width, widget.getHeight());
                    widget.setLocation(left, top);
                    left += width + this.getHGap();
                    if (++col < this.getCols()) continue;
                    col = 0;
                    ++row;
                    left = left0;
                    top += height + this.getVGap();
                    height = 0.0f;
                }
                break block14;
            }
            if (this.rows <= 0 || this.cols != 0) break block14;
            float totalHeight = containerResY - (float)(this.getRows() - 1) * this.getVGap();
            float width = 0.0f;
            float height = 0.0f;
            if (this.getRowWeights() == null) {
                height = totalHeight / (float)this.getRows();
            }
            float left = left0;
            float top = top0;
            int row = 0;
            int col = 0;
            for (int i = 0; i < widgets.size(); ++i) {
                Widget widget = widgets.get(i);
                if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                if (widget.getWidth() > width) {
                    width = widget.getWidth();
                }
                if (this.getRowWeights() != null) {
                    height = totalHeight * this.recRowWeights[row];
                }
                widget.setSize(widget.getWidth(), height);
                widget.setLocation(left, top);
                top += height + this.getVGap();
                if (++row < this.getRows()) continue;
                row = 0;
                ++col;
                top = top0;
                left += width + this.getHGap();
                width = 0.0f;
            }
        }
    }

    public GridLayout(int rows, int cols, float hgap, float vgap, float borderBottom, float borderRight, float borderTop, float borderLeft) {
        super(borderBottom, borderRight, borderTop, borderLeft);
        if (rows < 0 || cols < 0) {
            throw new IllegalArgumentException("rows and cols must be >= 0");
        }
        if (rows == 0 && cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot be 0 at the same time");
        }
        if (hgap < 0.0f || vgap < 0.0f) {
            throw new IllegalArgumentException("hgap and vgap must be >= 0");
        }
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public GridLayout(int rows, int cols, float hgap, float vgap) {
        this(rows, cols, hgap, vgap, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public GridLayout(int rows, int cols, float borderBottom, float borderRight, float borderTop, float borderLeft) {
        this(rows, cols, 0.0f, 0.0f, borderBottom, borderRight, borderTop, borderLeft);
    }

    public GridLayout(int rows, int cols) {
        this(rows, cols, 0.0f, 0.0f);
    }
}

