/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.layout;

import java.util.ArrayList;
import org.xith3d.ui.hud.base.AutoSizable;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.layout.BorderSettableLayoutManagerBase;

public class ListLayout
extends BorderSettableLayoutManagerBase {
    private Orientation orientation;
    private Alignment alignment = Alignment.CENTER_TOP;
    private boolean otherSpanCalculated = true;
    private float gap;

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        this.orientation = orientation;
    }

    public final Orientation getOrientation() {
        return this.orientation;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public final Alignment getAlignment() {
        return this.alignment;
    }

    public void setOtherSpanCalculated(boolean b) {
        this.otherSpanCalculated = b;
    }

    public final boolean isOtherSpanCalculated() {
        return this.otherSpanCalculated;
    }

    public void setGap(float gap) {
        this.gap = gap;
    }

    public final float getGap() {
        return this.gap;
    }

    protected void doLayout(float left0, float top0, float containerResX, float containerResY) {
        block31: {
            ArrayList<Widget> widgets;
            block30: {
                widgets = this.getWidgets();
                if (this.orientation != Orientation.HORIZONTAL) break block30;
                float left = left0;
                if (this.getAlignment() != null && (this.getAlignment().isHCenter() || this.getAlignment().isRight())) {
                    float totalWidth = 0.0f;
                    for (int i = 0; i < widgets.size(); ++i) {
                        Widget widget = widgets.get(i);
                        if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                        if (i > 0) {
                            totalWidth += this.getGap();
                        }
                        if (widget instanceof AutoSizable) {
                            ((AutoSizable)((Object)widget)).setMinimalSize();
                        }
                        totalWidth += widget.getWidth();
                    }
                    if (this.getAlignment().isHCenter()) {
                        left += containerResX / 2.0f - totalWidth / 2.0f;
                    } else if (this.getAlignment().isRight()) {
                        left += containerResX - totalWidth;
                    }
                }
                for (int i = 0; i < widgets.size(); ++i) {
                    Widget widget = widgets.get(i);
                    if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                    float height = this.isOtherSpanCalculated() ? containerResY : widget.getHeight();
                    widget.setSize(widget.getWidth(), height);
                    if (this.getAlignment() == null) {
                        widget.setLocation(left, widget.getTop());
                    } else {
                        switch (this.getAlignment()) {
                            case LEFT_TOP: 
                            case CENTER_TOP: 
                            case RIGHT_TOP: {
                                widget.setLocation(left, top0);
                                break;
                            }
                            case LEFT_CENTER: 
                            case CENTER_CENTER: 
                            case RIGHT_CENTER: {
                                widget.setLocation(left, top0 + containerResY / 2.0f - height / 2.0f);
                                break;
                            }
                            case LEFT_BOTTOM: 
                            case CENTER_BOTTOM: 
                            case RIGHT_BOTTOM: {
                                widget.setLocation(left, top0 + containerResY - height);
                            }
                        }
                    }
                    left += widget.getWidth() + this.getGap();
                }
                break block31;
            }
            if (this.orientation != Orientation.VERTICAL) break block31;
            float top = top0;
            if (this.getAlignment() != null && (this.getAlignment().isVCenter() || this.getAlignment().isBottom())) {
                float totaHeight = 0.0f;
                for (int i = 0; i < widgets.size(); ++i) {
                    Widget widget = widgets.get(i);
                    if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                    if (i > 0) {
                        totaHeight += this.getGap();
                    }
                    if (widget instanceof AutoSizable) {
                        ((AutoSizable)((Object)widget)).setMinimalSize();
                    }
                    totaHeight += widget.getHeight();
                }
                if (this.getAlignment().isVCenter()) {
                    top += containerResY / 2.0f - totaHeight / 2.0f;
                } else if (this.getAlignment().isBottom()) {
                    top += containerResY - totaHeight;
                }
            }
            for (int i = 0; i < widgets.size(); ++i) {
                Widget widget = widgets.get(i);
                if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                float width = this.isOtherSpanCalculated() ? containerResX : widget.getWidth();
                widget.setSize(width, widget.getHeight());
                if (this.getAlignment() == null) {
                    widget.setLocation(widget.getLeft(), top);
                } else {
                    switch (this.getAlignment()) {
                        case LEFT_TOP: 
                        case LEFT_CENTER: 
                        case LEFT_BOTTOM: {
                            widget.setLocation(left0, top);
                            break;
                        }
                        case CENTER_TOP: 
                        case CENTER_CENTER: 
                        case CENTER_BOTTOM: {
                            widget.setLocation(left0 + containerResX / 2.0f - width / 2.0f, top);
                            break;
                        }
                        case RIGHT_TOP: 
                        case RIGHT_CENTER: 
                        case RIGHT_BOTTOM: {
                            widget.setLocation(left0 + containerResX - width, top);
                        }
                    }
                }
                top += widget.getHeight() + this.getGap();
            }
        }
    }

    public ListLayout(Orientation orientation, float gap, float borderBottom, float borderRight, float borderTop, float borderLeft) {
        super(borderBottom, borderRight, borderTop, borderLeft);
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("gap must be >= 0");
        }
        this.orientation = orientation;
        this.alignment = orientation == Orientation.HORIZONTAL ? Alignment.LEFT_CENTER : Alignment.CENTER_TOP;
        this.gap = gap;
    }

    public ListLayout(Orientation orientation, float gap) {
        this(orientation, gap, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public ListLayout(Orientation orientation, float borderBottom, float borderRight, float borderTop, float borderLeft) {
        this(orientation, 0.0f, borderBottom, borderRight, borderTop, borderLeft);
    }

    public ListLayout(Orientation orientation) {
        this(orientation, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT_TOP,
        LEFT_CENTER,
        LEFT_BOTTOM,
        CENTER_TOP,
        CENTER_CENTER,
        CENTER_BOTTOM,
        RIGHT_TOP,
        RIGHT_CENTER,
        RIGHT_BOTTOM;


        public final boolean isLeft() {
            return this == LEFT_TOP || this == LEFT_CENTER || this == LEFT_BOTTOM;
        }

        public final boolean isHCenter() {
            return this == CENTER_TOP || this == CENTER_CENTER || this == CENTER_BOTTOM;
        }

        public final boolean isRight() {
            return this == RIGHT_TOP || this == RIGHT_CENTER || this == RIGHT_BOTTOM;
        }

        public final boolean isTop() {
            return this == LEFT_TOP || this == CENTER_TOP || this == RIGHT_TOP;
        }

        public final boolean isVCenter() {
            return this == LEFT_CENTER || this == CENTER_CENTER || this == RIGHT_CENTER;
        }

        public final boolean isBottom() {
            return this == LEFT_BOTTOM || this == CENTER_BOTTOM || this == RIGHT_BOTTOM;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

