/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.menusystem.menus.settings;

import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.ui.hud.base.StateButton;
import org.xith3d.ui.hud.layout.ListLayout;
import org.xith3d.ui.hud.listeners.SliderListener;
import org.xith3d.ui.hud.listeners.WidgetStateListener;
import org.xith3d.ui.hud.menusystem.menus.MenuBase;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Checkbox;
import org.xith3d.ui.hud.widgets.EmptyWidget;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Slider;
import org.xith3d.ui.text2d.TextAlignment;

public class FPIHMainSettingsMenu
extends MenuBase {
    public static final String NAME = FPIHMainSettingsMenu.class.getSimpleName();
    private final Label mouseXSpeedCaption;
    private final Label mouseYSpeedCaption;
    private final Slider xSlider;
    private final Slider ySlider;
    private final Checkbox yFlipper;
    private final InputReceiver inputReceiver = new InputReceiver();

    public void setMaxMouseXSpeed(float speed) {
        this.inputReceiver.ignore = true;
        this.xSlider.setMaxValue((int)(speed * 10.0f));
        this.inputReceiver.ignore = false;
    }

    public float getMaxMouseXSpeed() {
        return (float)this.xSlider.getMaxValue() / 10.0f;
    }

    public void setMinMouseXSpeed(float speed) {
        if (speed <= 0.0f) {
            throw new IllegalArgumentException("You cannot set the min speed <= 0");
        }
        this.inputReceiver.ignore = true;
        this.xSlider.setMinValue((int)(speed * 10.0f));
        this.inputReceiver.ignore = false;
    }

    public float getMinMouseXSpeed() {
        return (float)this.xSlider.getMinValue() / 10.0f;
    }

    public void setMouseXSpeed(float speed) {
        this.inputReceiver.ignore = true;
        this.xSlider.setValue((int)(speed * 10.0f));
        this.inputReceiver.ignore = false;
    }

    public float getMouseXSpeed() {
        return (float)this.xSlider.getValue() / 10.0f;
    }

    public void setMaxMouseYSpeed(float speed) {
        this.inputReceiver.ignore = true;
        this.ySlider.setMaxValue((int)(speed * 10.0f));
        this.inputReceiver.ignore = false;
    }

    public float getMaxMouseYSpeed() {
        return (float)this.ySlider.getMaxValue() / 10.0f;
    }

    public void setMinMouseYSpeed(float speed) {
        if (speed <= 0.0f) {
            throw new IllegalArgumentException("You cannot set the min speed <= 0");
        }
        this.inputReceiver.ignore = true;
        this.ySlider.setMinValue((int)(speed * 10.0f));
        this.inputReceiver.ignore = false;
    }

    public float getMinMouseYSpeed() {
        return (float)this.ySlider.getMinValue() / 10.0f;
    }

    public void setMouseYSpeed(float speed) {
        this.inputReceiver.ignore = true;
        this.ySlider.setValue((int)(speed * 10.0f));
        this.inputReceiver.ignore = false;
    }

    public float getMouseYSpeed() {
        return (float)this.ySlider.getValue() / 10.0f;
    }

    public void setMouseYAxisInverted(boolean inverted) {
        this.inputReceiver.ignore = true;
        this.yFlipper.setState(inverted);
        this.inputReceiver.ignore = false;
    }

    public boolean isMouseYAxisInverted() {
        return this.yFlipper.getState();
    }

    public void applyConfig(FirstPersonInputHandler fpih) {
        this.setMouseXSpeed(fpih.getMouseXSpeed());
        this.setMouseYSpeed(Math.abs(fpih.getMouseYSpeed()));
        this.setMouseYAxisInverted(fpih.getMouseYSpeed() < 0.0f);
    }

    public void extractConfig(FirstPersonInputHandler fpih) {
        fpih.setMouseXSpeed(this.getMouseXSpeed());
        if (this.isMouseYAxisInverted()) {
            fpih.setMouseYSpeed(-this.getMouseYSpeed());
        } else {
            fpih.setMouseYSpeed(this.getMouseYSpeed());
        }
    }

    protected void initWidgets() {
        this.addWidget(this.mouseXSpeedCaption);
        this.addWidget(this.xSlider);
        this.addWidget(new EmptyWidget(0.0f, 10.0f));
        this.addWidget(this.mouseYSpeedCaption);
        this.addWidget(this.ySlider);
        this.addWidget(new EmptyWidget(0.0f, 10.0f));
        this.yFlipper.setSize(0.0f, this.mouseXSpeedCaption.getHeight());
        this.addWidget(this.yFlipper);
    }

    public FPIHMainSettingsMenu(float width, float height) {
        super(width, height, NAME, new String[]{"save"});
        ListLayout layout = new ListLayout(ListLayout.Orientation.VERTICAL, 2.0f, 10.0f, 10.0f, 10.0f, 10.0f);
        layout.setAlignment(ListLayout.Alignment.CENTER_TOP);
        layout.setOtherSpanCalculated(true);
        this.setLayout(layout);
        HUDFont font = HUDFont.getFont("Verdana", HUDFont.PLAIN, 12);
        this.mouseXSpeedCaption = new Label(0.0f, 0.0f, "Mouse-X-Speed", font, TextAlignment.BOTTOM_LEFT);
        this.xSlider = new Slider(0.0f);
        this.xSlider.setUserObject("mouse_x_speed");
        this.xSlider.setMinAndMax(0, 50);
        this.mouseYSpeedCaption = new Label(0.0f, 0.0f, "Mouse-Y-Speed", font, TextAlignment.BOTTOM_LEFT);
        this.ySlider = new Slider(0.0f);
        this.ySlider.setUserObject("mouse_y_speed");
        this.ySlider.setMinAndMax(0, 50);
        this.yFlipper = new Checkbox(0.0f, this.mouseXSpeedCaption.getHeight(), "Y-axis inverted", font, null);
        this.yFlipper.setUserObject("mouse_y_flipped");
        this.setMouseXSpeed(1.0f);
        this.setMouseYSpeed(Math.abs(1.0f));
        this.setMouseYAxisInverted(false);
        this.xSlider.addSliderListener(this.inputReceiver);
        this.ySlider.addSliderListener(this.inputReceiver);
        this.yFlipper.addStateListener(this.inputReceiver);
    }

    public FPIHMainSettingsMenu(float width) {
        this(width, 0.0f);
        this.setMinimalHeight();
    }

    private class InputReceiver
    implements SliderListener,
    WidgetStateListener {
        public boolean ignore = false;

        private InputReceiver() {
        }

        public void onSliderValueChanged(Slider slider, int newValue) {
            if (FPIHMainSettingsMenu.this.getMenuGroup() != null && !this.ignore) {
                FPIHMainSettingsMenu.this.getMenuGroup().fireOnSettingChanged(FPIHMainSettingsMenu.this, "fpih_main_setting", (String)slider.getUserObject() + "=" + (float)newValue / 10.0f);
            }
        }

        public void onButtonStateChanged(StateButton stateButton, boolean state, Object userObject) {
            if (FPIHMainSettingsMenu.this.getMenuGroup() != null && !this.ignore) {
                FPIHMainSettingsMenu.this.getMenuGroup().fireOnSettingChanged(FPIHMainSettingsMenu.this, "fpih_main_setting", (String)userObject + "=" + state);
            }
        }
    }
}

