/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.theming;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jagatoo.datatypes.NamedObject;
import org.openmali.vecmath2.Colorf;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loaders.texture.TextureStreamLocatorZip;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.ui.hud.base.Border;
import org.xith3d.ui.hud.base.LabeledStateButton;
import org.xith3d.ui.hud.base.WindowHeaderWidget;
import org.xith3d.ui.hud.theming.ThemeProperties;
import org.xith3d.ui.hud.utils.Cursor;
import org.xith3d.ui.hud.utils.CursorSet;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.ComboBox;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.List;
import org.xith3d.ui.hud.widgets.ProgressBar;
import org.xith3d.ui.hud.widgets.Scrollbar;
import org.xith3d.ui.hud.widgets.Slider;
import org.xith3d.ui.hud.widgets.TextField;
import org.xith3d.ui.text2d.TextAlignment;

public class WidgetTheme
implements NamedObject {
    protected ThemeProperties themeProps;
    private Label.Description labelDesc = null;
    private TextField.Description textFieldDesc = null;
    private Button.Description buttonDesc = null;
    private Border.Description roundedCornersBorderDesc = null;
    private Border.Description loweredBevelBorderDesc = null;
    private Border.Description raisedBevelBorderDesc = null;
    private Scrollbar.Description scrollbarDescHoriz = null;
    private Scrollbar.Description scrollbarDescVert = null;
    private Slider.Description sliderDesc = null;
    private LabeledStateButton.Description radioButtonDesc = null;
    private LabeledStateButton.Description checkboxDesc = null;
    private WindowHeaderWidget.Description windowHeaderDesc = null;
    private Border.Description windowBorderDesc = null;
    private List.Description listDesc = null;
    private ComboBox.Description comboDesc = null;
    private ProgressBar.Description progressbarDesc = null;
    private Texture2D frame_contentpane_background_texture = null;
    private CursorSet cursorSet = null;

    public String getName() {
        return this.themeProps.name;
    }

    public void setFont(HUDFont font, boolean disabled) {
        if (disabled) {
            this.themeProps.font_disabled = font;
        } else {
            this.themeProps.font = font;
        }
    }

    public HUDFont getFont(boolean disabled) {
        if (disabled) {
            return this.themeProps.font_disabled;
        }
        return this.themeProps.font;
    }

    public void setFontColor(Colorf color, boolean disabled) {
        if (disabled) {
            this.themeProps.font_disabled_color = color;
        } else {
            this.themeProps.font_color = color;
        }
    }

    public Colorf getFontColor(boolean disabled) {
        if (disabled) {
            return this.themeProps.font_disabled_color;
        }
        return this.themeProps.font_color;
    }

    public void setLabelDescription(Label.Description desc) {
        this.labelDesc = desc;
    }

    private final Label.Description initLabelDescription() {
        if (this.labelDesc == null) {
            Label.Description labelDesc;
            this.labelDesc = labelDesc = new Label.Description(null, (Texture2D)null, this.themeProps.label_font, this.themeProps.label_font_disabled, this.themeProps.label_font_color, this.themeProps.label_font_disabled_color, TextAlignment.TOP_LEFT);
        }
        return this.labelDesc;
    }

    public Label.Description getLabelDescription() {
        return this.initLabelDescription().clone();
    }

    public void getLabelDescription(Label.Description desc) {
        desc.set(this.initLabelDescription());
    }

    public Texture2D getTextCaretTexture(String suffix) {
        return HUDTextureUtils.getTexture(this.getName() + "/carets/text-caret-" + suffix + ".png", false);
    }

    public void setTextFieldDescription(TextField.Description desc) {
        this.textFieldDesc = desc;
    }

    private final TextField.Description initTextFieldDescription() {
        if (this.textFieldDesc == null) {
            TextField.Description textFieldDesc = new TextField.Description(this.initLabelDescription(), new Border.Description(this.themeProps.textfield_border_size_bottom, this.themeProps.textfield_border_size_right, this.themeProps.textfield_border_size_top, this.themeProps.textfield_border_size_left, HUDTextureUtils.getTexture(this.getName() + "/borders/textfield-normal.png", false)), HUDTextureUtils.getTexture(this.getName() + "/carets/text-caret-" + this.themeProps.textfield_caret_texture + ".png", false));
            textFieldDesc.setAlignment(TextAlignment.CENTER_LEFT);
            textFieldDesc.setBackgroundColor(this.themeProps.textfield_background_color);
            this.textFieldDesc = textFieldDesc;
        }
        return this.textFieldDesc;
    }

    public TextField.Description getTextFieldDescription() {
        return this.initTextFieldDescription().clone();
    }

    public void getTextFieldDescription(TextField.Description desc) {
        desc.set(this.initTextFieldDescription());
    }

    public void setScrollbarDescriptionHorizontal(Scrollbar.Description desc) {
        this.scrollbarDescHoriz = desc;
    }

    private final Scrollbar.Description initScrollbarDescriptionHorizontal() {
        if (this.scrollbarDescHoriz == null) {
            Scrollbar.Description sbDesc;
            this.scrollbarDescHoriz = sbDesc = new Scrollbar.Description(Scrollbar.Direction.HORIZONTAL, HUDTextureUtils.getTexture(this.getName() + "/scrollbar/horizontal/background.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/horizontal/handle_left.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/horizontal/handle_right.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/horizontal/handle_body.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/horizontal/handle_decoration.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/horizontal/decrementor.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/horizontal/incrementor.png", false), this.themeProps.scrollbar_smoothscrolling);
        }
        return this.scrollbarDescHoriz;
    }

    public Scrollbar.Description getScrollbarDescriptionHorizontal() {
        return this.initScrollbarDescriptionHorizontal().clone();
    }

    public void getScrollbarDescriptionHorizontal(Scrollbar.Description desc) {
        desc.set(this.initScrollbarDescriptionHorizontal());
    }

    public void setScrollbarDescriptionVertical(Scrollbar.Description desc) {
        this.scrollbarDescVert = desc;
    }

    private final Scrollbar.Description initScrollbarDescriptionVertical() {
        if (this.scrollbarDescVert == null) {
            Scrollbar.Description sbDesc;
            this.scrollbarDescVert = sbDesc = new Scrollbar.Description(Scrollbar.Direction.VERTICAL, HUDTextureUtils.getTexture(this.getName() + "/scrollbar/vertical/background.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/vertical/handle_top.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/vertical/handle_bottom.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/vertical/handle_body.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/vertical/handle_decoration.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/vertical/decrementor.png", false), HUDTextureUtils.getTexture(this.getName() + "/scrollbar/vertical/incrementor.png", false), this.themeProps.scrollbar_smoothscrolling);
        }
        return this.scrollbarDescVert;
    }

    public Scrollbar.Description getScrollbarDescriptionVertical() {
        return this.initScrollbarDescriptionVertical().clone();
    }

    public void getScrollbarDescriptionVertical(Scrollbar.Description desc) {
        desc.set(this.initScrollbarDescriptionVertical());
    }

    public Texture2D getScrollPanelSpaceTexture() {
        return HUDTextureUtils.getTexture(this.getName() + "/scrollpane/spacer.png", false);
    }

    public void setSliderDescription(Slider.Description desc) {
        this.sliderDesc = desc;
    }

    private final Slider.Description initSliderDescription() {
        if (this.sliderDesc == null) {
            Slider.Description desc;
            this.sliderDesc = desc = new Slider.Description(this.themeProps.slider_size_height, HUDTextureUtils.getTexture(this.getName() + "/slider/left.png", false), HUDTextureUtils.getTexture(this.getName() + "/slider/right.png", false), HUDTextureUtils.getTexture(this.getName() + "/slider/body.png", false), HUDTextureUtils.getTexture(this.getName() + "/slider/value_mark.png", false), HUDTextureUtils.getTexture(this.getName() + "/slider/handle.png", false), this.themeProps.slider_handle_yoffset, this.themeProps.slider_smoothsliding);
        }
        return this.sliderDesc;
    }

    public Slider.Description getSliderDescription() {
        return this.initSliderDescription().clone();
    }

    public void getSliderDescription(Slider.Description desc) {
        desc.set(this.initSliderDescription());
    }

    public void setButtonDescription(Button.Description desc) {
        this.buttonDesc = desc;
    }

    private final Button.Description initButtonDescription() {
        if (this.buttonDesc == null) {
            Button.Description buttonDesc;
            this.buttonDesc = buttonDesc = new Button.Description(this.themeProps.button_size_bottom, this.themeProps.button_size_right, this.themeProps.button_size_top, this.themeProps.button_size_left, this.getName() + "/button/normal.png", this.getName() + "/button/hovered.png", this.getName() + "/button/pressed.png", this.themeProps.button_font, this.themeProps.button_font_color);
        }
        return this.buttonDesc;
    }

    public Button.Description getButtonDescription() {
        return this.initButtonDescription().clone();
    }

    public void getButtonDescription(Button.Description desc) {
        desc.set(this.initButtonDescription());
    }

    public void setRadioButtonDescription(LabeledStateButton.Description desc) {
        this.radioButtonDesc = desc;
    }

    private final LabeledStateButton.Description initRadioButtonDescription() {
        if (this.radioButtonDesc == null) {
            LabeledStateButton.Description radioButtonDesc = new LabeledStateButton.Description(HUDTextureUtils.getTexture(this.getName() + "/radiobutton/deactivated-normal.png", false), HUDTextureUtils.getTexture(this.getName() + "/radiobutton/deactivated-hovered.png", false), HUDTextureUtils.getTexture(this.getName() + "/radiobutton/activated-normal.png", false), HUDTextureUtils.getTexture(this.getName() + "/radiobutton/activated-hovered.png", false), this.themeProps.radiobutton_space_size, this.getLabelDescription());
            radioButtonDesc.getLabelDescription().setAlignment(TextAlignment.CENTER_LEFT);
            this.radioButtonDesc = radioButtonDesc;
        }
        return this.radioButtonDesc;
    }

    public LabeledStateButton.Description getRadioButtonDescription() {
        return this.initRadioButtonDescription().clone();
    }

    public void getRadioButtonDescription(LabeledStateButton.Description desc) {
        desc.set(this.initRadioButtonDescription());
    }

    public void setCheckBoxDescription(LabeledStateButton.Description desc) {
        this.checkboxDesc = desc;
    }

    private final LabeledStateButton.Description initCheckBoxDescription() {
        if (this.checkboxDesc == null) {
            LabeledStateButton.Description checkboxDesc = new LabeledStateButton.Description(HUDTextureUtils.getTexture(this.getName() + "/checkbox/unchecked-normal.png", false), HUDTextureUtils.getTexture(this.getName() + "/checkbox/unchecked-hovered.png", false), HUDTextureUtils.getTexture(this.getName() + "/checkbox/checked-normal.png", false), HUDTextureUtils.getTexture(this.getName() + "/checkbox/checked-hovered.png", false), this.themeProps.checkbox_space_size, this.getLabelDescription());
            checkboxDesc.getLabelDescription().setAlignment(TextAlignment.CENTER_LEFT);
            this.checkboxDesc = checkboxDesc;
        }
        return this.checkboxDesc;
    }

    public LabeledStateButton.Description getCheckBoxDescription() {
        return this.initCheckBoxDescription().clone();
    }

    public void getCheckBoxDescription(LabeledStateButton.Description desc) {
        desc.set(this.initCheckBoxDescription());
    }

    public void setRoundedCornersBorderDescription(Border.Description desc) {
        this.roundedCornersBorderDesc = desc;
    }

    private final Border.Description initRoundedCornersBorderDescription() {
        if (this.roundedCornersBorderDesc == null) {
            Border.Description borderDesc = new Border.Description(this.themeProps.border_rounded_corners_size_bottom, this.themeProps.border_rounded_corners_size_right, this.themeProps.border_rounded_corners_size_top, this.themeProps.border_rounded_corners_size_left);
            borderDesc.setLLupperHeight(this.themeProps.border_rounded_corners_size_ll_upper);
            borderDesc.setLLrightWidth(this.themeProps.border_rounded_corners_size_ll_right);
            borderDesc.setLRleftWidth(this.themeProps.border_rounded_corners_size_lr_left);
            borderDesc.setLRupperHeight(this.themeProps.border_rounded_corners_size_lr_upper);
            borderDesc.setURlowerHeight(this.themeProps.border_rounded_corners_size_ur_lower);
            borderDesc.setURleftWidth(this.themeProps.border_rounded_corners_size_ur_left);
            borderDesc.setULrightWidth(this.themeProps.border_rounded_corners_size_ul_right);
            borderDesc.setULlowerHeight(this.themeProps.border_rounded_corners_size_ul_lower);
            borderDesc.setTexture(HUDTextureUtils.getTexture(this.getName() + "/borders/rounded_corners.png", false));
            borderDesc.setName("rounded_corners");
            this.roundedCornersBorderDesc = borderDesc;
        }
        return this.roundedCornersBorderDesc;
    }

    public Border.Description getRoundedCornersBorderDescription() {
        return this.initRoundedCornersBorderDescription().clone();
    }

    public void getRoundedCornersBorderDescription(Border.Description desc) {
        desc.set(this.initRoundedCornersBorderDescription());
    }

    public Border.Description getStandardBorderDescription() {
        return this.getRoundedCornersBorderDescription();
    }

    public void getStandardBorderDescription(Border.Description desc) {
        this.getRoundedCornersBorderDescription(desc);
    }

    public void setLoweredBevelBorderDescription(Border.Description desc) {
        this.loweredBevelBorderDesc = desc;
    }

    private final Border.Description initLoweredBevelBorderDescription() {
        if (this.loweredBevelBorderDesc == null) {
            Border.Description borderDesc = new Border.Description(this.themeProps.border_bevel_lowered_size_bottom, this.themeProps.border_bevel_lowered_size_right, this.themeProps.border_bevel_lowered_size_top, this.themeProps.border_bevel_lowered_size_left);
            borderDesc.setLLupperHeight(this.themeProps.border_bevel_lowered_size_ll_upper);
            borderDesc.setLLrightWidth(this.themeProps.border_bevel_lowered_size_ll_right);
            borderDesc.setLRleftWidth(this.themeProps.border_bevel_lowered_size_lr_left);
            borderDesc.setLRupperHeight(this.themeProps.border_bevel_lowered_size_lr_upper);
            borderDesc.setURlowerHeight(this.themeProps.border_bevel_lowered_size_ur_lower);
            borderDesc.setURleftWidth(this.themeProps.border_bevel_lowered_size_ur_left);
            borderDesc.setULrightWidth(this.themeProps.border_bevel_lowered_size_ul_right);
            borderDesc.setULlowerHeight(this.themeProps.border_bevel_lowered_size_ul_lower);
            borderDesc.setTexture(HUDTextureUtils.getTexture(this.getName() + "/borders/bevel-lowered.png", false));
            borderDesc.setName("bevel/lowered");
            this.loweredBevelBorderDesc = borderDesc;
        }
        return this.loweredBevelBorderDesc;
    }

    public Border.Description getLoweredBevelBorderDescription() {
        return this.initLoweredBevelBorderDescription().clone();
    }

    public void getLoweredBevelBorderDescription(Border.Description desc) {
        desc.set(this.initLoweredBevelBorderDescription());
    }

    public void setRaisedBevelBorderDescription(Border.Description desc) {
        this.raisedBevelBorderDesc = desc;
    }

    private final Border.Description initRaisedBevelBorderDescription() {
        if (this.raisedBevelBorderDesc == null) {
            Border.Description borderDesc = new Border.Description(this.themeProps.border_bevel_raised_size_bottom, this.themeProps.border_bevel_raised_size_right, this.themeProps.border_bevel_raised_size_top, this.themeProps.border_bevel_raised_size_left);
            borderDesc.setLLupperHeight(this.themeProps.border_bevel_raised_size_ll_upper);
            borderDesc.setLLrightWidth(this.themeProps.border_bevel_raised_size_ll_right);
            borderDesc.setLRleftWidth(this.themeProps.border_bevel_raised_size_lr_left);
            borderDesc.setLRupperHeight(this.themeProps.border_bevel_raised_size_lr_upper);
            borderDesc.setURlowerHeight(this.themeProps.border_bevel_raised_size_ur_lower);
            borderDesc.setURleftWidth(this.themeProps.border_bevel_raised_size_ur_left);
            borderDesc.setULrightWidth(this.themeProps.border_bevel_raised_size_ul_right);
            borderDesc.setULlowerHeight(this.themeProps.border_bevel_raised_size_ul_lower);
            borderDesc.setTexture(HUDTextureUtils.getTexture(this.getName() + "/borders/bevel-raised.png", false));
            borderDesc.setName("bevel/raised");
            this.raisedBevelBorderDesc = borderDesc;
        }
        return this.raisedBevelBorderDesc;
    }

    public Border.Description getRaisedBevelBorderDescription() {
        return this.initRaisedBevelBorderDescription().clone();
    }

    public void getRaisedBevelBorderDescription(Border.Description desc) {
        desc.set(this.initRaisedBevelBorderDescription());
    }

    private Border.Description getBorderDescriptionByName(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("rounded_corners")) {
            return this.getRoundedCornersBorderDescription();
        }
        if (name.equals("bevel/lowered")) {
            return this.getLoweredBevelBorderDescription();
        }
        if (name.equals("bevel/raised")) {
            return this.getRaisedBevelBorderDescription();
        }
        if (name.equals("frame")) {
            return this.getFrameBorderDescription();
        }
        throw new IllegalArgumentException("Unknown named Border.Description \"" + name + "\"");
    }

    public void setWindowHeaderDescription(WindowHeaderWidget.Description desc) {
        this.windowHeaderDesc = desc;
    }

    private final WindowHeaderWidget.Description initWindowHeaderDescription() {
        if (this.windowHeaderDesc == null) {
            WindowHeaderWidget.Description headerDesc;
            this.windowHeaderDesc = headerDesc = new WindowHeaderWidget.Description(HUDTextureUtils.getTexture(this.getName() + "/frame/title-background.png", false), this.themeProps.frame_title_font, this.themeProps.frame_title_font_color, TextAlignment.CENTER_CENTER, new Button.Description(HUDTextureUtils.getTexture(this.getName() + "/frame/close-normal.png", false), HUDTextureUtils.getTexture(this.getName() + "/frame/close-hovered.png", false), HUDTextureUtils.getTexture(this.getName() + "/frame/close-pressed.png", false)));
        }
        return this.windowHeaderDesc;
    }

    public WindowHeaderWidget.Description getWindowHeaderDescription() {
        return this.initWindowHeaderDescription().clone();
    }

    public void getWindowHeaderDescription(WindowHeaderWidget.Description desc) {
        desc.set(this.initWindowHeaderDescription());
    }

    public void setFrameBorderDescription(Border.Description desc) {
        this.windowBorderDesc = desc;
    }

    private final Border.Description initFrameBorderDescription() {
        if (this.windowBorderDesc == null) {
            Border.Description borderDesc = new Border.Description(this.themeProps.border_frame_size_bottom, this.themeProps.border_frame_size_right, this.themeProps.border_frame_size_top, this.themeProps.border_frame_size_left);
            borderDesc.setLLupperHeight(this.themeProps.border_frame_size_ll_upper);
            borderDesc.setLLrightWidth(this.themeProps.border_frame_size_ll_right);
            borderDesc.setLRleftWidth(this.themeProps.border_frame_size_lr_left);
            borderDesc.setLRupperHeight(this.themeProps.border_frame_size_lr_upper);
            borderDesc.setURlowerHeight(this.themeProps.border_frame_size_ur_lower);
            borderDesc.setURleftWidth(this.themeProps.border_frame_size_ur_left);
            borderDesc.setULrightWidth(this.themeProps.border_frame_size_ul_right);
            borderDesc.setULlowerHeight(this.themeProps.border_frame_size_ul_lower);
            borderDesc.setTexture(HUDTextureUtils.getTexture(this.getName() + "/borders/frame.png", false));
            borderDesc.setName("frame");
            this.windowBorderDesc = borderDesc;
        }
        return this.windowBorderDesc;
    }

    public Border.Description getFrameBorderDescription() {
        return this.initFrameBorderDescription().clone();
    }

    public void getFrameBorderDescription(Border.Description desc) {
        desc.set(this.initFrameBorderDescription());
    }

    public Colorf getContentPaneBackgroundColor() {
        return this.themeProps.frame_contentpane_background_color;
    }

    public Texture2D getContentPaneBackgroundTexture() {
        if (this.frame_contentpane_background_texture == null && this.themeProps.frame_contentpane_background_texture != null) {
            this.frame_contentpane_background_texture = HUDTextureUtils.getTexture(this.themeProps.frame_contentpane_background_texture, false);
        }
        if (TextureLoader.isFallbackTexture(this.frame_contentpane_background_texture)) {
            return null;
        }
        return this.frame_contentpane_background_texture;
    }

    public void setProgressBarLabelFont(HUDFont font) {
        this.themeProps.progressbar_label_font = font;
    }

    public HUDFont getProgressBarLabelFont() {
        return this.themeProps.progressbar_label_font;
    }

    public void setProgressBarLabelFontColor(Colorf color) {
        this.themeProps.progressbar_label_font_color = color;
    }

    public Colorf getProgressBarLabelFontColor() {
        return this.themeProps.progressbar_label_font_color;
    }

    public Border.Description getProgressBarBorderDesc() {
        return this.getBorderDescriptionByName(this.themeProps.progressbar_border_name);
    }

    public Label.Description getProgressbarLabelDescription() {
        Label.Description desc = this.getLabelDescription();
        desc.setFont(this.getProgressBarLabelFont(), false);
        desc.setFontColor(this.getProgressBarLabelFontColor(), false);
        desc.setAlignment(TextAlignment.CENTER_CENTER);
        return desc;
    }

    public void setListDescription(List.Description desc) {
        this.listDesc = desc;
    }

    private final List.Description initListDescription() {
        if (this.listDesc == null) {
            List.Description listDesc;
            this.listDesc = listDesc = new List.Description(this.themeProps.list_padding_bottom, this.themeProps.list_padding_right, this.themeProps.list_padding_top, this.themeProps.list_padding_left, this.getBorderDescriptionByName(this.themeProps.list_border_name), this.themeProps.use_texture_for_list_background ? null : this.themeProps.list_background_color, this.themeProps.use_texture_for_list_background ? HUDTextureUtils.getTexture(this.getName() + "/list/background.png", false) : null, null, null, this.themeProps.list_selection_background, this.themeProps.list_selection_foreground);
        }
        return this.listDesc;
    }

    public List.Description getListDescription() {
        return this.initListDescription().clone();
    }

    public void getListDescription(List.Description desc) {
        desc.set(this.initListDescription());
    }

    public void setComboBoxDescription(ComboBox.Description desc) {
        this.comboDesc = desc;
    }

    private final ComboBox.Description initComboBoxDescription() {
        if (this.comboDesc == null) {
            ComboBox.Description comboDesc;
            List.Description listDesc = this.getListDescription();
            listDesc.setBorderDescription(this.getBorderDescriptionByName(this.themeProps.combobox_list_border_name));
            listDesc.setHoverBackgroundColor(this.themeProps.combobox_list_hover_background);
            listDesc.setHoverFontColor(this.themeProps.combobox_list_hover_foreground);
            this.comboDesc = comboDesc = new ComboBox.Description(this.getTextFieldDescription(), listDesc, HUDTextureUtils.getTexture(this.getName() + "/combobox/button_symbol.png", false));
        }
        return this.comboDesc;
    }

    public ComboBox.Description getComboBoxDescription() {
        return this.initComboBoxDescription().clone();
    }

    public void getComboBoxDescription(ComboBox.Description desc) {
        desc.set(this.initComboBoxDescription());
    }

    public void setProgressBarDescription(ProgressBar.Description desc) {
        this.progressbarDesc = desc;
    }

    private final ProgressBar.Description initProgressBarDescription() {
        if (this.progressbarDesc == null) {
            ProgressBar.Description pbDesc;
            this.progressbarDesc = pbDesc = new ProgressBar.Description(this.themeProps.progressbar_bar_bottom_height, this.themeProps.progressbar_bar_right_width, this.themeProps.progressbar_bar_top_height, this.themeProps.progressbar_bar_left_width, null, null, HUDTextureUtils.getTexture(this.getName() + "/progressbar/body.png", false), this.getBorderDescriptionByName(this.themeProps.progressbar_border_name), this.getProgressbarLabelDescription());
        }
        return this.progressbarDesc;
    }

    public ProgressBar.Description getProgressBarDescription() {
        return this.initProgressBarDescription().clone();
    }

    public void getProgressBarDescription(ProgressBar.Description desc) {
        desc.set(this.initProgressBarDescription());
    }

    private final Cursor newCursor(String textureName, int zeroX, int zeroY) {
        if (textureName == null || textureName.length() == 0) {
            return null;
        }
        Texture2D texture = HUDTextureUtils.getTexture(this.getName() + "/cursors/" + textureName, false);
        return new Cursor(texture, zeroX, zeroY);
    }

    private final CursorSet initCursorSet() {
        if (this.cursorSet == null) {
            CursorSet cursorSet = new CursorSet();
            cursorSet.setPointer1(this.newCursor(this.themeProps.cursor_pointer1_texture, this.themeProps.cursor_pointer1_zero_x, this.themeProps.cursor_pointer1_zero_y));
            cursorSet.setPointer2(this.newCursor(this.themeProps.cursor_pointer2_texture, this.themeProps.cursor_pointer2_zero_x, this.themeProps.cursor_pointer2_zero_y));
            cursorSet.setCrosshair(this.newCursor(this.themeProps.cursor_crosshair_texture, this.themeProps.cursor_crosshair_zero_x, this.themeProps.cursor_crosshair_zero_y));
            cursorSet.setTextCursor(this.newCursor(this.themeProps.cursor_text_texture, this.themeProps.cursor_text_zero_x, this.themeProps.cursor_text_zero_y));
            cursorSet.setHelpCursor(this.newCursor(this.themeProps.cursor_help_texture, this.themeProps.cursor_help_zero_x, this.themeProps.cursor_help_zero_y));
            cursorSet.setWaitCursor(this.newCursor(this.themeProps.cursor_wait_texture, this.themeProps.cursor_wait_zero_x, this.themeProps.cursor_wait_zero_y));
            this.cursorSet = cursorSet;
        }
        return this.cursorSet;
    }

    public CursorSet getCursorSet() {
        return this.initCursorSet().clone();
    }

    public void getCursorSet(CursorSet cs) {
        cs.set(this.initCursorSet());
    }

    protected WidgetTheme(ThemeProperties themeProps) {
        this.themeProps = themeProps;
    }

    protected static ThemeProperties loadThemeProps(InputStream in) throws IOException {
        ZipEntry en;
        ZipInputStream zipIn = new ZipInputStream(in);
        while ((en = zipIn.getNextEntry()) != null) {
            if (!en.getName().equals("theme.properties")) continue;
            return new ThemeProperties(zipIn);
        }
        throw new IOException("No \"theme.properties\" entry found in the theme archive.");
    }

    public WidgetTheme(URL url) throws IOException {
        this(WidgetTheme.loadThemeProps(url.openStream()));
        TextureLoader.getInstance().addTextureStreamLocator(new TextureStreamLocatorZip(url, "textures/"));
    }

    private static URL getThemeResource(String name) throws IOException {
        URL resource = WidgetTheme.class.getClassLoader().getResource("resources/org/xith3d/hud/themes/" + name + ".xwt");
        if (resource == null) {
            throw new IOException("The Theme resource with the name \"" + name + "\" was not found in the classpath.");
        }
        return resource;
    }

    public WidgetTheme(String name) throws IOException {
        this(WidgetTheme.getThemeResource(name));
    }

    private static URL file2url(File file) throws IOException {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public WidgetTheme(File zipFile) throws IOException {
        this(WidgetTheme.file2url(zipFile));
    }
}

