/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import java.util.ArrayList;
import java.util.HashSet;
import org.xith3d.ui.hud.base.StateButton;
import org.xith3d.ui.hud.listeners.WidgetStateListener;

public class ButtonGroup {
    private final HashSet<StateButton> buttons = new HashSet();
    private StateButton currentActivated = null;
    private final ArrayList<WidgetStateListener> listeners = new ArrayList();

    public void addStateListener(WidgetStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeStateListener(WidgetStateListener listener) {
        this.listeners.remove(listener);
    }

    protected final void notifyListeners(StateButton button) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onButtonStateChanged(button, button.getState(), button.getUserObject());
        }
    }

    public void onButtonActivated(StateButton button) {
        if (this.buttons.contains(button)) {
            if (this.currentActivated != null) {
                this.currentActivated.setState(false);
            }
            this.currentActivated = button;
            this.notifyListeners(this.currentActivated);
        }
    }

    public void addStateButton(StateButton button) {
        this.buttons.add(button);
        button.setStateGroup(this);
    }

    public void removeStateButton(StateButton button) {
        if (this.buttons.remove(button)) {
            button.setStateGroup(null);
        }
    }
}

