/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.ui.hud.utils.DropShadowFactory;

public class DefaultDropShadowFactory
extends DropShadowFactory {
    private int offsetX = 0;
    private int offsetY = 0;
    private Colorf startColor = new Colorf(0.0f, 0.0f, 0.0f, 0.0f);
    private byte[] pixelLine = null;

    protected int getOffsetX() {
        return this.offsetX;
    }

    protected int getOffsetY() {
        return this.offsetY;
    }

    protected Colorf getStartColor() {
        return this.startColor;
    }

    public void drawDropShadow(int widgetRight, int widgetBottom, int widgetWidth, int widgetHeight, int zIndex, Texture2DCanvas texCanvas) {
        int dist;
        int i;
        int j;
        TextureImage2D image = texCanvas.getImage();
        int offsetX = this.getOffsetX();
        int offsetY = this.getOffsetY();
        int shadowWidth = this.getDropShadowWidth();
        int shadowHeight = this.getDropShadowHeight();
        int bufferSize = (widgetWidth + this.getDropShadowWidth()) * 4;
        if (this.pixelLine == null || this.pixelLine.length < bufferSize) {
            this.pixelLine = new byte[bufferSize];
        }
        Colorf startColor = this.getStartColor();
        byte r0 = startColor.getRedByte();
        byte g0 = startColor.getGreenByte();
        byte b0 = startColor.getBlueByte();
        int a0 = startColor.getAlphaInt();
        for (j = 0; j < shadowWidth; ++j) {
            for (i = 0; i < shadowWidth; ++i) {
                dist = Math.min((int)FastMath.sqrt(i * i + (shadowWidth - j) * (shadowWidth - j)), shadowWidth);
                this.pixelLine[i * 4 + 0] = r0;
                this.pixelLine[i * 4 + 1] = g0;
                this.pixelLine[i * 4 + 2] = b0;
                this.pixelLine[i * 4 + 3] = (byte)((shadowWidth - dist) * (255 - a0) / shadowWidth);
            }
            image.drawPixelLine(this.pixelLine, 4, widgetRight, widgetBottom - widgetHeight + offsetY + j, shadowWidth, true, null);
        }
        for (j = offsetY + shadowWidth; j < widgetHeight; ++j) {
            for (i = 0; i < shadowWidth; ++i) {
                this.pixelLine[i * 4 + 0] = r0;
                this.pixelLine[i * 4 + 1] = g0;
                this.pixelLine[i * 4 + 2] = b0;
                this.pixelLine[i * 4 + 3] = (byte)((shadowWidth - i) * (255 - a0) / shadowWidth);
            }
            image.drawPixelLine(this.pixelLine, 4, widgetRight, widgetBottom - widgetHeight + j, shadowWidth, true, null);
        }
        for (j = 0; j < shadowHeight; ++j) {
            for (i = 0; i < shadowHeight; ++i) {
                dist = Math.min((int)FastMath.sqrt((shadowHeight - i) * (shadowHeight - i) + j * j), shadowHeight);
                this.pixelLine[i * 4 + 0] = r0;
                this.pixelLine[i * 4 + 1] = g0;
                this.pixelLine[i * 4 + 2] = b0;
                this.pixelLine[i * 4 + 3] = (byte)((shadowHeight - dist) * (255 - a0) / shadowHeight);
            }
            image.drawPixelLine(this.pixelLine, 4, widgetRight - widgetWidth + offsetX, widgetBottom + j, shadowHeight, true, null);
        }
        for (j = 0; j < shadowHeight; ++j) {
            for (i = 0; i < widgetWidth - offsetX - shadowHeight; ++i) {
                this.pixelLine[i * 4 + 0] = r0;
                this.pixelLine[i * 4 + 1] = g0;
                this.pixelLine[i * 4 + 2] = b0;
                this.pixelLine[i * 4 + 3] = (byte)((shadowHeight - j) * (255 - a0) / shadowWidth);
            }
            image.drawPixelLine(this.pixelLine, 4, widgetRight - widgetWidth + offsetX + shadowHeight, widgetBottom + j, widgetWidth - offsetX - shadowHeight, true, null);
        }
        int m = (int)((float)(shadowWidth + shadowHeight) / 2.0f);
        for (int j2 = 0; j2 < shadowHeight; ++j2) {
            for (int i2 = 0; i2 < shadowWidth; ++i2) {
                int dist2 = Math.min((int)FastMath.sqrt(i2 * i2 + j2 * j2), m);
                this.pixelLine[i2 * 4 + 0] = r0;
                this.pixelLine[i2 * 4 + 1] = g0;
                this.pixelLine[i2 * 4 + 2] = b0;
                this.pixelLine[i2 * 4 + 3] = (byte)((m - dist2) * (255 - a0) / m);
            }
            image.drawPixelLine(this.pixelLine, 4, widgetRight, widgetBottom + j2, shadowWidth, true, null);
        }
    }

    public DefaultDropShadowFactory(int width, int height) {
        super(width, height);
    }

    public DefaultDropShadowFactory() {
        this(20, 20);
    }
}

