/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import java.awt.RenderingHints;
import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.TileMode;

public class DrawUtils {
    private static final boolean useBicubicFiltering() {
        return true;
    }

    public static void drawImage(Colorf color, Texture2D texture, TileMode tileMode, Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        TextureImage2D image = texCanvas.getTexture().getImage0();
        if (color != null) {
            image.fillRectangle(color, offsetX, offsetY, width, height, true, null);
        }
        if (texture != null) {
            TextureImage2D img = texture.getImage0();
            if (tileMode != null) {
                int imgWidth = HUDTextureUtils.getTextureWidth(texture);
                int imgHeight = HUDTextureUtils.getTextureHeight(texture);
                switch (tileMode) {
                    case STRETCH: {
                        boolean ubcf = DrawUtils.useBicubicFiltering();
                        Object oldInterpolation = null;
                        if (ubcf) {
                            oldInterpolation = texCanvas.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
                            texCanvas.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        }
                        if (width == imgWidth && height == imgHeight) {
                            image.drawImage(img, offsetX, offsetY, true, null);
                        } else {
                            texCanvas.drawImage(img.getBufferedImage(), offsetX, offsetY + height - 1, offsetX + width - 1, offsetY, 0, 0, imgWidth, imgHeight);
                        }
                        if (!ubcf) break;
                        if (oldInterpolation == null) {
                            texCanvas.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                            break;
                        }
                        texCanvas.setRenderingHint(RenderingHints.KEY_INTERPOLATION, oldInterpolation);
                        break;
                    }
                    case TILE_X: {
                        image.drawImage(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, width, imgHeight, true, null);
                        break;
                    }
                    case TILE_Y: {
                        image.drawImage(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, imgWidth, height, true, null);
                        break;
                    }
                    case TILE_BOTH: {
                        image.drawImage(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, width, height, true, null);
                    }
                }
            } else {
                image.drawImage(img, offsetX, offsetY, true, null);
            }
        }
    }

    public static void clearImage(Colorf color, Texture2D texture, TileMode tileMode, Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        block11: {
            TextureImage2D img;
            TextureImage2D image;
            block12: {
                image = texCanvas.getTexture().getImage0();
                if (color != null) {
                    image.clear(color, offsetX, offsetY, width, height, true, null);
                }
                if (texture == null) break block11;
                img = texture.getImage0();
                if (tileMode == null) break block12;
                int imgWidth = HUDTextureUtils.getTextureWidth(texture);
                int imgHeight = HUDTextureUtils.getTextureHeight(texture);
                switch (tileMode) {
                    case STRETCH: {
                        if (width == imgWidth && height == imgHeight) {
                            image.clear(img, offsetX, offsetY, true, null);
                            break;
                        }
                        image.clear(offsetX, offsetY, width, height, true, null);
                        boolean ubcf = DrawUtils.useBicubicFiltering();
                        Object oldInterpolation = null;
                        if (ubcf) {
                            oldInterpolation = texCanvas.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
                            texCanvas.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        }
                        texCanvas.drawImage(img.getBufferedImage(), offsetX, offsetY + height, offsetX + width, offsetY, 0, 0, imgWidth, imgHeight);
                        if (ubcf) {
                            if (oldInterpolation == null) {
                                texCanvas.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                                break;
                            }
                            texCanvas.setRenderingHint(RenderingHints.KEY_INTERPOLATION, oldInterpolation);
                            break;
                        }
                        break block11;
                    }
                    case TILE_X: {
                        image.clear(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, width, imgHeight, true, null);
                        break;
                    }
                    case TILE_Y: {
                        image.clear(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, imgWidth, height, true, null);
                        break;
                    }
                    case TILE_BOTH: {
                        image.clear(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, width, height, true, null);
                    }
                }
                break block11;
            }
            image.clear(img, offsetX, offsetY, true, null);
        }
    }
}

