/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.xith3d.ui.hud.HUD;

public class HUDFont {
    public static final FontStyle PLAIN = FontStyle.PLAIN;
    public static final FontStyle BOLD = FontStyle.BOLD;
    public static final FontStyle ITALIC = FontStyle.ITALIC;
    public static final FontStyle BOLD_ITALIC = FontStyle.BOLD_ITALIC;
    private static final Graphics2D GRAPHICS = new BufferedImage(16, 16, 5).createGraphics();
    private static final HashMap<String, HUDFont> MAP = new HashMap();
    private static boolean useFontScaling = true;
    private final URL url;
    private final String name;
    private final FontStyle style;
    private final int size;
    private int lastHUDHeight = -1;
    private Font awtFont = null;
    private FontMetrics metrics = null;

    public static final void setUseFontScaling(boolean useFontScaling) {
        HUDFont.useFontScaling = useFontScaling;
    }

    public static final boolean getUseFontScaling() {
        return useFontScaling;
    }

    public final String getName() {
        return this.name;
    }

    public final FontStyle getStyle() {
        return this.style;
    }

    public final int getSize() {
        return this.size;
    }

    public final HUDFont derive(FontStyle style, int size) {
        if (this.url != null) {
            try {
                return HUDFont.getFont(this.url, style, size);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return HUDFont.getFont(this.getName(), style, size);
    }

    public final HUDFont derive(FontStyle style) {
        if (this.url != null) {
            try {
                return HUDFont.getFont(this.url, style, this.getSize());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return HUDFont.getFont(this.getName(), style, this.getSize());
    }

    public final HUDFont derive(int size) {
        if (this.url != null) {
            try {
                return HUDFont.getFont(this.url, this.getStyle(), size);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return HUDFont.getFont(this.getName(), this.getStyle(), size);
    }

    public final Font getAWTFont(HUD hud) {
        boolean useScaling;
        boolean bl = useScaling = useFontScaling && hud.hasCustomResolution();
        if (useScaling) {
            if (this.awtFont == null || this.lastHUDHeight != (int)hud.getResY()) {
                if (this.url == null) {
                    this.awtFont = new Font(this.name, this.style.getAWTStyle(), Math.round((float)this.size * hud.getHeight() / hud.getResY()));
                } else if (this.awtFont == null) {
                    try {
                        this.awtFont = Font.createFont(0, this.url.openStream()).deriveFont(Math.round((float)this.size * hud.getHeight() / hud.getResY())).deriveFont(this.style.getAWTStyle(), this.size);
                    }
                    catch (Throwable t) {
                        throw new Error(t);
                    }
                } else {
                    this.awtFont = this.awtFont.deriveFont(this.style.getAWTStyle(), this.size);
                }
                this.metrics = null;
                this.lastHUDHeight = (int)hud.getResY();
            }
        } else if (this.awtFont == null) {
            if (this.url == null) {
                this.awtFont = new Font(this.name, this.style.getAWTStyle(), this.size);
            } else {
                try {
                    this.awtFont = Font.createFont(0, this.url.openStream()).deriveFont(this.style.getAWTStyle(), this.size);
                }
                catch (Throwable t) {
                    throw new Error(t);
                }
            }
            this.metrics = null;
        }
        return this.awtFont;
    }

    public final FontMetrics getFontMetrics(HUD hud) {
        if (this.metrics == null || useFontScaling && hud.hasCustomResolution() && this.lastHUDHeight != (int)hud.getResY()) {
            this.metrics = GRAPHICS.getFontMetrics(this.getAWTFont(hud));
        }
        return this.metrics;
    }

    private static final String getString(String name, FontStyle style, int size) {
        return name + "-" + style.name() + "-" + size;
    }

    public String toString() {
        return HUDFont.getString(this.getName(), this.getStyle(), this.getSize());
    }

    private HUDFont(URL url, String name, FontStyle style, int size) {
        this.url = url;
        this.name = name;
        this.style = style;
        this.size = size;
    }

    public static final HUDFont getFont(String name, FontStyle style, int size) {
        HUDFont font = MAP.get(HUDFont.getString(name, style, size));
        if (font == null) {
            font = new HUDFont(null, name, style, size);
            MAP.put(HUDFont.getString(name, style, size), font);
        }
        return font;
    }

    public static final HUDFont getFont(URL url, FontStyle style, int size) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        String name = url.toString();
        HUDFont font = MAP.get(HUDFont.getString(name, style, size));
        if (font == null) {
            InputStream is = url.openStream();
            is.close();
            font = new HUDFont(url, name, style, size);
            MAP.put(HUDFont.getString(name, style, size), font);
        }
        return font;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontStyle {
        PLAIN(0),
        BOLD(1),
        ITALIC(2),
        BOLD_ITALIC(3);

        private final int awtStyle;

        public final int getAWTStyle() {
            return this.awtStyle;
        }

        public final FontStyle makeItalic() {
            if (this == PLAIN) {
                return ITALIC;
            }
            if (this == BOLD) {
                return BOLD_ITALIC;
            }
            return this;
        }

        public final FontStyle makeNonItalic() {
            if (this == ITALIC) {
                return PLAIN;
            }
            if (this == BOLD_ITALIC) {
                return BOLD;
            }
            return this;
        }

        public final FontStyle makeBold() {
            if (this == PLAIN) {
                return BOLD;
            }
            if (this == BOLD) {
                return BOLD_ITALIC;
            }
            return this;
        }

        public final FontStyle makeNonBold() {
            if (this == BOLD) {
                return PLAIN;
            }
            if (this == BOLD_ITALIC) {
                return ITALIC;
            }
            return this;
        }

        private FontStyle(int awtStyle) {
            this.awtStyle = awtStyle;
        }

        public static final FontStyle getFromAWTStyle(int awtStyle) {
            switch (awtStyle) {
                case 0: {
                    return PLAIN;
                }
                case 1: {
                    return BOLD;
                }
                case 2: {
                    return ITALIC;
                }
                case 3: {
                    return BOLD_ITALIC;
                }
            }
            throw new IllegalArgumentException("Unknown awt font style " + awtStyle);
        }
    }
}

