/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.types.twodee.Dim2f;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.WidgetAssembler;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.base.__HUD_base_PrivilegedAccess;
import org.xith3d.ui.hud.listeners.ScrollbarListener;
import org.xith3d.ui.hud.listeners.WidgetContainerListener;
import org.xith3d.ui.hud.listeners.WidgetLocationListener;
import org.xith3d.ui.hud.listeners.WidgetMouseListener;
import org.xith3d.ui.hud.listeners.WidgetSizeListener;
import org.xith3d.ui.hud.utils.ScrollMode;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Scrollbar;

public abstract class ScrollHandler
implements ScrollbarListener,
WidgetContainerListener,
WidgetLocationListener,
WidgetSizeListener,
WidgetMouseListener {
    private final Widget widget;
    private final WidgetAssembler widgetAssembler;
    private float maxRight = 0.0f;
    private float maxBottom = 0.0f;
    private ScrollMode mode = ScrollMode.AUTO;
    private Scrollbar scrollbarH = null;
    private Scrollbar scrollbarV = null;
    private Image spacerImage;
    private int numIgnoredEvents_H = 0;
    private int numIgnoredEvents_V = 0;

    public abstract void onScrolled(Scrollbar.Direction var1, int var2);

    public void onScrollbarValueChanged(Scrollbar scrollbar, int newValue) {
        if (scrollbar.getDirection() == Scrollbar.Direction.HORIZONTAL && this.numIgnoredEvents_H > 0) {
            --this.numIgnoredEvents_H;
            return;
        }
        if (scrollbar.getDirection() == Scrollbar.Direction.VERTICAL && this.numIgnoredEvents_V > 0) {
            --this.numIgnoredEvents_V;
            return;
        }
        this.onScrolled(scrollbar.getDirection(), newValue);
    }

    public void setScrollMode(ScrollMode mode) {
        this.mode = mode;
    }

    public final ScrollMode getScrollMode() {
        return this.mode;
    }

    public void setLineHeight(int lineHeight) {
        if (this.scrollbarV == null) {
            return;
        }
        this.scrollbarV.setSmallIncrement(lineHeight);
    }

    public final int getLineHeight() {
        if (this.scrollbarV == null) {
            return 0;
        }
        return this.scrollbarV.getSmallIncrement();
    }

    public void setScrollHValue(int value) {
        if (this.scrollbarH == null) {
            return;
        }
        ++this.numIgnoredEvents_H;
        this.scrollbarH.setValue(value);
    }

    public void setScrollVValue(int value) {
        if (this.scrollbarV == null) {
            return;
        }
        ++this.numIgnoredEvents_V;
        this.scrollbarV.setValue(value);
    }

    private final void mergeWidgetIntoBounds(Widget widget) {
        if (widget.getLeft() + widget.getWidth() > this.maxRight) {
            this.maxRight = widget.getLeft() + widget.getWidth();
        }
        if (widget.getTop() + widget.getHeight() > this.maxBottom) {
            this.maxBottom = widget.getTop() + widget.getHeight();
        }
    }

    private void updateScrollbarsFromBounds() {
        boolean scrollVForced;
        boolean scrollHForced = this.mode == ScrollMode.ALWAYS || this.mode == ScrollMode.ALWAYS_HORIZONTAL;
        boolean bl = scrollVForced = this.mode == ScrollMode.ALWAYS || this.mode == ScrollMode.ALWAYS_VERTICAL;
        if (this.scrollbarH != null) {
            this.scrollbarH.setVisible(scrollHForced);
        }
        if (this.scrollbarV != null) {
            this.scrollbarV.setVisible(scrollVForced);
        }
        if (this.spacerImage != null) {
            this.spacerImage.setVisible(false);
        }
        this.widgetAssembler.setAdditionalContentSize(0, 0, 0, 0);
        if (this.mode != ScrollMode.NEVER) {
            int value;
            int maxValue;
            float contentWidth = this.widget.getContentWidth();
            float contentHeight = this.widget.getContentHeight();
            int acw = 0;
            int ach = 0;
            boolean scrollV = false;
            boolean scrollH = false;
            if (this.scrollbarV != null && (scrollVForced || this.maxBottom > contentHeight)) {
                scrollV = true;
                this.scrollbarV.setVisible(true);
                acw = this.scrollbarV.getWidthOrHeightInPixels();
                this.widgetAssembler.setAdditionalContentSize(0, 0, -acw, -ach);
                contentWidth = this.widget.getContentWidth();
                contentHeight = this.widget.getContentHeight();
            }
            if (this.scrollbarH != null && (scrollHForced || this.maxRight > contentWidth)) {
                scrollH = true;
                this.scrollbarH.setVisible(true);
                ach = this.scrollbarH.getWidthOrHeightInPixels();
                this.widgetAssembler.setAdditionalContentSize(0, 0, -acw, -ach);
                contentWidth = this.widget.getContentWidth();
                contentHeight = this.widget.getContentHeight();
            }
            if (this.scrollbarV != null && !this.scrollbarV.isVisible() && this.scrollbarH != null && this.scrollbarH.isVisible() && (scrollVForced || this.maxBottom > contentHeight)) {
                scrollV = true;
                this.scrollbarV.setVisible(true);
                acw = this.scrollbarV.getWidthOrHeightInPixels();
                this.widgetAssembler.setAdditionalContentSize(0, 0, -acw, -ach);
                contentWidth = this.widget.getContentWidth();
                contentHeight = this.widget.getContentHeight();
            }
            if (this.scrollbarV != null && this.maxBottom > contentHeight) {
                maxValue = (int)Math.ceil(this.maxBottom - contentHeight);
                value = Math.min(this.scrollbarV.getValue(), maxValue);
                this.scrollbarV.setMinMaxAndValue(0, maxValue, value, (int)contentHeight);
            } else {
                this.scrollbarV.setMinMaxAndValue(0, 0, 0);
            }
            if (this.scrollbarH != null && this.maxRight > contentWidth) {
                maxValue = (int)Math.ceil(this.maxRight - contentWidth);
                value = Math.min(this.scrollbarH.getValue(), maxValue);
                this.scrollbarH.setMinMaxAndValue(0, maxValue, value, (int)contentWidth);
            } else {
                this.scrollbarH.setMinMaxAndValue(0, 0, 0);
            }
            if (this.spacerImage != null && scrollH && scrollV) {
                this.spacerImage.setVisible(true);
            }
        }
    }

    private final void updateBounds() {
        if (!(this.widget instanceof WidgetContainer) || this.widget.getHUD() == null) {
            return;
        }
        WidgetContainer wc = (WidgetContainer)this.widget;
        this.maxRight = 0.0f;
        this.maxBottom = 0.0f;
        for (int i = 0; i < wc.getWidgetsCount(); ++i) {
            Widget w = wc.getWidget(i);
            this.mergeWidgetIntoBounds(w);
        }
        this.updateScrollbarsFromBounds();
    }

    public void setBounds(float maxRight, float maxBottom) {
        this.maxRight = maxRight;
        this.maxBottom = maxBottom;
        this.updateScrollbarsFromBounds();
    }

    public void onWidgetAttachedToContainer(Widget widget, WidgetContainer container) {
        if (widget != this.widget) {
            widget.addSizeListener(this);
            widget.addLocationListener(this);
            this.mergeWidgetIntoBounds(widget);
        }
    }

    public void onWidgetDetachedFromContainer(Widget widget, WidgetContainer container) {
        if (widget != this.widget) {
            widget.removeSizeListener(this);
            widget.removeLocationListener(this);
            this.mergeWidgetIntoBounds(widget);
        }
    }

    public void onWidgetAttachedToHUD(Widget widget, HUD hud) {
        if (widget == this.widget) {
            this.updateScrollbarSizesToMatchWidget();
            this.updateBounds();
        }
    }

    public void onWidgetDetachedFromHUD(Widget widget, HUD hud) {
    }

    public void onWidgetDragStarted(Widget widget) {
    }

    public void onWidgetDragStopped(Widget widget) {
    }

    public void onWidgetLocationChanged(Widget widget, float oldLeft, float oldTop, float newLeft, float newTop) {
        this.updateBounds();
    }

    public void onWidgetSizeChanged(Widget widget, float oldWidth, float oldHeight, float newWidth, float newHeight) {
        if (widget == this.widget) {
            if (widget.getHUD() != null) {
                this.updateScrollbarSizesToMatchWidget();
            }
        } else {
            this.updateBounds();
        }
    }

    public void onMouseButtonPressed(Widget widget, MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
    }

    public void onMouseButtonReleased(Widget widget, MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
    }

    public void onMouseMoved(Widget widget, float x, float y, int buttonsState, long when, boolean isTopMost, boolean hasFocus) {
    }

    public void onMouseStopped(Widget widget, float x, float y, long when, boolean isTopMost, boolean hasFocus) {
    }

    public void onMouseWheelMoved(Widget widget, int delta, boolean isPageMove, float x, float y, long when, boolean isTopMost) {
        if (this.scrollbarV != null && this.scrollbarV.isVisible()) {
            this.scrollbarV.setValue(this.scrollbarV.getValue() - delta * this.scrollbarV.getSmallIncrement());
            return;
        }
        if (this.scrollbarH != null && this.scrollbarH.isVisible()) {
            this.scrollbarH.setValue(this.scrollbarH.getValue() - delta * this.scrollbarH.getSmallIncrement());
            return;
        }
    }

    public void onMouseEntered(Widget widget, boolean isTopMost, boolean hasFocus) {
    }

    public void onMouseExited(Widget widget, boolean isTopMost, boolean hasFocus) {
    }

    public void onInputStateChanged(Widget widget, DeviceComponent comp, int delta, int state, long when, boolean isTopMost, boolean hasFocus) {
    }

    protected Scrollbar createHorizontalScrollbar(float width) {
        return new Scrollbar(width, Scrollbar.Direction.HORIZONTAL);
    }

    protected Scrollbar createVerticalScrollbar(float height) {
        return new Scrollbar(height, Scrollbar.Direction.VERTICAL);
    }

    private void updateScrollbarSizesToMatchWidget() {
        float left = 0.0f;
        float top = 0.0f;
        float width = this.widget.getWidth();
        float height = this.widget.getHeight();
        if (this.widget.getBorder() != null) {
            Dim2f buffer1 = Dim2f.fromPool();
            Dim2f buffer2 = Dim2f.fromPool();
            __HUD_base_PrivilegedAccess.getBorderSizeInHUDSpace(this.widget, buffer1, buffer2);
            left += buffer1.getWidth();
            top += buffer1.getHeight();
            width -= buffer1.getWidth() + buffer2.getWidth();
            height -= buffer1.getHeight() + buffer2.getHeight();
            Dim2f.toPool(buffer2);
            Dim2f.toPool(buffer1);
        }
        boolean scrollHorizontal = this.scrollbarH != null && this.scrollbarH.isVisible();
        boolean scrollVertical = this.scrollbarV != null && this.scrollbarV.isVisible();
        int sbW = 0;
        int sbH = 0;
        if (scrollHorizontal) {
            this.scrollbarH.setSize(width - (scrollVertical ? this.scrollbarV.getWidth() : 0.0f), this.scrollbarH.getHeight());
            this.widgetAssembler.reposition(this.scrollbarH, left, top + height - this.scrollbarH.getHeight());
            sbH = this.scrollbarH.getWidthOrHeightInPixels();
        }
        if (scrollVertical) {
            this.scrollbarV.setSize(this.scrollbarV.getWidth(), height - (scrollHorizontal ? this.scrollbarH.getHeight() : 0.0f));
            this.widgetAssembler.reposition(this.scrollbarV, left + width - this.scrollbarV.getWidth(), top);
            sbW = this.scrollbarV.getWidthOrHeightInPixels();
        }
        if (scrollHorizontal && scrollVertical) {
            this.spacerImage.setSize(this.scrollbarV.getWidth(), this.scrollbarH.getHeight());
            this.widgetAssembler.reposition(this.spacerImage, left + width - this.scrollbarV.getWidth(), top + height - this.scrollbarH.getHeight());
        }
        this.widgetAssembler.setAdditionalContentSize(0, 0, -sbW, -sbH);
    }

    public ScrollHandler(Widget widget, WidgetAssembler widgetAssembler, boolean scrollHorizontal, boolean scrollVertical) {
        if (!scrollHorizontal && !scrollVertical) {
            throw new IllegalArgumentException("A ScrollHandler is useless without any scroll direction being handled.");
        }
        this.widget = widget;
        this.widgetAssembler = widgetAssembler;
        widgetAssembler.setPickDispatched(true);
        float left = 0.0f;
        float top = 0.0f;
        float width = widget.getWidth();
        float height = widget.getHeight();
        float defaultSBSize = 16.0f;
        if (scrollHorizontal) {
            this.scrollbarH = this.createHorizontalScrollbar(width - (scrollVertical ? 16.0f : 0.0f));
            this.scrollbarH.addScrollbarListener(this);
            widgetAssembler.addWidget(this.scrollbarH, left, top + height - 16.0f);
        }
        if (scrollVertical) {
            this.scrollbarV = this.createVerticalScrollbar(height - (scrollHorizontal ? 16.0f : 0.0f));
            this.scrollbarV.addScrollbarListener(this);
            widgetAssembler.addWidget(this.scrollbarV, left + width - 16.0f, top);
        }
        if (scrollHorizontal && scrollVertical) {
            this.spacerImage = new Image(false, 16.0f, 16.0f, HUD.getTheme().getScrollPanelSpaceTexture());
            widgetAssembler.addWidget(this.spacerImage, left + width - 16.0f, top + height - 16.0f);
        }
        widget.addSizeListener(this);
        widget.addContainerListener(this);
        widget.addMouseListener(this);
    }
}

