/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Vector2f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.impl.ScheduledOperationImpl;
import org.xith3d.ui.hud.base.Widget;

public class WidgetMover {
    private Widget widget;
    private float startX = -1.0f;
    private float startY = -1.0f;
    private float destX;
    private float destY;
    private float speed;
    private Mover mover = new Mover();

    public Widget getWidget() {
        return this.widget;
    }

    public Tuple2f getStartLocation() {
        return new Point2f(this.startX, this.startY);
    }

    public float getStartLocationX() {
        return this.startX;
    }

    public float getStartLocationY() {
        return this.startY;
    }

    public void setDestinationLocation(Tuple2f destLocation) {
        this.destX = destLocation.getX();
        this.destY = destLocation.getY();
    }

    public void setDestinationLocation(float destLocationX, float destLocationY) {
        this.destX = destLocationX;
        this.destY = destLocationY;
    }

    public Tuple2f getDestinationLocation() {
        return new Point2f(this.destX, this.destY);
    }

    public float getDestinationLocationX() {
        return this.destX;
    }

    public float getDestinationLocationY() {
        return this.destY;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void startMoving() {
        this.mover.startMoving();
    }

    public boolean isMoving() {
        return this.mover.isAlive();
    }

    protected void onMovementStopped() {
    }

    public void invert() {
        if (!this.isMoving()) {
            return;
        }
        this.mover.setSuspended(true);
        float sx = this.startX;
        float sy = this.startY;
        this.startX = this.destX;
        this.startY = this.destY;
        this.destX = sx;
        this.destY = sy;
        long tt = (long)(this.mover.pathTotalLength / this.getSpeed() * 1000.0f);
        long t = (long)(this.mover.path.length() / this.getSpeed() * 1000.0f);
        this.mover.pathTotal.negate();
        this.mover.pathNorm.negate();
        this.mover.startTime = this.mover.startTime + 2L * t - tt;
        this.mover.setSuspended(false);
    }

    public WidgetMover(Widget widget, float destX, float destY, float speed) {
        this.widget = widget;
        this.destX = destX;
        this.destY = destY;
        this.speed = speed;
    }

    public WidgetMover(Widget widget, Tuple2f destLocation, float speed) {
        this(widget, destLocation.getX(), destLocation.getY(), speed);
    }

    public WidgetMover(Widget widget) {
        this(widget, widget.getLeft(), widget.getTop(), 0.0f);
    }

    private class Mover
    extends ScheduledOperationImpl {
        private long startTime;
        private Vector2f pathTotal;
        private float pathTotalLength;
        private Vector2f pathNorm;
        private Vector2f path;
        private boolean isSuspended;

        public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
            if (this.isSuspended) {
                return;
            }
            if (this.startTime >= 0L) {
                float dt = timingMode.getSecondsAsFloat(gameTime - this.startTime);
                this.path.scale(WidgetMover.this.speed * dt, this.pathNorm);
                if (this.path.length() < this.pathTotalLength) {
                    WidgetMover.this.widget.setLocation(WidgetMover.this.startX + this.path.getX(), WidgetMover.this.startY + this.path.getY());
                } else {
                    this.setAlive(false);
                    WidgetMover.this.widget.setLocation(WidgetMover.this.destX, WidgetMover.this.destY);
                    WidgetMover.this.onMovementStopped();
                }
            } else {
                this.startTime = gameTime;
            }
        }

        public void startMoving() {
            WidgetMover.this.startX = WidgetMover.this.widget.getLeft();
            WidgetMover.this.startY = WidgetMover.this.widget.getTop();
            this.pathTotal.set(WidgetMover.this.destX - WidgetMover.this.startX, WidgetMover.this.destY - WidgetMover.this.startY);
            this.pathTotalLength = this.pathTotal.length();
            this.pathNorm.normalize(this.pathTotal);
            this.path.set(0.0f, 0.0f);
            this.startTime = -1L;
            this.isSuspended = false;
            this.setAlive(true);
            WidgetMover.this.widget.getHUD().getOperationScheduler().scheduleOperation(this);
        }

        public void setSuspended(boolean suspended) {
            this.isSuspended = suspended;
        }

        public Mover() {
            super(true);
            this.pathTotal = new Vector2f();
            this.pathNorm = new Vector2f();
            this.path = new Vector2f();
            this.setAlive(false);
        }
    }
}

