/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import java.util.HashSet;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.MouseButton;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.listeners.WidgetMouseListener;

public class WidgetZIndexGroup
implements WidgetMouseListener {
    private final HashSet<Widget> widgets = new HashSet();
    private int maxZIndex = 0;
    private int quantum;

    public void setMaxZIndex(int mzi) {
        this.maxZIndex = mzi;
    }

    public int getMaxZIndex() {
        return this.maxZIndex;
    }

    public void setQuantum(int quantum) {
        this.quantum = quantum;
    }

    public int getQuantum() {
        return this.quantum;
    }

    public void onMouseButtonPressed(Widget widget, MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        if (isTopMost && this.widgets.contains(widget)) {
            int zIndex = widget.getZIndex();
            for (Widget w : this.widgets) {
                if (w.getZIndex() <= zIndex || w == widget) continue;
                w.setZIndex(w.getZIndex() - this.quantum);
            }
            widget.setZIndex(this.maxZIndex);
        }
    }

    public void onMouseButtonReleased(Widget widget, MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
    }

    public void onMouseMoved(Widget widget, float x, float y, int buttonsState, long when, boolean isTopMost, boolean hasFocus) {
    }

    public void onMouseStopped(Widget widget, float x, float y, long when, boolean isTopMost, boolean hasFocus) {
    }

    public void onMouseWheelMoved(Widget widget, int delta, boolean isPageMove, float x, float y, long when, boolean isTopMost) {
    }

    public void onMouseEntered(Widget widget, boolean isTopMost, boolean hasFocus) {
    }

    public void onMouseExited(Widget widget, boolean isTopMost, boolean hasFocus) {
    }

    public void onInputStateChanged(Widget widget, DeviceComponent comp, int delta, int state, long when, boolean isTopMost, boolean hasFocus) {
    }

    public void add(Widget widget) {
        this.widgets.add(widget);
        if (widget.getZIndex() > this.maxZIndex) {
            this.maxZIndex = widget.getZIndex();
        }
        widget.addMouseListener(this);
    }

    public boolean remove(Widget widget) {
        if (this.widgets.contains(widget)) {
            widget.removeMouseListener(this);
        }
        return this.widgets.remove(widget);
    }

    public WidgetZIndexGroup(int quantum) {
        this.quantum = quantum;
    }

    public WidgetZIndexGroup() {
        this(1);
    }
}

