/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import java.util.ArrayList;
import org.jagatoo.datatypes.Enableable;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point2f;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.__HUD_PrivilegedAccess;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.AbstractList;
import org.xith3d.ui.hud.base.ListModel;
import org.xith3d.ui.hud.base.TextWidget;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.__HUD_base_PrivilegedAccess;
import org.xith3d.ui.hud.listeners.ListSelectionListener;
import org.xith3d.ui.hud.listeners.WidgetEventsReceiverAdapter;
import org.xith3d.ui.hud.listmodels.TextListModel;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.PopUpable;
import org.xith3d.ui.hud.utils.ScrollMode;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.List;
import org.xith3d.ui.hud.widgets.TextField;
import org.xith3d.ui.text2d.TextAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBox
extends AbstractList
implements TextWidget,
Enableable,
PopUpable {
    private static final boolean DEFAULT_HEAVYWEIGHT = false;
    private final TextField textField;
    private final Button button;
    private final List list;
    private int maxListHeightByItems = -1;
    private final AssemblerEventsReceiver assemblerEventsReceiver = new AssemblerEventsReceiver();
    private final ArrayList<ListSelectionListener> selectionListeners = new ArrayList(1);

    @Override
    protected float getMinWidth() {
        return 50.0f;
    }

    @Override
    protected float getMinHeight() {
        return 10.0f;
    }

    @Override
    public void setModel(ListModel model) {
        if (this.list != null) {
            this.list.setModel(model);
        }
    }

    @Override
    public ListModel getModel() {
        return this.list.getModel();
    }

    @Override
    public boolean setPadding(int paddingBottom, int paddingRight, int paddingTop, int paddingLeft) {
        boolean b1 = this.textField.setPadding(0, paddingRight, 0, paddingLeft);
        boolean b2 = this.list.setPadding(paddingBottom, paddingRight, paddingTop, paddingLeft);
        return b1 || b2;
    }

    @Override
    public final int getPaddingBottom() {
        return this.list.getPaddingBottom();
    }

    @Override
    public final int getPaddingRight() {
        return this.textField.getPaddingRight();
    }

    @Override
    public final int getPaddingTop() {
        return this.list.getPaddingTop();
    }

    @Override
    public final int getPaddingLeft() {
        return this.textField.getPaddingLeft();
    }

    @Override
    public void setHoverBackgroundColor(Colorf color) {
        this.list.setHoverBackgroundColor(color);
    }

    @Override
    public final Colorf getHoverBackgroundColor() {
        return this.list.getHoverBackgroundColor();
    }

    @Override
    public void setSelectionBackgroundColor(Colorf color) {
        this.list.setSelectionBackgroundColor(color);
    }

    @Override
    public final Colorf getSelectionBackgroundColor() {
        return this.list.getSelectionBackgroundColor();
    }

    @Override
    public void setAlignment(TextAlignment alignment) {
        this.textField.setAlignment(alignment);
        this.list.setAlignment(alignment);
    }

    @Override
    public final TextAlignment getAlignment() {
        return this.textField.getAlignment();
    }

    @Override
    public void addSelectionListener(ListSelectionListener l) {
        this.selectionListeners.add(l);
    }

    @Override
    public void removeSelectionListener(ListSelectionListener l) {
        this.selectionListeners.remove(l);
    }

    @Override
    public void setSelectedIndex(int itemIndex) {
        super.setSelectedIndex(itemIndex);
        this.textField.setText(String.valueOf(this.getSelectedItem()));
    }

    @Override
    public void setAddItemSetsSelectedItem(boolean b) {
        this.list.setAddItemSetsSelectedItem(b);
    }

    @Override
    public final boolean addItemSetsSelectedItem() {
        return this.list.addItemSetsSelectedItem();
    }

    @Override
    public Object addItem(int index, Object item) {
        this.list.addItem(index, item);
        if (this.addItemSetsSelectedItem()) {
            this.textField.setText(String.valueOf(item));
        }
        this.setMaxListHeightByItems(this.getMaxListHeightByItems());
        return item;
    }

    public void addItem(int index, String text, HUDFont font, Colorf color) {
        this.list.addItem(index, text, font, color);
        this.setMaxListHeightByItems(this.getMaxListHeightByItems());
    }

    public final void addItem(String text, HUDFont font, Colorf color) {
        this.addItem(this.getItemsCount(), text, font, color);
    }

    public final void addItem(int index, String text, Colorf color) {
        this.addItem(index, text, null, color);
    }

    public final void addItem(String text, Colorf color) {
        this.addItem(this.getItemsCount(), text, null, color);
    }

    public final void addItem(int index, String text) {
        this.addItem(index, text, null, null);
    }

    public final void addItem(String text) {
        this.addItem(this.getItemsCount(), text, null, null);
    }

    @Override
    public String removeItem(int index) {
        String item = (String)super.removeItem(index);
        this.setMaxListHeightByItems(this.getMaxListHeightByItems());
        return item;
    }

    @Override
    public void addItems(java.util.List<?> items) {
        super.addItems(items);
        this.setMaxListHeightByItems(this.getMaxListHeightByItems());
    }

    @Override
    public void addItems(Object[] items) {
        super.addItems(items);
        this.setMaxListHeightByItems(this.getMaxListHeightByItems());
    }

    @Override
    public void clear() {
        super.clear();
        this.textField.setText("");
        this.setMaxListHeightByItems(this.getMaxListHeightByItems());
    }

    @Override
    public void setTopIndex(int topIndex) {
        this.list.setTopIndex(topIndex);
    }

    @Override
    public int getTopIndex() {
        return this.list.getTopIndex();
    }

    @Override
    public final int getBottomIndex() {
        return this.list.getBottomIndex();
    }

    @Override
    public void scrollSelectedItemIntoView() {
        this.list.scrollSelectedItemIntoView();
    }

    public void setListHeightByItems(int numItems) {
        this.list.setHeightByItems(numItems);
    }

    public int getListHeightByItems() {
        return this.list.getHeightByItems();
    }

    public void setMaxListHeightByItems(int maxHeight) {
        this.maxListHeightByItems = maxHeight;
        if (this.maxListHeightByItems > 0 && this.getHUD() != null) {
            this.setListHeightByItems(Math.min(this.getItemsCount(), this.maxListHeightByItems));
        }
    }

    public int getMaxListHeightByItems() {
        return this.maxListHeightByItems;
    }

    @Override
    protected boolean blocksFocusMoveDeviceComponent(DeviceComponent dc) {
        return this.textField.blocksFocusMoveDeviceComponent(dc) || this.list.blocksFocusMoveDeviceComponent(dc);
    }

    @Override
    public void setText(String text) {
        throw new UnsupportedOperationException("You cannot set the Text of a ComboBox.");
    }

    @Override
    public String getText() {
        return this.textField.getText();
    }

    @Override
    public HUDFont getFont() {
        return this.textField.getFont();
    }

    @Override
    public void setFont(HUDFont font) {
        this.textField.setFont(font);
    }

    @Override
    public void setFontColor(Colorf color) {
        this.textField.setFontColor(color);
    }

    @Override
    public Colorf getFontColor() {
        return this.textField.getFontColor();
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
    }

    @Override
    public final boolean isEnabled() {
        return this.textField.isEnabled();
    }

    @Override
    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        float buttonWidth;
        super.onSizeChanged(oldWidth, oldHeight, newWidth, newHeight);
        float f = buttonWidth = this.button != null ? newHeight : 0.0f;
        if (this.textField != null) {
            this.textField.setSize(newWidth - buttonWidth, newHeight);
        }
        if (this.button != null) {
            this.button.setSize(buttonWidth, newHeight);
        }
        this.list.setSize(newWidth, this.list.getHeight());
        if (this.button != null) {
            this.getWidgetAssembler().reposition(this.button, newWidth - buttonWidth, 0.0f);
        }
    }

    @Override
    protected float getPickHeight() {
        return super.getPickHeight();
    }

    @Override
    public void popUp(boolean p) {
        if (p == this.isPoppedUp()) {
            return;
        }
        HUD hud = this.getHUD();
        if (hud == null) {
            return;
        }
        if (p) {
            Point2f listPos = Point2f.fromPool();
            this.getAbsoluteLocationOnHUD_(listPos);
            listPos.addY(this.getHeight());
            __HUD_PrivilegedAccess.addVolatilePopup(hud, this.list, this, listPos.getX(), listPos.getY());
            Point2f.toPool(listPos);
            this.assemblerEventsReceiver.selectionChanged = false;
        } else if (this.list.getHUD() != null) {
            __HUD_PrivilegedAccess.removeVolatilePopup(hud);
        }
    }

    @Override
    public boolean isPoppedUp() {
        return this.list.getHUD() != null;
    }

    @Override
    public void onFocusLost() {
        super.onFocusLost();
    }

    @Override
    public void onMouseExited(boolean isTopMost, boolean hasFocus) {
        super.onMouseExited(isTopMost, hasFocus);
        __HUD_base_PrivilegedAccess.onMouseExited(this.button, isTopMost, hasFocus);
    }

    @Override
    public void onAttachedToHUD(HUD hud) {
        super.onAttachedToHUD(hud);
        this.setMaxListHeightByItems(this.maxListHeightByItems);
    }

    @Override
    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
    }

    @Override
    protected void init() {
        if (this.getSelectedIndex() != -1) {
            this.textField.setText(String.valueOf(this.getSelectedItem()));
        }
        this.getWidgetAssembler().addWidget(this.textField, 0.0f, 0.0f);
        this.getWidgetAssembler().addWidget(this.button, this.textField.getWidth(), 0.0f);
    }

    public ComboBox(boolean isHeavyWeight, float width, float height, ListModel listModel, Description desc) {
        super(isHeavyWeight, width, height, null, null, null, listModel);
        TextField tf = new TextField(this.getWidth() - this.getHeight(), this.getHeight(), "", desc.getTextFieldDescription());
        tf.setAlignment(TextAlignment.CENTER_LEFT);
        tf.setEditable(false);
        this.textField = tf;
        this.button = new Button(this.getHeight(), this.getHeight(), "");
        this.button.setIcon(desc.buttonSymbol);
        this.button.addButtonListener(this.assemblerEventsReceiver);
        this.list = new List(true, this.getWidth(), this.getHeight() * 5.0f, listModel, desc.getListDescription());
        this.list.addSelectionListener(this.assemblerEventsReceiver);
        this.list.addMouseListener(this.assemblerEventsReceiver);
        this.getWidgetAssembler().setKeyEventsDispatched(true);
        this.getWidgetAssembler().setPickDispatched(true);
        this.setMaxListHeightByItems(5);
        this.list.setScrollMode(ScrollMode.AUTO);
    }

    public ComboBox(boolean isHeavyWeight, float width, float height, ListModel listModel) {
        this(isHeavyWeight, width, height, listModel, HUD.getTheme().getComboBoxDescription());
    }

    public ComboBox(float width, float height, ListModel listModel, Description desc) {
        this(false, width, height, listModel, desc);
    }

    public ComboBox(float width, float height, ListModel listModel) {
        this(false, width, height, listModel);
    }

    public static final ComboBox newTextCombo(boolean isHeavyWeight, float width, float height, Description desc) {
        return new ComboBox(isHeavyWeight, width, height, new TextListModel(), desc);
    }

    public static final ComboBox newTextCombo(boolean isHeavyWeight, float width, float height) {
        return new ComboBox(isHeavyWeight, width, height, new TextListModel());
    }

    public static final ComboBox newTextCombo(float width, float height, Description desc) {
        return new ComboBox(width, height, new TextListModel(), desc);
    }

    public static final ComboBox newTextCombo(float width, float height) {
        return new ComboBox(width, height, new TextListModel());
    }

    private class AssemblerEventsReceiver
    extends WidgetEventsReceiverAdapter {
        public boolean selectionChanged = false;

        private AssemblerEventsReceiver() {
        }

        public void onButtonClicked(AbstractButton button, Object userObject) {
            if (button == ComboBox.this.button && ComboBox.this.isEnabled()) {
                ComboBox.this.popUp(!ComboBox.this.isPoppedUp());
            }
        }

        public void onListSelectionChanged(AbstractList list, Object oldSelectedItem, Object newSelectedItem, int oldSelectedIndex, int newSelectedIndex) {
            if (ComboBox.this.textField != null) {
                ComboBox.this.textField.setText(newSelectedItem != null ? String.valueOf(newSelectedItem) : "");
            }
            this.selectionChanged = true;
            for (int i = 0; i < ComboBox.this.selectionListeners.size(); ++i) {
                ((ListSelectionListener)ComboBox.this.selectionListeners.get(i)).onListSelectionChanged(ComboBox.this, oldSelectedItem, newSelectedItem, oldSelectedIndex, newSelectedIndex);
            }
        }

        public void onMouseButtonReleased(Widget widget, MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
            if (this.selectionChanged) {
                ComboBox.this.popUp(false);
            }
        }

        public void onListItemClicked(AbstractList list, Object item, int itemIndex) {
            for (int i = 0; i < ComboBox.this.selectionListeners.size(); ++i) {
                ((ListSelectionListener)ComboBox.this.selectionListeners.get(i)).onListItemClicked(ComboBox.this, item, itemIndex);
            }
        }
    }

    public static class Description
    extends Widget.DescriptionBase {
        private TextField.Description textFieldDesc;
        private List.Description listDesc;
        private Texture2D buttonSymbol;

        public void setTextFieldDescription(TextField.Description textFieldDesc) {
            this.textFieldDesc = textFieldDesc;
        }

        public TextField.Description getTextFieldDescription() {
            return this.textFieldDesc;
        }

        public void setListDescription(List.Description listDesc) {
            this.listDesc = listDesc;
        }

        public List.Description getListDescription() {
            return this.listDesc;
        }

        public Texture2D getButtonSymbol() {
            return this.buttonSymbol;
        }

        public void setButtonSymbol(Texture2D texture) {
            this.buttonSymbol = texture;
        }

        public void setButtonSymbol(String texture) {
            this.setButtonSymbol(HUDTextureUtils.getTexture(texture, true));
        }

        public void set(Description template) {
            this.textFieldDesc = template.textFieldDesc.clone();
            this.listDesc = template.listDesc.clone();
            this.buttonSymbol = template.buttonSymbol;
        }

        public Description clone() {
            return new Description(this);
        }

        private Description(Description template) {
            this.set(template);
        }

        public Description(TextField.Description textFieldDesc, List.Description listDesc, Texture2D buttonSymbol) {
            this.textFieldDesc = textFieldDesc;
            this.listDesc = listDesc;
            this.buttonSymbol = buttonSymbol;
        }

        public Description(TextField.Description textFieldDesc, List.Description listDesc, String buttonSymbol) {
            this(textFieldDesc, listDesc, HUDTextureUtils.getTexture(buttonSymbol, true));
        }
    }
}

