/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.utils.DrawUtils;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.TileMode;

public class Image
extends Widget {
    private Colorf color;
    private Texture2D texture;
    private TileMode tileMode = TileMode.STRETCH;

    public void setTransparency(float transparency, boolean childrenToo) {
        super.setTransparency(transparency, childrenToo);
        if (this.color != null) {
            this.color.setAlpha(transparency);
            this.setTextureDirty();
        }
    }

    public void setTexture(Texture2D texture) {
        if (texture == this.texture) {
            return;
        }
        this.texture = texture;
        this.setTextureDirty();
    }

    public final void setTexture(String texture) {
        this.setTexture(HUDTextureUtils.getTexture(texture, true));
    }

    public final Texture2D getTexture() {
        return this.texture;
    }

    public void setTileMode(TileMode mode) {
        if (mode == this.tileMode) {
            return;
        }
        this.tileMode = mode;
        this.setTextureDirty();
    }

    public final TileMode getTileMode() {
        return this.tileMode;
    }

    public void setColor(Colorf color) {
        if (color == this.color) {
            return;
        }
        this.color = color;
        this.setTextureDirty();
    }

    public final Colorf getColor() {
        if (this.color == null) {
            return null;
        }
        return this.color.getReadOnly();
    }

    public String toString() {
        if (this.getColor() != null && this.getTexture() != null) {
            return "Image ( " + this.getColor() + ", \"" + this.getTexture().getResourceName() + "\" )";
        }
        if (this.getColor() != null) {
            return "Image ( " + this.getColor() + " )";
        }
        if (this.getTexture() != null) {
            return "Image ( \"" + this.getTexture().getResourceName() + "\" )";
        }
        return super.toString();
    }

    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        if (this.isHeavyWeight()) {
            DrawUtils.clearImage(this.getColor(), this.getTexture(), this.getTileMode(), texCanvas, offsetX, offsetY, width, height);
        } else {
            DrawUtils.drawImage(this.getColor(), this.getTexture(), this.getTileMode(), texCanvas, offsetX, offsetY, width, height);
        }
    }

    protected void init() {
    }

    public Image(boolean isHeavyWeight, float width, float height, Colorf color, Texture2D texture, TileMode tileMode) {
        super(isHeavyWeight, false, width, height);
        this.color = color;
        this.texture = texture;
        this.tileMode = tileMode != null ? tileMode : TileMode.STRETCH;
        this.setFocussable(false);
    }

    public Image(boolean isHeavyWeight, float width, float height, Colorf color) {
        this(isHeavyWeight, width, height, color, null, null);
    }

    public Image(boolean isHeavyWeight, float width, float height, Texture2D texture, TileMode tileMode) {
        this(isHeavyWeight, width, height, null, texture, tileMode);
    }

    public Image(boolean isHeavyWeight, float width, float height, Texture2D texture) {
        this(isHeavyWeight, width, height, null, texture, null);
    }

    public Image(boolean isHeavyWeight, float width, float height, String texture) {
        this(isHeavyWeight, width, height, null, HUDTextureUtils.getTexture(texture, true), null);
    }

    public Image(float width, float height, Colorf color, Texture2D texture) {
        this(false, width, height, color, texture, null);
    }

    public Image(float width, float height, Colorf color) {
        this(false, width, height, color);
    }

    public Image(float width, float height, Texture2D texture, TileMode tileMode) {
        this(false, width, height, texture, tileMode);
    }

    public Image(float width, float height, Texture2D texture) {
        this(false, width, height, texture);
    }

    public Image(float width, float height, String texture) {
        this(false, width, height, texture);
    }
}

