/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import java.util.ArrayList;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.DigitalDeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Dim2i;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector2f;
import org.openmali.vecmath2.Vector2i;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractList;
import org.xith3d.ui.hud.base.Border;
import org.xith3d.ui.hud.base.ListModel;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.__HUD_base_PrivilegedAccess;
import org.xith3d.ui.hud.listeners.ListSelectionListener;
import org.xith3d.ui.hud.listmodels.TextListModel;
import org.xith3d.ui.hud.utils.DrawUtils;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.ScrollHandler;
import org.xith3d.ui.hud.utils.ScrollMode;
import org.xith3d.ui.hud.utils.TileMode;
import org.xith3d.ui.hud.widgets.Scrollbar;
import org.xith3d.ui.text2d.TextAlignment;

public class List
extends AbstractList {
    protected final Vector2f childrenOffset_HUD = new Vector2f(0.0f, 0.0f);
    protected final Vector2i childrenOffset_PX = new Vector2i(0, 0);
    private int paddingBottom = 0;
    private int paddingRight = 3;
    private int paddingTop = 0;
    private int paddingLeft = 3;
    private int heightByItems = -1;
    private Colorf fontColor;
    private Colorf selectionFontColor = null;
    private HUDFont font;
    private Colorf hoverBackgroundColor = null;
    private Colorf selectionBackgroundColor = null;
    private int currentHoveredItem = -1;
    private int lastDrawnHoveredItem = -1;
    private TextAlignment alignment = TextAlignment.CENTER_LEFT;
    private ScrollHandler scrollHandler;
    private boolean isFixedToBottom = false;
    private boolean addItemSetsSelected = false;
    private final ArrayList<ListSelectionListener> selectionListeners = new ArrayList();
    private DigitalDeviceComponent[] upComponents = new DigitalDeviceComponent[]{Keys.UP};
    private DigitalDeviceComponent[] downComponents = new DigitalDeviceComponent[]{Keys.DOWN};

    protected void afterModelSetWidthItems(ListModel model) {
        super.afterModelSetWidthItems(model);
        this.scrollHandler.setLineHeight((int)model.getItemHeight(0));
    }

    public boolean setPadding(int paddingBottom, int paddingRight, int paddingTop, int paddingLeft) {
        if (this.paddingBottom == paddingBottom && this.paddingRight == paddingRight && this.paddingTop == paddingTop && this.paddingLeft == paddingLeft) {
            return false;
        }
        this.paddingBottom = paddingBottom;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingLeft = paddingLeft;
        this.updateSizeFactors();
        this.setTextureDirty();
        return true;
    }

    public final int getPaddingBottom() {
        return this.paddingBottom;
    }

    public final int getPaddingRight() {
        return this.paddingRight;
    }

    public final int getPaddingTop() {
        return this.paddingTop;
    }

    public final int getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setFontColor(Colorf color) {
        this.fontColor = color;
        this.setTextureDirty();
    }

    public final Colorf getFontColor() {
        return this.fontColor;
    }

    public void setFont(HUDFont font) {
        this.font = font;
        this.setTextureDirty();
    }

    public final HUDFont getFont() {
        return this.font;
    }

    public void setSelectionFontColor(Colorf color) {
        this.selectionFontColor = color;
        this.setTextureDirty();
    }

    public final Colorf getSelectionFontColor() {
        return this.selectionFontColor;
    }

    public Object addItem(int index, Object item, HUDFont font, Colorf color) {
        Object result = super.addItem(index, item);
        ListModel model = this.getModel();
        if (model instanceof TextListModel) {
            ((TextListModel)model).setItemFont(index, font);
            ((TextListModel)model).setItemColor(index, color);
        }
        return result;
    }

    public final Object addItem(Object item, HUDFont font, Colorf color) {
        return this.addItem(this.getItemsCount(), item, font, color);
    }

    public final Object addItem(int index, Object item, Colorf color) {
        return this.addItem(index, item, null, color);
    }

    public final Object addItem(Object item, Colorf color) {
        return this.addItem(this.getItemsCount(), item, null, color);
    }

    public final Object addItem(int index, Object item) {
        return this.addItem(index, item, null, null);
    }

    public void setHoverBackgroundColor(Colorf color) {
        this.hoverBackgroundColor = color;
    }

    public final Colorf getHoverBackgroundColor() {
        return this.hoverBackgroundColor;
    }

    public void setSelectionBackgroundColor(Colorf color) {
        this.selectionBackgroundColor = color;
    }

    public final Colorf getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setAlignment(TextAlignment alignment) {
        this.alignment = alignment;
    }

    public final TextAlignment getAlignment() {
        return this.alignment;
    }

    public void addSelectionListener(ListSelectionListener l) {
        this.selectionListeners.add(l);
    }

    public void removeSelectionListener(ListSelectionListener l) {
        this.selectionListeners.remove(l);
    }

    protected void notifyOnSelectionChanged(Object oldSelObj, Object newSelObj, int oldSelIdx, int newSelIdx) {
        for (int i = 0; i < this.selectionListeners.size(); ++i) {
            this.selectionListeners.get(i).onListSelectionChanged(this, oldSelObj, newSelObj, oldSelIdx, newSelIdx);
        }
    }

    protected void notifyOnItemClicked(Object item, int index) {
        for (int i = 0; i < this.selectionListeners.size(); ++i) {
            this.selectionListeners.get(i).onListItemClicked(this, item, index);
        }
    }

    public void setAddItemSetsSelectedItem(boolean b) {
        this.addItemSetsSelected = b;
    }

    public final boolean addItemSetsSelectedItem() {
        return this.addItemSetsSelected;
    }

    public void scrollSelectedItemIntoView() {
        int selIndex = this.getSelectedIndex();
        if (selIndex < 0 || selIndex >= this.getItemsCount()) {
            return;
        }
        ListModel model = this.getModel();
        float selTop = 0.0f;
        if (model.getUsesFixedHeight()) {
            selTop = (float)selIndex * model.getItemHeight(0);
        } else {
            for (int i = 0; i < selIndex; ++i) {
                selTop += model.getItemHeight(i);
            }
        }
        if (selTop + this.childrenOffset_HUD.getY() < 0.0f) {
            this.setChildrenOffset(false, 0.0f, true, -selTop, true);
        } else {
            float selBottom = selTop + (model.getUsesFixedHeight() ? model.getItemHeight(0) : model.getItemHeight(selIndex));
            float contentHeight = this.getContentHeight();
            if (selBottom + this.childrenOffset_HUD.getY() > contentHeight) {
                this.setChildrenOffset(false, 0.0f, true, contentHeight - selBottom, true);
            }
        }
    }

    protected void afterItemAddedToEnd() {
        super.afterItemAddedToEnd();
        if (this.isFixedToBottom()) {
            this.scrollToBottom();
        }
    }

    protected void afterFirstItemAdded() {
        super.afterFirstItemAdded();
        this.scrollHandler.setLineHeight((int)this.getModel().getItemHeight(0));
    }

    public void setTopIndex(int topIndex) {
        if (topIndex < 0 || topIndex >= this.getItemsCount()) {
            throw new IllegalArgumentException("topIndex out of range");
        }
        ListModel model = this.getModel();
        float topTop = 0.0f;
        if (model.getUsesFixedHeight()) {
            topTop = (float)topIndex * model.getItemHeight(0);
        } else {
            for (int i = 0; i < topIndex; ++i) {
                topTop += model.getItemHeight(i);
            }
        }
        int n = this.getItemsCount();
        float bottomBottom = topTop;
        if (model.getUsesFixedHeight()) {
            bottomBottom += (float)(n - topIndex) * model.getItemHeight(0);
        } else {
            for (int i = topIndex; i < n; ++i) {
                bottomBottom += model.getItemHeight(i);
            }
        }
        topTop = Math.max(0.0f, Math.min(topTop, bottomBottom - this.getContentHeight()));
        this.setChildrenOffset(false, 0.0f, true, -topTop, true);
    }

    public int getTopIndex() {
        if (this.getItemsCount() == 0) {
            return -1;
        }
        ListModel model = this.getModel();
        if (model.getUsesFixedHeight()) {
            return (int)Math.ceil(-this.childrenOffset_HUD.getY() / model.getItemHeight(0));
        }
        int i = 0;
        for (float tmp = -this.childrenOffset_HUD.getY(); tmp > 0.0f; tmp -= model.getItemHeight(i++)) {
        }
        return i;
    }

    public final int getBottomIndex() {
        if (this.getItemsCount() == 0) {
            return -1;
        }
        ListModel model = this.getModel();
        if (model.getUsesFixedHeight()) {
            return (int)Math.ceil((-this.childrenOffset_HUD.getY() + this.getContentHeight()) / model.getItemHeight(0)) - 1;
        }
        int i = 0;
        for (float tmp = -this.childrenOffset_HUD.getY() + this.getContentHeight(); tmp > 0.0f; tmp -= model.getItemHeight(i++)) {
        }
        return i - 1;
    }

    public void setHeightByItems(int numItems) {
        if (this.getHUD() == null) {
            this.heightByItems = numItems;
        } else {
            ListModel model;
            float height2 = 0.0f;
            int paddingAndBorder = this.getPaddingTop() + this.getPaddingBottom();
            if (this.getBorder() != null) {
                paddingAndBorder += this.getBorder().getTopHeight() + this.getBorder().getBottomHeight();
            }
            if (paddingAndBorder > 0) {
                Dim2f buffer = Dim2f.fromPool();
                this.getSizePixels2HUD_(0, paddingAndBorder, buffer);
                height2 += buffer.getHeight();
                Dim2f.toPool(buffer);
            }
            if ((model = this.getModel()).getUsesFixedHeight()) {
                height2 += (float)numItems * Math.max(0.0f, model.getItemHeight(0));
            } else {
                int i0;
                for (int i = i0 = this.getTopIndex(); i < i0 + numItems; ++i) {
                    height2 += Math.max(0.0f, model.getItemHeight(i));
                }
            }
            this.setSize(this.getWidth(), height2);
        }
    }

    public int getHeightByItems() {
        if (this.getItemsCount() == 0) {
            return -1;
        }
        ListModel model = this.getModel();
        if (model.getUsesFixedHeight()) {
            return (int)Math.floor(this.getHeight() / model.getItemHeight(0));
        }
        int i = this.getTopIndex();
        int c = 0;
        float height2 = this.getContentHeight();
        while (height2 > 0.0f) {
            height2 -= model.getItemHeight(i++);
            ++c;
        }
        return c;
    }

    public void setScrollMode(ScrollMode mode) {
        this.scrollHandler.setScrollMode(mode);
        this.setTextureDirty();
    }

    public ScrollMode getScrollMode() {
        return this.scrollHandler.getScrollMode();
    }

    public boolean isScrolledToBottom() {
        return this.getBottomIndex() == this.getItemsCount() - 1;
    }

    public void scrollToBottom() {
        ListModel model = this.getModel();
        int n = model.getItemsCount();
        if (n == 0) {
            return;
        }
        float bottomBottom = 0.0f;
        if (model.getUsesFixedHeight()) {
            bottomBottom = (float)n * model.getItemHeight(0);
        } else {
            for (int i = 0; i < n; ++i) {
                bottomBottom += model.getItemHeight(i);
            }
        }
        this.setChildrenOffset(false, 0.0f, true, -Math.max(0.0f, bottomBottom -= this.getContentHeight()), true);
    }

    public void setFixedToBottom(boolean fixed) {
        this.isFixedToBottom = fixed;
    }

    public boolean isFixedToBottom() {
        return this.isFixedToBottom;
    }

    public float getMinWidthThatFitsItems() {
        float minWidth = 0.0f;
        ListModel model = this.getModel();
        int n = model.getItemsCount();
        for (int i = 0; i < n; ++i) {
            float minItemWidth = model.getMinItemWidth(i);
            if (!(minItemWidth > minWidth)) continue;
            minWidth = minItemWidth;
        }
        Dim2f buffer = Dim2f.fromPool();
        this.getSizePixels2HUD_(this.getPaddingLeft() + this.getPaddingRight(), 0, buffer);
        minWidth += buffer.getWidth();
        if (this.getBorder() != null) {
            this.getSizePixels2HUD_(this.getBorder().getLeftWidth() + this.getBorder().getRightWidth(), 0, buffer);
            minWidth += buffer.getWidth();
        }
        Dim2f.toPool(buffer);
        return minWidth;
    }

    protected boolean blocksFocusMoveDeviceComponent(DeviceComponent dc) {
        int i;
        if (this.upComponents != null) {
            for (i = 0; i < this.upComponents.length; ++i) {
                if (this.upComponents[i] != dc) continue;
                return true;
            }
        }
        if (this.downComponents != null) {
            for (i = 0; i < this.downComponents.length; ++i) {
                if (this.downComponents[i] != dc) continue;
                return true;
            }
        }
        return false;
    }

    protected void onKeyPressed(Key key, int modifierMask, long when) {
        int i;
        super.onKeyPressed(key, modifierMask, when);
        for (i = 0; i < this.upComponents.length; ++i) {
            if (key != this.upComponents[i]) continue;
            this.selectPreviousItem();
            this.scrollSelectedItemIntoView();
            return;
        }
        for (i = 0; i < this.downComponents.length; ++i) {
            if (key != this.downComponents[i]) continue;
            this.selectNextItem();
            this.scrollSelectedItemIntoView();
            return;
        }
    }

    protected void onMouseExited(boolean isTopMost, boolean hasFocus) {
        super.onMouseExited(isTopMost, hasFocus);
        this.currentHoveredItem = -1;
        if (this.currentHoveredItem != this.lastDrawnHoveredItem) {
            this.getModel().markListDirty();
        }
    }

    protected void onMouseMoved(float x, float y, int buttonsState, long when, boolean isTopMost, boolean hasFocus) {
        super.onMouseMoved(x, y, buttonsState, when, isTopMost, hasFocus);
        if (isTopMost) {
            float contentWidth = this.getContentWidth();
            float contentHeight = this.getContentHeight();
            if (x >= 0.0f && y >= 0.0f && x < contentWidth && y < contentHeight) {
                int i;
                ListModel model = this.getModel();
                boolean fixed = model.getUsesFixedHeight();
                float itemHeight = model.getItemHeight(0);
                int n = this.getItemsCount();
                float itemTop = this.childrenOffset_HUD.getY() + (float)this.getPaddingTop();
                float itemBottom = itemTop + itemHeight;
                for (i = 0; itemBottom < y && i < n; itemBottom += fixed ? itemHeight : model.getItemHeight(i), ++i) {
                    itemTop = itemBottom;
                }
                this.currentHoveredItem = i < n ? i : -1;
                if (this.currentHoveredItem != this.lastDrawnHoveredItem && (this.getHoverBackgroundColor() != null || model.hoverNeedsRedraw())) {
                    model.markListDirty();
                }
            }
        }
    }

    protected void onMouseButtonPressed(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        super.onMouseButtonPressed(button, x, y, when, lastWhen, isTopMost, hasFocus);
        if (isTopMost) {
            Dim2f siz = Dim2f.fromPool();
            float mouseX = x;
            float mouseY = y;
            float contentLeft = 0.0f;
            if (this.getBorder() != null) {
                this.getSizePixels2HUD_(this.getBorder().getLeftWidth(), this.getBorder().getTopHeight(), siz);
                this.getSizePixels2HUD_(this.getContentLeftPX(), 0, siz);
                contentLeft = siz.getWidth();
            }
            Dim2f.toPool(siz);
            float contentWidth = this.getContentWidth();
            float contentHeight = this.getContentHeight();
            if (mouseX >= 0.0f && mouseY >= 0.0f && mouseX < contentWidth && mouseY < contentHeight) {
                int i;
                ListModel model = this.getModel();
                boolean fixed = model.getUsesFixedHeight();
                float itemHeight = model.getItemHeight(0);
                int n = this.getItemsCount();
                float itemTop = this.childrenOffset_HUD.getY() + (float)this.getPaddingTop();
                float itemBottom = itemTop + itemHeight;
                for (i = 0; itemBottom < mouseY && i < n; itemBottom += fixed ? itemHeight : model.getItemHeight(i), ++i) {
                    itemTop = itemBottom;
                }
                if (i < n) {
                    int oldSelIdx = this.getSelectedIndex();
                    Object oldSelObj = this.getSelectedItem();
                    if (model.checkOnMouseButtonPressed(i, contentLeft, contentWidth, itemTop, itemBottom, x, y)) {
                        this.setSelectedIndex(i);
                        Object newSelObj = this.getSelectedItem();
                        this.notifyOnSelectionChanged(oldSelObj, newSelObj, oldSelIdx, i);
                        this.notifyOnItemClicked(newSelObj, i);
                    } else {
                        this.notifyOnItemClicked(this.getItem(i), i);
                    }
                }
            }
        }
    }

    protected void updateSizesAndMarkDirty() {
        super.updateSizesAndMarkDirty();
        if (this.getHUD() != null) {
            ListModel model = this.getModel();
            float maxRight = 0.0f;
            float maxBottom = 0.0f;
            float firstHeight = model.getItemHeight(0);
            int n = this.getItemsCount();
            for (int i = 0; i < n; ++i) {
                if (model.getUsesFixedHeight()) {
                    maxBottom += firstHeight;
                    continue;
                }
                maxBottom += model.getItemHeight(i);
            }
            this.scrollHandler.setBounds(maxRight, maxBottom);
            if (model.getItemsCount() > 0) {
                this.scrollHandler.setLineHeight((int)model.getItemHeight(0));
            }
        }
        this.setTextureDirty();
    }

    protected void onAttachedToHUD(HUD hud) {
        super.onAttachedToHUD(hud);
        if (this.heightByItems >= 0) {
            this.setHeightByItems(this.heightByItems);
            this.heightByItems = -1;
        }
    }

    protected void setContentClipRect(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        texCanvas.setClip(offsetX - this.getPaddingLeft(), offsetY - this.getPaddingTop(), width + this.getPaddingLeft() + this.getPaddingRight(), height + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected boolean drawHoveredItemBackground(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        Colorf color = this.getHoverBackgroundColor();
        if (color == null) {
            return false;
        }
        if (color.hasAlpha()) {
            DrawUtils.drawImage(color, null, null, texCanvas, offsetX, offsetY, width, height);
        } else {
            DrawUtils.clearImage(color, null, null, texCanvas, offsetX, offsetY, width, height);
        }
        return true;
    }

    protected boolean drawSelectedItemBackground(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        Colorf color = this.getSelectionBackgroundColor();
        if (color == null) {
            return false;
        }
        if (color.hasAlpha()) {
            DrawUtils.drawImage(color, null, null, texCanvas, offsetX, offsetY, width, height);
        } else {
            DrawUtils.clearImage(color, null, null, texCanvas, offsetX, offsetY, width, height);
        }
        return true;
    }

    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        ListModel model = this.getModel();
        float offsetY_HUD = this.childrenOffset_HUD.getY();
        float contentHeight = this.getContentHeight();
        offsetX -= this.getPaddingLeft();
        offsetY += this.childrenOffset_PX.getY();
        float contentWidth = this.getContentWidth();
        int contentWidthPX = this.getContentWidthPX();
        int itemBGWidth = contentWidthPX + this.getPaddingLeft() + this.getPaddingRight();
        int i0 = 0;
        if (model.getUsesFixedHeight()) {
            float itemHeight = model.getItemHeight(0);
            Dim2i buffer = Dim2i.fromPool();
            this.getSizeHUD2Pixels_(0.0f, itemHeight, buffer);
            int itemHeight_PX = buffer.getHeight();
            Dim2i.toPool(buffer);
            i0 = (int)Math.floor(-this.childrenOffset_HUD.getY() / itemHeight);
            offsetY_HUD += (float)i0 * itemHeight;
            offsetY += i0 * itemHeight_PX;
        }
        int n = model.getItemsCount();
        for (int i = i0; i < n; ++i) {
            Widget w = this.getWidget(contentWidth, i);
            if (offsetY_HUD >= contentHeight) break;
            int itemHeightPX = __HUD_base_PrivilegedAccess.getHeightPX(w);
            if (offsetY_HUD + w.getHeight() > 0.0f) {
                boolean bg = true;
                if (bg && i == this.currentHoveredItem) {
                    boolean bl = bg = !this.drawHoveredItemBackground(texCanvas, offsetX, offsetY, itemBGWidth, itemHeightPX);
                }
                if (bg && model.isSelected(i)) {
                    boolean bl = bg = !this.drawSelectedItemBackground(texCanvas, offsetX, offsetY, itemBGWidth, itemHeightPX);
                }
                if (i == this.currentHoveredItem) {
                    __HUD_base_PrivilegedAccess.onMouseEntered(w, true, this.hasFocus(true));
                }
                w.drawAndUpdateWidget(texCanvas, offsetX + this.getPaddingLeft(), offsetY, contentWidthPX, itemHeightPX, false);
                if (i == this.currentHoveredItem) {
                    __HUD_base_PrivilegedAccess.onMouseExited(w, true, this.hasFocus(true));
                }
            }
            offsetY += itemHeightPX;
            offsetY_HUD += w.getHeight();
        }
        this.lastDrawnHoveredItem = this.currentHoveredItem;
    }

    private void setChildrenOffset(boolean changeX, float offsetX, boolean changeY, float offsetY, boolean updateScrollbars) {
        if (this.getHUD() == null) {
            return;
        }
        Dim2i buffer2 = Dim2i.fromPool();
        this.getSizeHUD2Pixels_(offsetX, offsetY, buffer2);
        if (changeX) {
            this.childrenOffset_PX.setX(buffer2.getWidth());
            this.childrenOffset_HUD.setX(offsetX);
        }
        if (changeY) {
            this.childrenOffset_PX.setY(buffer2.getHeight());
            this.childrenOffset_HUD.setY(offsetY);
        }
        Dim2i.toPool(buffer2);
        this.setTextureDirty();
        if (updateScrollbars) {
            if (changeX) {
                this.scrollHandler.setScrollHValue(-((int)offsetX));
            }
            if (changeY) {
                this.scrollHandler.setScrollVValue(-((int)offsetY));
            }
        }
    }

    private void initScrollHandler() {
        this.scrollHandler = new ScrollHandler(this, this.getWidgetAssembler(), true, true){

            public void onScrolled(Scrollbar.Direction direction, int newValue) {
                if (direction == Scrollbar.Direction.VERTICAL) {
                    List.this.setChildrenOffset(false, 0.0f, true, -newValue, false);
                } else {
                    List.this.setChildrenOffset(true, -newValue, false, 0.0f, false);
                }
            }
        };
    }

    protected void init() {
    }

    public List(boolean isHeavyWeight, float width, float height, ListModel model, Description listDesc) {
        super(isHeavyWeight, width, height, listDesc.getBackgroundColor(), listDesc.getBackgroundTexture(), TileMode.TILE_BOTH, model);
        this.initScrollHandler();
        this.setBorder(listDesc.getBorderDescription());
        this.setPadding(listDesc.getPaddingBottom(), listDesc.getBorderDescription().getRightWidth(), listDesc.getPaddingTop(), listDesc.getBorderDescription().getLeftWidth());
        this.setFontColor(listDesc.getFontColor());
        this.setSelectionFontColor(listDesc.getSelectionFontColor());
        this.setFont(listDesc.getFont());
        this.setHoverBackgroundColor(listDesc.getHoverBackgroundColor());
        this.setSelectionBackgroundColor(listDesc.getSelectionBackgroundColor());
    }

    public List(boolean isHeavyWeight, float width, float height, ListModel model) {
        this(isHeavyWeight, width, height, model, HUD.getTheme().getListDescription());
    }

    public List(float width, float height, ListModel model, Description listDesc) {
        this(false, width, height, model, listDesc);
    }

    public List(float width, float height, ListModel model) {
        this(false, width, height, model);
    }

    public static final List newTextList(boolean isHeavyWeight, float width, float height, Description listDesc) {
        return new List(isHeavyWeight, width, height, new TextListModel(), listDesc);
    }

    public static final List newTextList(float width, float height, Description listDesc) {
        return new List(width, height, new TextListModel(), listDesc);
    }

    public static final List newTextList(boolean isHeavyWeight, float width, float height) {
        return new List(isHeavyWeight, width, height, new TextListModel());
    }

    public static final List newTextList(float width, float height) {
        return new List(width, height, new TextListModel());
    }

    public static class Description
    extends Widget.DescriptionBase {
        private Colorf backgroundColor;
        private Texture2D backgroundTexture;
        private Border.Description borderDesc;
        private int paddingBottom;
        private int paddingRight;
        private int paddingTop;
        private int paddingLeft;
        private Colorf hoverBackgroundColor;
        private Colorf hoverFontColor;
        private Colorf selectionBackgroundColor;
        private Colorf selectionFontColor;

        public void setBorderDescription(Border.Description borderDesc) {
            this.borderDesc = borderDesc;
        }

        public Border.Description getBorderDescription() {
            return this.borderDesc;
        }

        public void setPadding(int bottom, int right, int top, int left) {
            this.paddingBottom = bottom;
            this.paddingRight = right;
            this.paddingTop = top;
            this.paddingLeft = left;
        }

        public void setPadding(int padding) {
            this.setPadding(padding, padding, padding, padding);
        }

        public int getPaddingBottom() {
            return this.paddingBottom;
        }

        public int getPaddingRight() {
            return this.paddingRight;
        }

        public int getPaddingTop() {
            return this.paddingTop;
        }

        public int getPaddingLeft() {
            return this.paddingLeft;
        }

        public void setBackgroundTexture(Texture2D texture) {
            this.backgroundTexture = texture;
        }

        public void setBackgroundTexture(String texture) {
            this.backgroundTexture = HUDTextureUtils.getTexture(texture, true);
        }

        public Texture2D getBackgroundTexture() {
            return this.backgroundTexture;
        }

        public void setBackgroundColor(Colorf color) {
            this.backgroundColor = color;
        }

        public Colorf getBackgroundColor() {
            return this.backgroundColor;
        }

        public Colorf getFontColor() {
            return HUD.getTheme().getLabelDescription().getFontColor(false);
        }

        public HUDFont getFont() {
            return HUD.getTheme().getLabelDescription().getFont(false);
        }

        public void setHoverBackgroundColor(Colorf color) {
            this.hoverBackgroundColor = color;
        }

        public Colorf getHoverBackgroundColor() {
            return this.hoverBackgroundColor;
        }

        public void setHoverFontColor(Colorf color) {
            this.hoverFontColor = color;
        }

        public Colorf getHoverFontColor() {
            return this.hoverFontColor;
        }

        public void setSelectionBackgroundColor(Colorf color) {
            this.selectionBackgroundColor = color;
        }

        public Colorf getSelectionBackgroundColor() {
            return this.selectionBackgroundColor;
        }

        public void setSelectionFontColor(Colorf color) {
            this.selectionFontColor = color;
        }

        public Colorf getSelectionFontColor() {
            return this.selectionFontColor;
        }

        public void set(Description template) {
            this.backgroundTexture = template.backgroundTexture;
            this.backgroundColor = template.backgroundColor;
            this.borderDesc = template.borderDesc;
            this.paddingBottom = template.paddingBottom;
            this.paddingRight = template.paddingRight;
            this.paddingTop = template.paddingTop;
            this.paddingLeft = template.paddingLeft;
            this.hoverBackgroundColor = template.hoverBackgroundColor;
            this.hoverFontColor = template.hoverFontColor;
            this.selectionBackgroundColor = template.selectionBackgroundColor;
            this.selectionFontColor = template.selectionFontColor;
        }

        public Description clone() {
            return new Description(this);
        }

        private Description(Description template) {
            this.set(template);
        }

        public Description(int paddingBottom, int paddingRight, int paddingTop, int paddingLeft, Border.Description borderDesc, Colorf backgroundColor, Texture2D backgroundTexture, Colorf hoveredBackgroundColor, Colorf hoveredFontColor, Colorf selectedBackgroundColor, Colorf selectedFontColor) {
            this.paddingBottom = paddingBottom;
            this.paddingRight = paddingRight;
            this.paddingTop = paddingTop;
            this.paddingLeft = paddingLeft;
            this.backgroundColor = backgroundColor;
            this.backgroundTexture = backgroundTexture;
            this.borderDesc = borderDesc;
            this.hoverBackgroundColor = hoveredBackgroundColor;
            this.hoverFontColor = hoveredFontColor;
            this.selectionBackgroundColor = selectedBackgroundColor;
            this.selectionFontColor = selectedFontColor;
        }

        public Description(int paddingBottom, int paddingRight, int paddingTop, int paddingLeft, Border.Description borderDesc, Colorf backgroundColor, String backgroundTexture, Colorf hoveredBackgroundColor, Colorf hoveredFontColor, Colorf selectedBackgroundColor, Colorf selectedFontColor) {
            this(paddingBottom, paddingRight, paddingTop, paddingLeft, borderDesc, backgroundColor, HUDTextureUtils.getTexture(backgroundTexture, true), hoveredBackgroundColor, hoveredFontColor, selectedBackgroundColor, selectedFontColor);
        }
    }
}

