/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.BackgroundSettableWidget;
import org.xith3d.ui.hud.base.Border;
import org.xith3d.ui.hud.borders.BorderFactory;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.TileMode;
import org.xith3d.ui.hud.widgets.Label;

public class ProgressBar
extends BackgroundSettableWidget {
    protected static final boolean DEFAULT_HEAVYWEIGHT = false;
    private int leftWidth;
    private int rightWidth;
    private int topHeight;
    private int bottomHeight;
    private Texture2D barTex;
    private Label label;
    private int minValue;
    private int maxValue;
    private int value;

    public void setFont(HUDFont font) {
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    public final HUDFont getFont() {
        if (this.label == null) {
            return null;
        }
        return this.label.getFont();
    }

    public void setFontColor(Colorf color) {
        if (this.label != null) {
            this.label.setFontColor(color);
        }
    }

    public final Colorf getFontColor() {
        if (this.label == null) {
            return null;
        }
        return this.label.getFontColor();
    }

    public final void setFont(HUDFont font, Colorf color) {
        this.setFont(font);
        this.setFontColor(color);
    }

    public void setMinValue(int minValue) {
        if (this.minValue == minValue) {
            return;
        }
        this.minValue = minValue;
        this.setValue(this.getValue(), true);
    }

    public final int getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(int maxValue) {
        if (this.maxValue == maxValue) {
            return;
        }
        this.maxValue = maxValue;
        this.setValue(this.getValue(), true);
    }

    public final int getMaxValue() {
        return this.maxValue;
    }

    public final void setMinAndMaxValue(int minValue, int maxValue) {
        if (this.minValue == minValue && this.maxValue == maxValue) {
            return;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.setValue(this.getValue(), true);
    }

    public final void setMinMaxAndValue(int minValue, int maxValue, int value) {
        if (this.minValue == minValue && this.maxValue == maxValue && this.value == value) {
            return;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.setValue(value, true);
    }

    protected String makeText() {
        return String.valueOf((this.getValue() - this.getMinValue()) * 100 / (this.getMaxValue() - this.getMinValue())) + "%";
    }

    protected void setValue(int value, boolean forced) {
        if (value == this.value && !forced) {
            return;
        }
        this.value = Math.max(this.minValue, Math.min(value, this.maxValue));
        if (this.label != null) {
            this.label.setText(this.makeText());
        }
        this.setTextureDirty();
    }

    public final void setValue(int value) {
        this.setValue(value, false);
    }

    public final int getValue() {
        return this.value;
    }

    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        TextureImage2D btexImg = this.barTex.getImage0();
        int srcOrgW = HUDTextureUtils.getTextureWidth(this.barTex);
        int srcOrgH = HUDTextureUtils.getTextureHeight(this.barTex);
        int srcBottomH = this.bottomHeight;
        int srcRightW = this.rightWidth;
        int srcTopH = this.topHeight;
        int srcLeftW = this.leftWidth;
        int srcRightLeft = srcOrgW - srcRightW;
        int srcBottomTop = srcOrgH - srcBottomH;
        int trgRightLeft = width - srcRightW;
        int trgBottomTop = height - srcBottomH;
        int srcBodyWidth = srcOrgW - srcLeftW - srcRightW;
        int srcBodyHeight = srcOrgH - srcTopH - srcBottomH;
        int trgBodyWidth = (width - srcLeftW - srcRightW) * (this.getValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
        int trgBodyHeight = height - srcTopH - srcBottomH;
        TextureImage2D ti = texCanvas.getImage();
        if (srcLeftW > 0 && srcBottomH > 0) {
            ti.drawImage(btexImg, 0, srcBottomTop, srcLeftW, srcBottomH, offsetX + 0, offsetY + trgBottomTop, true, null);
        }
        if (srcRightW > 0 && srcBottomH > 0) {
            ti.drawImage(btexImg, srcRightLeft, srcBottomTop, srcRightW, srcBottomH, offsetX + trgRightLeft, offsetY + trgBottomTop, true, null);
        }
        if (srcRightW > 0 && srcTopH > 0) {
            ti.drawImage(btexImg, srcRightLeft, 0, srcRightW, srcTopH, offsetX + trgRightLeft, offsetY, true, null);
        }
        if (srcLeftW > 0 && srcTopH > 0) {
            ti.drawImage(btexImg, 0, 0, srcLeftW, srcTopH, offsetX, offsetY, true, null);
        }
        if (srcBottomH > 0) {
            ti.drawImage(btexImg, srcLeftW, srcBottomTop, srcOrgW - srcLeftW - srcRightW, srcBottomH, offsetX + srcLeftW, offsetY + trgBottomTop, trgBodyWidth, srcBottomH, true, null);
        }
        if (srcRightW > 0) {
            ti.drawImage(btexImg, srcRightLeft, srcTopH, srcRightW, srcOrgH - srcTopH - srcBottomH, offsetX + trgRightLeft, offsetY + srcTopH, srcRightW, trgBodyHeight, true, null);
        }
        if (srcTopH > 0) {
            ti.drawImage(btexImg, srcLeftW, 0, srcOrgW - srcLeftW - srcRightW, srcTopH, offsetX + srcLeftW, offsetY, trgBodyWidth, srcTopH, true, null);
        }
        if (srcLeftW > 0) {
            ti.drawImage(btexImg, 0, srcTopH, srcLeftW, srcOrgH - srcTopH - srcBottomH, offsetX, offsetY + srcTopH, srcLeftW, trgBodyHeight, true, null);
        }
        int parts = trgBodyWidth / srcBodyWidth;
        for (int i = 0; i < parts; ++i) {
            texCanvas.drawImage(btexImg.getBufferedImage(), offsetX + srcLeftW, offsetY + trgBottomTop, offsetX + srcLeftW + srcBodyWidth, offsetY + srcTopH, srcLeftW, srcTopH, srcBodyWidth, srcBodyHeight);
            offsetX += srcBodyWidth;
        }
        int lastPartWidth = trgBodyWidth % srcBodyWidth;
        if (lastPartWidth > 0) {
            texCanvas.drawImage(btexImg.getBufferedImage(), offsetX + srcLeftW, offsetY + trgBottomTop, offsetX + srcLeftW + lastPartWidth, offsetY + srcTopH, srcLeftW, srcTopH, lastPartWidth, srcBodyHeight);
        }
    }

    protected void init() {
    }

    public ProgressBar(boolean isHeavyWeight, float width, float height, int minValue, int maxValue, Description desc) {
        super(isHeavyWeight, true, width, height, null, null, TileMode.STRETCH);
        if (desc == null) {
            desc = HUD.getTheme().getProgressBarDescription();
        }
        this.leftWidth = desc.getLeftWidth();
        this.rightWidth = desc.getRightWidth();
        this.topHeight = desc.getTopHeight();
        this.bottomHeight = desc.getBottomHeight();
        this.barTex = desc.getBarTexture();
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = minValue;
        if (desc.getLabelDescription() != null) {
            this.label = new Label(false, width, height, "0%", desc.getLabelDescription());
            this.label.setBackground(null, (Texture2D)null, null);
            this.getWidgetAssembler().addWidget(this.label);
        }
        if (desc.getBorderDescription() != null) {
            this.setBorder(BorderFactory.createBorder(desc.getBorderDescription()));
        }
        this.setFocussable(false);
    }

    public ProgressBar(boolean isHeavyWeight, float width, float height, int minValue, int maxValue) {
        this(isHeavyWeight, width, height, minValue, maxValue, null);
    }

    public ProgressBar(boolean isHeavyWeight, float width, float height) {
        this(isHeavyWeight, width, height, 0, 100, null);
    }

    public ProgressBar(float width, float height, int minValue, int maxValue, Description desc) {
        this(false, width, height, minValue, maxValue, desc);
    }

    public ProgressBar(float width, float height, int minValue, int maxValue) {
        this(false, width, height, minValue, maxValue, null);
    }

    public ProgressBar(float width, float height) {
        this(false, width, height, 0, 100, null);
    }

    public static class Description
    extends BackgroundSettableWidget.BackgroundSettableDescriptionBase {
        private int leftWidth;
        private int rightWidth;
        private int topHeight;
        private int bottomHeight;
        private Texture2D barTexture;
        private Border.Description borderDesc;
        private Label.Description labelDesc;

        public void setBottomHeight(int bh) {
            this.bottomHeight = bh;
        }

        public final int getBottomHeight() {
            return this.bottomHeight;
        }

        public void setRightWidth(int rw) {
            this.rightWidth = rw;
        }

        public final int getRightWidth() {
            return this.rightWidth;
        }

        public void setTopHeight(int th) {
            this.topHeight = th;
        }

        public final int getTopHeight() {
            return this.topHeight;
        }

        public void setLeftWidth(int lw) {
            this.leftWidth = lw;
        }

        public final int getLeftWidth() {
            return this.leftWidth;
        }

        public void setBarTexture(Texture2D texture) {
            this.barTexture = texture;
        }

        public void setBarTexture(String texture) {
            this.setBarTexture(HUDTextureUtils.getTexture(texture, true));
        }

        public final Texture2D getBarTexture() {
            return this.barTexture;
        }

        public void setBorderDescription(Border.Description borderDesc) {
            this.borderDesc = borderDesc;
        }

        public final Border.Description getBorderDescription() {
            return this.borderDesc;
        }

        public void setLabelDescription(Label.Description labelDesc) {
            this.labelDesc = labelDesc;
        }

        public final Label.Description getLabelDescription() {
            return this.labelDesc;
        }

        public void set(Description desc) {
            super.setBgSDB(desc);
            this.leftWidth = desc.leftWidth;
            this.rightWidth = desc.rightWidth;
            this.topHeight = desc.topHeight;
            this.bottomHeight = desc.bottomHeight;
            this.barTexture = desc.barTexture;
            this.borderDesc = desc.borderDesc.clone();
            this.labelDesc = desc.labelDesc.clone();
        }

        public Description clone() {
            return new Description(this);
        }

        private Description(Description desc) {
            super(desc.getBackgroundColor(), desc.getBackgroundTexture());
            this.set(desc);
        }

        public Description(int bottom, int right, int top, int left, Colorf backgroundColor, Texture2D backgroundTexture, Texture2D barTex, Border.Description borderDesc, Label.Description labelDesc) {
            super(backgroundColor, backgroundTexture);
            this.bottomHeight = Math.max(0, bottom);
            this.rightWidth = Math.max(0, right);
            this.topHeight = Math.max(0, top);
            this.leftWidth = Math.max(0, left);
            this.barTexture = barTex;
            this.borderDesc = borderDesc;
            if (borderDesc == null) {
                this.borderDesc = HUD.getTheme().getProgressBarBorderDesc();
            }
            this.labelDesc = labelDesc;
            if (labelDesc == null) {
                this.labelDesc = HUD.getTheme().getProgressbarLabelDescription();
            }
        }

        public Description(int bottom, int right, int top, int left, Colorf backgroundColor, String backgroundTexture, String barTex, Border.Description borderDesc, Label.Description labelDesc) {
            this(bottom, right, top, left, backgroundColor, HUDTextureUtils.getTexture(backgroundTexture, true), HUDTextureUtils.getTexture(barTex, true), borderDesc, labelDesc);
        }
    }
}

