/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import java.util.ArrayList;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Dim2i;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix4f;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.ui.hud.listeners.ContainerScrollListener;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.ScrollHandler;
import org.xith3d.ui.hud.utils.TileMode;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.Scrollbar;

public class ScrollPanel
extends Panel {
    private final ScrollHandler scrollHandler;
    private final ArrayList<ContainerScrollListener> scrollListeners = new ArrayList();

    public final void addContainerScrollListener(ContainerScrollListener l) {
        this.scrollListeners.add(l);
    }

    public final void removeContainerScrollListener(ContainerScrollListener l) {
        this.scrollListeners.add(l);
    }

    public void setLineHeight(float lineHeight) {
        this.scrollHandler.setLineHeight((int)lineHeight);
    }

    public final float getLineHeight() {
        return this.scrollHandler.getLineHeight();
    }

    private void setChildrenOffset(boolean changeX, int offsetX, boolean changeY, int offsetY) {
        if (this.getHUD() == null) {
            return;
        }
        TransformGroup childrenTG = (TransformGroup)this.getSGGroup();
        Matrix4f m = childrenTG.getTransform().getMatrix4f();
        float tx = m.m03();
        float ty = m.m13();
        Dim2i buffer2 = Dim2i.fromPool();
        this.getSizeHUD2Pixels(offsetX, offsetY, buffer2);
        if (changeX) {
            this.childrenOffset_PX.setX(buffer2.getWidth());
            this.childrenOffset_HUD.setX(offsetX);
        }
        if (changeY) {
            this.childrenOffset_PX.setY(buffer2.getHeight());
            this.childrenOffset_HUD.setY(offsetY);
        }
        Dim2i.toPool(buffer2);
        Dim2f buffer = Dim2f.fromPool();
        this.getSizeHUD2SG(offsetX, offsetY, buffer);
        if (changeX) {
            tx = buffer.getWidth();
        }
        if (changeY) {
            ty = buffer.getHeight();
        }
        Dim2f.toPool(buffer);
        m.m03(tx);
        m.m13(ty);
        childrenTG.updateTransform();
        this.setTextureDirty();
        for (int i = 0; i < this.scrollListeners.size(); ++i) {
            this.scrollListeners.get(i).onContainerScrolled(this, offsetX, offsetY);
        }
    }

    protected void init() {
    }

    protected GroupNode createChildrenGroup() {
        return new TransformGroup();
    }

    public ScrollPanel(boolean isHeavyWeight, float width, float height, Colorf backgroundColor, Texture2D backgroundTex, TileMode backgroundTileMode) {
        super(isHeavyWeight, true, width, height, backgroundColor, backgroundTex, backgroundTileMode);
        this.scrollHandler = new ScrollHandler(this, this.getWidgetAssembler(), true, true){

            public void onScrolled(Scrollbar.Direction direction, int newValue) {
                if (direction == Scrollbar.Direction.VERTICAL) {
                    ScrollPanel.this.setChildrenOffset(false, 0, true, newValue);
                } else {
                    ScrollPanel.this.setChildrenOffset(true, -newValue, false, 0);
                }
            }
        };
        this.setLineHeight(16.0f);
    }

    public ScrollPanel(boolean isHeavyWeight, float width, float height, Colorf backgroundColor, Texture2D backgroundTex) {
        this(isHeavyWeight, width, height, backgroundColor, backgroundTex, TileMode.TILE_BOTH);
    }

    public ScrollPanel(boolean isHeavyWeight, float width, float height, Colorf backgroundColor, String backgroundTex) {
        this(isHeavyWeight, width, height, backgroundColor, HUDTextureUtils.getTexture(backgroundTex, true));
    }

    public ScrollPanel(boolean isHeavyWeight, float width, float height, Colorf backgroundColor) {
        this(isHeavyWeight, width, height, backgroundColor, (Texture2D)null);
    }

    public ScrollPanel(boolean isHeavyWeight, float width, float height, Texture2D backgroundTex) {
        this(isHeavyWeight, width, height, null, backgroundTex);
    }

    public ScrollPanel(boolean isHeavyWeight, float width, float height, String backgroundTex) {
        this(isHeavyWeight, width, height, null, HUDTextureUtils.getTexture(backgroundTex, true));
    }

    public ScrollPanel(boolean isHeavyWeight, float width, float height) {
        this(isHeavyWeight, width, height, null, (Texture2D)null);
    }

    public ScrollPanel(float width, float height, Colorf backgroundColor, Texture2D backgroundTex) {
        this(false, width, height, backgroundColor, backgroundTex);
    }

    public ScrollPanel(float width, float height, Colorf backgroundColor, String backgroundTex) {
        this(false, width, height, backgroundColor, HUDTextureUtils.getTexture(backgroundTex, true));
    }

    public ScrollPanel(float width, float height, Colorf backgroundColor) {
        this(false, width, height, backgroundColor, (Texture2D)null);
    }

    public ScrollPanel(float width, float height, Texture2D backgroundTex) {
        this(false, width, height, null, backgroundTex);
    }

    public ScrollPanel(float width, float height, String backgroundTex) {
        this(false, width, height, null, HUDTextureUtils.getTexture(backgroundTex, true));
    }

    public ScrollPanel(float width, float height) {
        this(false, width, height, null, (Texture2D)null);
    }

    public static final ScrollPanel createContentPane(float width, float height) {
        return (ScrollPanel)ScrollPanel.createContentPane(width, height, true);
    }
}

