/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Button;

public class ToggleButton
extends Button {
    private boolean isToggled = false;

    public void setToggled(boolean toggled) {
        this.isToggled = toggled;
        this.buttonState = this.isToggled ? AbstractButton.ButtonState.PRESSED : AbstractButton.ButtonState.NORMAL;
        this.update();
    }

    public final boolean isToggled() {
        return this.isToggled;
    }

    protected void onMouseEntered(boolean isTopMost, boolean hasFocus) {
        this.isStateChangable = false;
        super.onMouseEntered(isTopMost, hasFocus);
        this.isStateChangable = true;
        if (isTopMost && !this.isToggled && this.isEnabled()) {
            this.buttonState = AbstractButton.ButtonState.HOVERED;
            this.update();
        }
    }

    protected void onMouseExited(boolean isTopMost, boolean hasFocus) {
        this.isStateChangable = false;
        super.onMouseExited(isTopMost, hasFocus);
        this.isStateChangable = true;
        if (isTopMost && !this.isToggled && this.isEnabled()) {
            this.setButtonState(AbstractButton.ButtonState.NORMAL);
        }
    }

    protected void onMouseButtonPressed(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        this.isStateChangable = false;
        super.onMouseButtonPressed(button, x, y, when, lastWhen, isTopMost, hasFocus);
        this.isStateChangable = true;
        if (isTopMost && this.isEnabled()) {
            this.setButtonState(AbstractButton.ButtonState.PRESSED);
        }
    }

    protected void onMouseButtonReleased(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        this.isStateChangable = false;
        super.onMouseButtonReleased(button, x, y, when, lastWhen, isTopMost, hasFocus);
        this.isStateChangable = true;
        if (isTopMost && this.isEnabled()) {
            if (this.isToggled) {
                this.isToggled = false;
                this.setButtonState(AbstractButton.ButtonState.HOVERED);
            } else {
                this.isToggled = true;
                this.setButtonState(AbstractButton.ButtonState.PRESSED);
            }
            this.update();
            this.fireButtonClickedEvent();
        }
    }

    public ToggleButton(boolean isHeavyWeight, float width, float height, String text, Button.Description desc) {
        super(isHeavyWeight, width, height, text, desc);
    }

    public ToggleButton(boolean isHeavyWeight, float width, float height, String text) {
        this(isHeavyWeight, width, height, text, HUD.getTheme().getButtonDescription());
    }

    public ToggleButton(boolean isHeavyWeight, float width, float height, String text, HUDFont font, Colorf color) {
        this(isHeavyWeight, width, height, text, ToggleButton.deriveDesc(font, color));
    }

    public ToggleButton(boolean isHeavyWeight, float width, float height, String text, HUDFont font) {
        this(isHeavyWeight, width, height, text, ToggleButton.deriveDesc(font, null));
    }

    public ToggleButton(boolean isHeavyWeight, float width, float height, String text, Colorf color) {
        this(isHeavyWeight, width, height, text, ToggleButton.deriveDesc(null, color));
    }

    public ToggleButton(float width, float height, String text, Button.Description desc) {
        this(false, width, height, text, desc);
    }

    public ToggleButton(float width, float height, String text) {
        this(false, width, height, text, HUD.getTheme().getButtonDescription());
    }

    public ToggleButton(float width, float height, String text, HUDFont font, Colorf color) {
        this(false, width, height, text, ToggleButton.deriveDesc(font, color));
    }

    public ToggleButton(float width, float height, String text, HUDFont font) {
        this(false, width, height, text, ToggleButton.deriveDesc(font, null));
    }

    public ToggleButton(float width, float height, String text, Colorf color) {
        this(false, width, height, text, ToggleButton.deriveDesc(null, color));
    }

    public ToggleButton(boolean isHeavyWeight, float width, float height, Texture2D normalTexture, Texture2D hoveredTexture, Texture2D pressedTexture, String text, HUDFont font, Colorf color) {
        this(isHeavyWeight, width, height, text, ToggleButton.createImageButtonDesc(normalTexture, hoveredTexture, pressedTexture, font, color));
    }

    public ToggleButton(boolean isHeavyWeight, float width, float height, String normalTexture, String hoveredTexture, String pressedTexture, String text, HUDFont font, Colorf color) {
        this(isHeavyWeight, width, height, text, ToggleButton.createImageButtonDesc(normalTexture, hoveredTexture, pressedTexture, font, color));
    }

    public ToggleButton(boolean isHeavyWeight, float width, float height, Texture2D normalTexture, Texture2D hoveredTexture, Texture2D pressedTexture) {
        this(isHeavyWeight, width, height, normalTexture, hoveredTexture, pressedTexture, null, null, null);
    }

    public ToggleButton(boolean isHeavyWeight, float width, float height, String normalTexture, String hoveredTexture, String pressedTexture) {
        this(isHeavyWeight, width, height, normalTexture, hoveredTexture, pressedTexture, null, null, null);
    }

    public ToggleButton(float width, float height, Texture2D normalTexture, Texture2D hoveredTexture, Texture2D pressedTexture, String text, HUDFont font, Colorf color) {
        this(false, width, height, text, ToggleButton.createImageButtonDesc(normalTexture, hoveredTexture, pressedTexture, font, color));
    }

    public ToggleButton(float width, float height, String normalTexture, String hoveredTexture, String pressedTexture, String text, HUDFont font, Colorf color) {
        this(false, width, height, text, ToggleButton.createImageButtonDesc(normalTexture, hoveredTexture, pressedTexture, font, color));
    }

    public ToggleButton(float width, float height, Texture2D normalTexture, Texture2D hoveredTexture, Texture2D pressedTexture) {
        this(false, width, height, normalTexture, hoveredTexture, pressedTexture, null, null, null);
    }

    public ToggleButton(float width, float height, String normalTexture, String hoveredTexture, String pressedTexture) {
        this(false, width, height, normalTexture, hoveredTexture, pressedTexture, null, null, null);
    }
}

