/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.swingui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.ui.swingui.UIOverlayInterface;

public class UIPositionedWindow
extends Group {
    private Group root = null;
    private TransformGroup posTG = null;
    private UIOverlayInterface data = null;
    private Rectangle bounds = null;
    private int posX = -1;
    private int posY = -1;
    private boolean draggable = false;

    private void buildRoot() {
        this.root = new Group();
        this.addChild(this.root);
        this.posTG = new TransformGroup();
        this.root.addChild(this.posTG);
    }

    public Rectangle getRectangle() {
        return this.bounds;
    }

    public boolean contains(Point p) {
        if (this.bounds == null) {
            return false;
        }
        return this.bounds.contains(p);
    }

    public void setPosition(int x, int y, Dimension canvasDim) {
        this.posX = x;
        this.posY = y;
        if (this.root != null) {
            Dimension d = new Dimension();
            this.data.getSize(d);
            Transform3D t = new Transform3D();
            t.setTranslation(new Vector3f(x, (float)canvasDim.height - (float)y - (float)d.height, 0.0f));
            this.posTG.setTransform(t);
            this.bounds = new Rectangle(new Point(x, y), d);
        }
    }

    public void setDraggable(boolean b) {
        this.draggable = b;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public int getX() {
        return this.posX;
    }

    public int getY() {
        return this.posY;
    }

    public void empty() {
        if (this.root != null) {
            if (this.root.isLive()) {
                this.root.detach();
            }
            this.root.detach();
            this.root = null;
            this.posTG = null;
            this.data = null;
            this.bounds = null;
        }
    }

    public boolean isAssigned() {
        return this.root != null;
    }

    public void assign(UIOverlayInterface overlay) {
        if (this.root != null) {
            this.empty();
        }
        this.buildRoot();
        this.posTG.addChild(overlay.getRoot());
        this.data = overlay;
    }

    public boolean isVisible() {
        if (this.root == null) {
            return false;
        }
        return this.root.getParent() != null;
    }

    public UIOverlayInterface getOverlay() {
        return this.data;
    }

    public void setVisible(boolean show) {
        if (this.root != null) {
            if (show && !this.isVisible()) {
                this.addChild(this.root);
            } else if (!show && this.isVisible()) {
                this.root.detach();
            }
        }
    }
}

