/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.swingui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.openmali.FastMath;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.OrderedGroup;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.ui.swingui.UIDragDropInterface;
import org.xith3d.ui.swingui.UIDraggingInformation;
import org.xith3d.ui.swingui.UIDraggingWindow;
import org.xith3d.ui.swingui.UIOverlayInterface;
import org.xith3d.ui.swingui.UIPositionedWindow;
import org.xith3d.ui.swingui.UIWindow;
import org.xith3d.utility.logging.X3DLog;

public class UIWindowManager
extends RenderPass {
    private static float consoleZ = 7.0f;
    private static int OM_NONE = 0;
    private static int OM_MOVE_WINDOW = 1;
    private static int OM_DRAGGING = 2;
    private static int OM_DRAGGING_NONE = 3;
    private TransformGroup consoleTG;
    private Group windows;
    private OrderedGroup orderedWindows;
    public Transform3D planeOffset;
    public Transform3D worldTransform;
    public Transform3D lastTransform;
    private ArrayList<UIPositionedWindow> windowList = null;
    private float consoleWidth;
    private float consoleHeight;
    private float scale;
    private Dimension canvasDim;
    private Dimension checkDim;
    private int mode = OM_NONE;
    private UIPositionedWindow focus;
    private UIPositionedWindow lastWindow = null;
    private Canvas3D c3d;
    private boolean isDirectX = false;
    private int checks = 0;
    private UIDraggingInformation draggingInfo = null;
    private UIPositionedWindow dragWindow = null;
    private boolean mouseClicked = false;

    private UIPositionedWindow getWindow(Point p) {
        if (this.lastWindow != null && this.lastWindow.isVisible() && this.lastWindow.contains(p)) {
            return this.lastWindow;
        }
        UIPositionedWindow w = null;
        int n = this.windowList.size();
        for (int i = 0; i < n; ++i) {
            w = this.windowList.get(i);
            if (w == this.dragWindow || !w.isVisible() || !w.contains(p)) continue;
            this.lastWindow = w;
            return w;
        }
        return null;
    }

    public void calcImagePlate() {
        this.canvasDim.height = this.c3d.getHeight();
        this.canvasDim.width = this.c3d.getWidth();
        float aspect = (float)this.canvasDim.width / (float)this.canvasDim.height;
        float fovy = this.c3d.getView().getFieldOfView();
        float ymax = consoleZ * FastMath.tan(fovy);
        float xmax = ymax * aspect;
        this.scale = ymax * 2.0f / (float)this.canvasDim.height;
        this.consoleWidth = xmax * 2.0f;
        this.consoleHeight = ymax * 2.0f;
        X3DLog.debug("Building overlay mapping");
        if (this.canvasDim.width != 0) {
            X3DLog.debug("  Overlay scale : ", Float.valueOf(this.scale));
            X3DLog.debug("  aspect is : ", Float.valueOf(aspect));
            X3DLog.debug("  Screen size is : ", this.canvasDim);
            X3DLog.debug("  console width (meters) : ", Float.valueOf(this.consoleWidth));
            X3DLog.debug("  console height (meters) : ", Float.valueOf(this.consoleHeight));
            float texelOffset = 0.0f;
            if (this.isDirectX) {
                texelOffset = this.scale / 2.0f;
            }
            X3DLog.debug("  Driver is : ", this.isDirectX ? "Direct X" : "OpenGL");
            X3DLog.debug("  Texel Offset : ", Float.valueOf(texelOffset));
            this.planeOffset.setTranslation(new Vector3f(-this.consoleWidth / 2.0f - texelOffset, -this.consoleHeight / 2.0f - texelOffset, -consoleZ));
            this.planeOffset.setScale(this.scale);
        } else {
            X3DLog.error("Cannot calculate image plate");
        }
        this.checkDim.setSize(this.canvasDim);
    }

    public void newFrame(View view) {
        this.newFrame(view.getTransform());
    }

    public void newFrame(Transform3D viewTransform) {
        if (this.windowList.size() == 0) {
            return;
        }
        if (this.checks % 100 == 0) {
            // empty if block
        }
        this.worldTransform.set(viewTransform);
        this.worldTransform.mul(this.planeOffset);
        this.consoleTG.setTransform(this.worldTransform);
        int n = this.windowList.size();
        for (int i = 0; i < n; ++i) {
            UIPositionedWindow w = this.windowList.get(i);
            if (!w.isAssigned() || !w.isVisible()) continue;
            w.getOverlay().update();
        }
    }

    public UIPositionedWindow addOverlay(UIOverlayInterface overlay) {
        UIPositionedWindow w = new UIPositionedWindow();
        w.assign(overlay);
        if (overlay instanceof UIWindow) {
            ((UIWindow)overlay).setWindowManager(this);
        }
        if (overlay instanceof UIWindow) {
            w.setDraggable(((UIWindow)overlay).isDraggable());
        }
        if (overlay.isOpaque()) {
            this.orderedWindows.addChild(w);
        } else {
            this.windows.addChild(w);
        }
        this.windowList.add(w);
        return w;
    }

    public void removeOverlay(UIOverlayInterface overlay) {
        UIPositionedWindow w = this.getWindow(overlay);
        if (w != null) {
            w.empty();
        }
    }

    public void setVisible(UIOverlayInterface overlay, boolean show) {
        UIPositionedWindow w = this.getWindow(overlay);
        if (w != null) {
            w.setVisible(show);
        }
    }

    public boolean isVisible(UIOverlayInterface overlay) {
        UIPositionedWindow w = this.getWindow(overlay);
        if (w == null) {
            return false;
        }
        return w.isVisible();
    }

    private UIPositionedWindow getWindow(UIOverlayInterface overlay) {
        UIPositionedWindow w = null;
        int n = this.windowList.size();
        for (int i = 0; i < n; ++i) {
            w = this.windowList.get(i);
            if (w.getOverlay() != overlay) continue;
            return w;
        }
        X3DLog.error("Unknown overlay window referenced");
        return null;
    }

    public void setPosition(UIOverlayInterface overlay, int x, int y) {
        UIPositionedWindow w = this.getWindow(overlay);
        if (w != null) {
            w.setPosition(x, y, this.canvasDim);
        }
    }

    public int getX(UIOverlayInterface overlay) {
        UIPositionedWindow w = this.getWindow(overlay);
        if (w != null) {
            return w.getX();
        }
        return -1;
    }

    public int getY(UIOverlayInterface overlay) {
        UIPositionedWindow w = this.getWindow(overlay);
        if (w != null) {
            return w.getY();
        }
        return -1;
    }

    public void processEvent(AWTEvent e) {
        UIOverlayInterface o;
        if (e instanceof MouseEvent) {
            MouseEvent mev = (MouseEvent)e;
            this.processMouseEvent(new MouseEvent((Component)mev.getSource(), mev.getID(), mev.getWhen(), mev.getModifiers(), mev.getX(), mev.getY(), mev.getClickCount(), false));
        } else if (e instanceof KeyEvent && this.focus != null && (o = this.focus.getOverlay()) instanceof UIWindow) {
            ((UIWindow)o).dispatchEvent(e);
        }
    }

    public void setOverlayFocus(UIOverlayInterface overlay) {
        UIPositionedWindow w = this.getWindow(overlay);
        this.setOverlayFocus(w);
    }

    public void setOverlayFocus(UIPositionedWindow w) {
        if (w == this.focus) {
            return;
        }
        boolean focusFalse = true;
        if (this.focus != null && this.focus.getOverlay() instanceof UIWindow) {
            UIWindow uiw = (UIWindow)this.focus.getOverlay();
            if (uiw.last != null) {
                uiw.last.dispatchEvent(new MouseEvent(uiw.last, 505, 0L, 16, uiw.last.getLocation().x, uiw.last.getLocation().y, 0, false));
                uiw.last = null;
            }
            if (!uiw.textComponentFocus || this.mouseClicked) {
                uiw.setFocus(false);
            } else {
                focusFalse = false;
            }
        }
        if (focusFalse) {
            this.focus = w;
            if (w != null && this.focus.getOverlay() instanceof UIWindow) {
                ((UIWindow)this.focus.getOverlay()).setFocus(true);
            }
        }
    }

    public synchronized void processMouseEvent(MouseEvent me) {
        UIOverlayInterface o;
        UIOverlayInterface o2;
        boolean leftButton = (0x10 & me.getModifiers()) != 0;
        UIPositionedWindow w = this.getWindow(me.getPoint());
        boolean eventConsumed = false;
        if (me.getID() == 503 && this.mode == OM_MOVE_WINDOW) {
            this.focus.setPosition(me.getX(), me.getY(), this.canvasDim);
            eventConsumed = true;
        }
        if (me.getID() == 506) {
            if (this.mode == OM_NONE) {
                this.mode = OM_DRAGGING_NONE;
                if (w != null) {
                    o2 = w.getOverlay();
                    X3DLog.debug("Overlay type is ", o2.getClass().getSimpleName());
                    if (o2 instanceof UIDragDropInterface) {
                        me.translatePoint(-((int)w.getRectangle().getX()), -((int)w.getRectangle().getY()));
                        this.draggingInfo = ((UIDragDropInterface)((Object)o2)).startDrag(me);
                        if (this.draggingInfo != null) {
                            X3DLog.debug("Mouse dragging object!");
                            if (o2 instanceof UIWindow) {
                                MouseEvent mec = new MouseEvent(me.getComponent(), 500, me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), false);
                                ((UIWindow)o2).dispatchEvent(mec);
                            }
                            this.mode = OM_DRAGGING;
                            if (this.dragWindow == null) {
                                UIDraggingWindow dw = new UIDraggingWindow();
                                this.dragWindow = this.addOverlay(dw);
                            }
                            ((UIDraggingWindow)this.dragWindow.getOverlay()).setDi(this.draggingInfo);
                            me.translatePoint((int)w.getRectangle().getX(), (int)w.getRectangle().getY());
                            this.dragWindow.setPosition(me.getX(), me.getY(), this.canvasDim);
                            this.dragWindow.setVisible(true);
                            eventConsumed = true;
                        } else {
                            me.translatePoint((int)w.getRectangle().getX(), (int)w.getRectangle().getY());
                        }
                    }
                }
            } else if (this.mode == OM_DRAGGING) {
                this.dragWindow.setPosition(me.getX(), me.getY(), this.canvasDim);
                boolean canReceive = false;
                if (w != null && (o = w.getOverlay()) instanceof UIDragDropInterface) {
                    me.translatePoint(-((int)w.getRectangle().getX()), -((int)w.getRectangle().getY()));
                    canReceive = ((UIDragDropInterface)((Object)o)).dragging(me, this.draggingInfo);
                }
                eventConsumed = true;
                ((UIDraggingWindow)this.dragWindow.getOverlay()).setCanDrop(canReceive);
            }
        }
        if (me.getID() == 502) {
            if (this.mode == OM_DRAGGING_NONE) {
                X3DLog.debug("Mouse done dragging none");
                this.mode = OM_NONE;
            } else if (this.mode == OM_DRAGGING) {
                this.mode = OM_NONE;
                this.dragWindow.setVisible(false);
                boolean dropped = false;
                if (w != null) {
                    X3DLog.debug("Mouse drop on window");
                    o = w.getOverlay();
                    if (this.draggingInfo != null && o instanceof UIDragDropInterface) {
                        me.translatePoint(-((int)w.getRectangle().getX()), -((int)w.getRectangle().getY()));
                        dropped = ((UIDragDropInterface)((Object)o)).dropped(me, this.draggingInfo);
                        me.translatePoint((int)w.getRectangle().getX(), (int)w.getRectangle().getY());
                    }
                }
                if (!dropped && this.draggingInfo != null && this.draggingInfo.getFailure() != null) {
                    o = null;
                    if (w != null) {
                        o = w.getOverlay();
                    }
                    this.draggingInfo.getFailure().dropFailed(me.getX(), me.getY(), this.draggingInfo, o);
                }
                this.draggingInfo = null;
                eventConsumed = true;
            }
        }
        if (me.getID() == 500) {
            X3DLog.debug("Mouse clicked at ", me.getPoint());
            if (w != null) {
                this.setOverlayFocus(w);
            }
            if (this.mode == OM_MOVE_WINDOW && leftButton) {
                this.mode = OM_NONE;
                X3DLog.debug("Done moving window");
                this.focus.setPosition(me.getX(), me.getY(), this.canvasDim);
            } else if (w != null) {
                X3DLog.debug("Mouse clicked in window ");
                if (w.isDraggable() && leftButton && this.mode == OM_NONE) {
                    Rectangle bounds = new Rectangle(w.getRectangle());
                    bounds.setSize(15, 15);
                    if (bounds.contains(me.getPoint())) {
                        X3DLog.debug("Begin moving window");
                        this.setOverlayFocus(w);
                        this.mode = OM_MOVE_WINDOW;
                    }
                }
            } else {
                this.setOverlayFocus((UIPositionedWindow)null);
            }
        }
        if (!eventConsumed && w != null && (o2 = w.getOverlay()) instanceof UIWindow) {
            if (((UIWindow)o2).isDisabled()) {
                return;
            }
            me.translatePoint(-((int)w.getRectangle().getX()), -((int)w.getRectangle().getY()));
            ((UIWindow)o2).dispatchEvent(me);
        }
    }

    public UIWindowManager(Canvas3D c) {
        super(new BaseRenderPassConfig());
        this.c3d = c;
        this.windowList = new ArrayList(20);
        BranchGroup root = this.getBranchGroup();
        root.setPickable(true);
        this.consoleTG = new TransformGroup();
        root.addChild(this.consoleTG);
        this.consoleTG.setTransform(new Transform3D());
        this.canvasDim = new Dimension();
        this.checkDim = new Dimension();
        this.planeOffset = new Transform3D();
        this.worldTransform = new Transform3D();
        this.lastTransform = new Transform3D();
        this.calcImagePlate();
        this.windows = new Group();
        this.windows.setIgnoreBounds(true);
        this.consoleTG.addChild(this.windows);
        this.orderedWindows = new OrderedGroup();
        this.consoleTG.addChild(this.orderedWindows);
        this.consoleTG.setTransform(this.planeOffset);
    }
}

