/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.camera;

import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.xith3d.loop.Updater;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.util.Placeable;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.camera.BasicPlaceableVerticalFocuser;

public class SmoothPlaceableVerticalFocuser
extends BasicPlaceableVerticalFocuser {
    private final float alpha;
    private Point3f realPos;
    private Tuple3f offset = null;

    public void setOffset(Tuple3f offset) {
        this.offset = offset;
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.realPos == null) {
            this.realPos = new Point3f();
            this.realPos.set((TupleNf)this.getFocusPoint());
        }
        Tuple3f pos = this.getFocusPoint();
        this.realPos.interpolate(pos, this.alpha);
        if (this.offset == null) {
            this.lookAt(this.realPos);
        } else {
            Point3f tmp = Point3f.fromPool();
            tmp.add(this.realPos, this.offset);
            this.lookAt(tmp);
            Point3f.toPool(tmp);
        }
    }

    public SmoothPlaceableVerticalFocuser(View view, Placeable placeable, float height, float alpha, Updater updater) {
        super(view, placeable, height, updater);
        this.alpha = alpha;
    }
}

