/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.characters;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.xith3d.utility.characters.BinarySearchCharIndex;
import org.xith3d.utility.characters.BitSetOptimizedCharIndex;
import org.xith3d.utility.characters.GCOptimizedCharIndex;
import org.xith3d.utility.characters.HashOptimizedCharIndex;
import org.xith3d.utility.characters.SpaceOptimizedCharIndex;

public abstract class CharIndex {
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static Charset charset = null;
    private static CharsetEncoder encoder = null;
    private static CharBuffer charBuffer = null;
    private static ByteBuffer byteBuffer = null;

    protected static boolean isPrintable(char ch, CharsetEncoder encoder, CharBuffer charBuffer, ByteBuffer byteBuffer) {
        boolean result = false;
        if (ch == ' ') {
            result = true;
        } else {
            switch (Character.getType(ch)) {
                case 0: 
                case 4: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    result = true;
                    break;
                }
                default: {
                    assert (false) : "Has the Unicode specification been updated since this code was written?";
                    break;
                }
            }
            if (result) {
                charBuffer.clear();
                byteBuffer.clear();
                charBuffer.append(ch);
                charBuffer.rewind();
                CoderResult cr = encoder.encode(charBuffer, byteBuffer, true);
                if (cr.isUnmappable()) {
                    result = false;
                }
            }
        }
        return result;
    }

    public static boolean isPrintable(char ch, Charset charset) {
        if (charset == null) {
            charset = CharIndex.charset == null ? DEFAULT_CHARSET : CharIndex.charset;
            if (!CharIndex.charset.equals(charset)) {
                encoder = null;
            }
        } else if (CharIndex.charset != null && !CharIndex.charset.equals(charset)) {
            encoder = null;
        }
        if (encoder == null) {
            CharIndex.charset = charset;
            encoder = charset.newEncoder();
            encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            encoder.onMalformedInput(CodingErrorAction.REPORT);
            charBuffer = CharBuffer.allocate(1);
            byteBuffer = ByteBuffer.allocate(2);
        }
        return CharIndex.isPrintable(ch, encoder, charBuffer, byteBuffer);
    }

    public static boolean isPrintable(char ch, String charset) {
        return CharIndex.isPrintable(ch, Charset.forName(charset));
    }

    public static boolean isPrintable(char ch) {
        return CharIndex.isPrintable(ch, charset != null ? charset : DEFAULT_CHARSET);
    }

    public abstract MemoryStrategy getMemoryStrategy();

    public abstract Charset getCharset();

    public abstract int getTotalNumberOfCharacters();

    public abstract int getNumberOfPrintableChars();

    public abstract int getIndex(char var1);

    protected CharIndex() {
    }

    public static CharIndex createSpaceOptimizedCharIndex(Charset charset) {
        assert (charset != null) : "Charset must not be null.";
        return new SpaceOptimizedCharIndex(charset);
    }

    public static CharIndex createSpaceOptimizedCharIndex(String charset) {
        assert (charset != null) : "Charset must not be null.";
        return CharIndex.createSpaceOptimizedCharIndex(Charset.forName(charset));
    }

    public static CharIndex createSpaceOptimizedCharIndex() {
        return CharIndex.createSpaceOptimizedCharIndex(Charset.defaultCharset());
    }

    public static CharIndex createBitSetOptimizedCharIndex(Charset charset) {
        assert (charset != null) : "Charset must not be null.";
        return new BitSetOptimizedCharIndex(charset);
    }

    public static CharIndex createBitSetOptimizedCharIndex(String charset) {
        assert (charset != null) : "Charset must not be null.";
        return CharIndex.createBitSetOptimizedCharIndex(Charset.forName(charset));
    }

    public static CharIndex createBitSetOptimizedCharIndex() {
        return CharIndex.createBitSetOptimizedCharIndex(Charset.defaultCharset());
    }

    public static CharIndex createGCOptimizedCharIndex(Charset charset) {
        assert (charset != null) : "Charset must not be null.";
        return new GCOptimizedCharIndex(charset);
    }

    public static CharIndex createGCOptimizedCharIndex(String charset) {
        assert (charset != null) : "Charset must not be null.";
        return CharIndex.createGCOptimizedCharIndex(Charset.forName(charset));
    }

    public static CharIndex createGCOptimizedCharIndex() {
        return CharIndex.createGCOptimizedCharIndex(Charset.defaultCharset());
    }

    public static CharIndex createHashOptimizedCharIndex(Charset charset) {
        assert (charset != null) : "Charset must not be null.";
        return new HashOptimizedCharIndex(charset);
    }

    public static CharIndex createHashOptimizedCharIndex(String charset) {
        assert (charset != null) : "Charset must not be null.";
        return CharIndex.createHashOptimizedCharIndex(Charset.forName(charset));
    }

    public static CharIndex createHashOptimizedCharIndex() {
        return CharIndex.createHashOptimizedCharIndex(Charset.defaultCharset());
    }

    public static CharIndex createBinSearchOptimizedCharIndex(Charset charset) {
        assert (charset != null) : "Charset must not be null.";
        return new BinarySearchCharIndex(charset);
    }

    public static CharIndex createBinSearchOptimizedCharIndex(String charset) {
        assert (charset != null) : "Charset must not be null.";
        return CharIndex.createBinSearchOptimizedCharIndex(Charset.forName(charset));
    }

    public static CharIndex createBinSearchOptimizedCharIndex() {
        return CharIndex.createBinSearchOptimizedCharIndex(Charset.defaultCharset());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MemoryStrategy {
        SPACE_OPTIMIZED,
        BITSET_OPTIMIZED,
        GC_OPTIMIZED,
        HASH_OPTIMIZED,
        BINSEARCH_OPTIMIZED;

    }
}

