/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.classes.beans;

import java.lang.reflect.Method;

public class BeanUtil {
    public static Object get(Object object, String member) {
        Object value = null;
        try {
            Method met = BeanUtil.getGetter(object, member);
            value = met.invoke(object, (Object[])null);
        }
        catch (NoGetterException e) {
            try {
                value = object.getClass().getField(member).get(object);
            }
            catch (NoSuchFieldException ex) {
                throw new Error("Could not find either a getter or a field named " + member + " in object of type " + object.getClass().getSimpleName());
            }
            catch (Exception ex) {
                throw new Error(e);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return value;
    }

    public static Method getGetter(Object object, String member) throws NoGetterException {
        String name = member.substring(0, 1).toUpperCase() + member.substring(1);
        Method met = null;
        try {
            met = object.getClass().getMethod("get" + name, null);
        }
        catch (Exception e) {
            try {
                met = object.getClass().getMethod("is" + name, null);
            }
            catch (Exception ex) {
                throw new NoGetterException("Could not find a getter for member: " + member + " of object of type " + object.getClass().getSimpleName());
            }
        }
        return met;
    }

    public static void set(Object object, String member, Object value) {
        try {
            Method met = BeanUtil.getSetter(object, member);
            try {
                met.invoke(object, value);
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        catch (NoSetterException e) {
            try {
                object.getClass().getField(member).set(object, value);
            }
            catch (NoSuchFieldException ex) {
                throw new Error("Couldn't find setter nor member of name " + member + " in object of type : " + object.getClass().getSimpleName());
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }
    }

    public static Method getSetter(Object object, String member) throws NoSetterException {
        StringBuffer buffer = new StringBuffer(member.length() + 4);
        buffer.append("set");
        buffer.append(member.substring(0, 1).toUpperCase());
        buffer.append(member.substring(1));
        String name = buffer.toString();
        Method met = null;
        try {
            Class<?> clazz = object.getClass().getDeclaredField(member).getType();
            met = object.getClass().getMethod(name, clazz);
        }
        catch (Exception e) {
            Method[] methods;
            for (Method potentialMethod : methods = object.getClass().getMethods()) {
                if (!potentialMethod.getName().equals(name) || potentialMethod.getParameterTypes().length != 1) continue;
                met = potentialMethod;
                break;
            }
        }
        if (met == null) {
            throw new NoSetterException("Could not find a setter for member " + member + " of object of type " + object.getClass().getSimpleName());
        }
        return met;
    }

    public static class NoSetterException
    extends Exception {
        private static final long serialVersionUID = -2022823537582982371L;

        public NoSetterException(String msg) {
            super(msg);
        }
    }

    public static class NoGetterException
    extends Exception {
        private static final long serialVersionUID = -8473000634200869273L;

        public NoGetterException(String msg) {
            super(msg);
        }
    }
}

