/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.filechooser.FileSystemView;
import org.xith3d.Xith3D;
import org.xith3d.utility.config.Configurable;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configuration {
    private final HashMap<String, TargetSpec> mapping = new HashMap();
    private Properties currentConfig = new Properties();

    public final Properties getCurrentConfig() {
        return this.currentConfig;
    }

    public void register(String propertyKey, Class<?> targetClass, String targetProperty, String description) {
        this.mapping.put(propertyKey, new TargetSpec(targetClass, targetProperty, description));
    }

    public void register(String propertyKey, Class<?> targetClass, String targetProperty) {
        this.register(propertyKey, targetClass, targetProperty, null);
    }

    public void register(Class<?> targetClass, String targetProperty, String description) {
        String propertyKey = targetClass.getSimpleName() + "." + targetProperty;
        this.register(propertyKey, targetClass, targetProperty, description);
    }

    public void register(Class<?> targetClass, String targetProperty) {
        String propertyKey = targetClass.getSimpleName() + "." + targetProperty;
        this.register(propertyKey, targetClass, targetProperty, null);
    }

    public void register(Class<?> targetClass) {
        String[] vs;
        Method[] methods = targetClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Configurable c = method.getAnnotation(Configurable.class);
            if (c == null) continue;
            String targetProperty = method.getName();
            int skip = targetProperty.indexOf("is") == 0 ? 2 : 3;
            targetProperty = targetProperty.substring(skip, skip + 1).toLowerCase() + targetProperty.substring(skip + 1);
            vs = c.value();
            if (vs != null & vs.length > 0) {
                this.register(vs[0], targetClass, targetProperty, vs.length > 1 ? vs[1] : null);
                continue;
            }
            this.register(targetClass, targetProperty);
        }
        Field[] fields = targetClass.getDeclaredFields();
        for (int i = 0; i < methods.length; ++i) {
            Field field = fields[i];
            Configurable c = field.getAnnotation(Configurable.class);
            if (c == null) continue;
            String targetProperty = field.getName();
            vs = c.value();
            if (vs != null & vs.length > 0) {
                this.register(vs[0], targetClass, targetProperty, vs.length > 1 ? vs[1] : null);
                continue;
            }
            this.register(targetClass, targetProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromClassPath(String subdir, String filename) {
        InputStream stream = Xith3D.class.getResourceAsStream("settings/" + subdir + "/" + filename);
        if (stream != null) {
            try {
                this.currentConfig.load(stream);
            }
            catch (IOException ex) {
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromHomeDirectory(String subdir, String filename) {
        String home = FileSystemView.getFileSystemView().getHomeDirectory().getAbsolutePath();
        File file = new File(home + "/" + subdir, filename);
        FileInputStream stream = null;
        if (file.exists()) {
            try {
                stream = new FileInputStream(file);
                this.currentConfig = new Properties(this.currentConfig);
                this.currentConfig.load(stream);
            }
            catch (IOException ex) {
            }
            finally {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromMyDocuments(String subdir, String filename) {
        FileSystemView filesystem = FileSystemView.getFileSystemView();
        if (!filesystem.getHomeDirectory().equals(filesystem.getDefaultDirectory())) {
            File file = new File(filesystem.getDefaultDirectory() + "/" + subdir, filename);
            FileInputStream stream = null;
            if (file.exists()) {
                try {
                    stream = new FileInputStream(file);
                    this.currentConfig = new Properties(this.currentConfig);
                    this.currentConfig.load(stream);
                }
                catch (IOException ex) {
                }
                finally {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Exception ignore) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromCurrentWorkingDirectory(String subdir, String filename) {
        File file = new File(System.getProperty("user.dir"), filename);
        FileInputStream stream = null;
        if (file.exists()) {
            try {
                stream = new FileInputStream(file);
                this.currentConfig = new Properties(this.currentConfig);
                this.currentConfig.load(stream);
            }
            catch (IOException ex) {
            }
            finally {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
    }

    private Method findSetter(TargetSpec spec) {
        Method[] methods = spec.targetClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (params == null || params.length != 1 || !method.getName().equals("set" + spec.camelCaseTargetProperty)) continue;
            return method;
        }
        return null;
    }

    private void loadSettings(Properties config) {
        for (Object key : config.keySet()) {
            String name = (String)key;
            String value = config.getProperty(name);
            TargetSpec spec = this.mapping.get(name);
            if (spec == null) continue;
            Method setter = this.findSetter(spec);
            try {
                if (setter != null) {
                    Class<Object> type = setter.getParameterTypes()[0];
                    if (type.isAssignableFrom(Byte.TYPE)) {
                        setter.invoke(null, Byte.parseByte(value));
                        continue;
                    }
                    if (type.isAssignableFrom(Short.TYPE)) {
                        setter.invoke(null, Short.parseShort(value));
                        continue;
                    }
                    if (type.isAssignableFrom(Integer.TYPE)) {
                        setter.invoke(null, Integer.parseInt(value));
                        continue;
                    }
                    if (type.isAssignableFrom(Long.TYPE)) {
                        setter.invoke(null, Long.parseLong(value));
                        continue;
                    }
                    if (type.isAssignableFrom(Float.TYPE)) {
                        setter.invoke(null, Float.valueOf(Float.parseFloat(value)));
                        continue;
                    }
                    if (type.isAssignableFrom(Double.TYPE)) {
                        setter.invoke(null, Double.parseDouble(value));
                        continue;
                    }
                    if (type.isAssignableFrom(Boolean.TYPE)) {
                        setter.invoke(null, Boolean.parseBoolean(value));
                        continue;
                    }
                    if (!type.isAssignableFrom(String.class)) continue;
                    setter.invoke(null, value);
                    continue;
                }
                Field field = spec.targetClass.getField(spec.targetProperty);
                Class<Object> type = field.getType();
                if (type.isAssignableFrom(Byte.TYPE)) {
                    field.set(null, Byte.parseByte(value));
                    continue;
                }
                if (type.isAssignableFrom(Short.TYPE)) {
                    field.set(null, Short.parseShort(value));
                    continue;
                }
                if (type.isAssignableFrom(Integer.TYPE)) {
                    field.set(null, Integer.parseInt(value));
                    continue;
                }
                if (type.isAssignableFrom(Long.TYPE)) {
                    field.set(null, Long.parseLong(value));
                    continue;
                }
                if (type.isAssignableFrom(Float.TYPE)) {
                    field.set(null, Float.valueOf(Float.parseFloat(value)));
                    continue;
                }
                if (type.isAssignableFrom(Double.TYPE)) {
                    field.set(null, Double.parseDouble(value));
                    continue;
                }
                if (type.isAssignableFrom(Boolean.TYPE)) {
                    field.set(null, Boolean.parseBoolean(value));
                    continue;
                }
                if (!type.isAssignableFrom(String.class)) continue;
                field.set(null, value);
            }
            catch (Throwable t) {
                X3DLog.print(t);
            }
        }
    }

    public void load(String subdir, String filename) {
        this.currentConfig.clear();
        this.loadFromClassPath(subdir, filename);
        this.loadFromHomeDirectory(subdir, filename);
        this.loadFromMyDocuments(subdir, filename);
        this.loadSettings(this.currentConfig);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TargetSpec {
        final Class<?> targetClass;
        final String targetProperty;
        final String camelCaseTargetProperty;

        TargetSpec(Class<?> targetClass, String targetProperty, String description) {
            this.targetClass = targetClass;
            this.targetProperty = targetProperty;
            String camelCaseName = targetProperty;
            this.camelCaseTargetProperty = camelCaseName = camelCaseName.substring(0, 1).toUpperCase() + camelCaseName.substring(1);
        }
    }
}

