/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.general;

import java.util.ArrayList;
import org.xith3d.utility.general.SparseMatrixInterface;
import org.xith3d.utility.general.SparseVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseClusteredMatrix<T>
implements SparseMatrixInterface<T> {
    private SparseVector<SparseVector<T>> v = new SparseVector();

    @Override
    public void insertAt(int x, int z, T obj) {
        SparseVector<T> col = this.v.elementAt(x);
        if (col == null) {
            col = new SparseVector();
            this.v.insertAt(x, col);
        }
        col.insertAt(z, obj);
    }

    @Override
    public void removeAt(int x, int z) {
        SparseVector<T> col = this.v.elementAt(x);
        if (col == null) {
            return;
        }
        col.removeAt(z);
    }

    @Override
    public T elementAt(int x, int z) {
        SparseVector<T> col = this.v.elementAt(x);
        if (col == null) {
            return null;
        }
        return col.elementAt(z);
    }

    public void elementsWithin(ArrayList<T> within, ArrayList<T> without, int x1, int z1, int x2, int z2) {
        int i;
        within = new ArrayList();
        without = new ArrayList();
        ArrayList colWithin = new ArrayList();
        ArrayList colWithout = new ArrayList();
        this.v.sortElements(colWithin, colWithout, x1, x2);
        for (i = 0; i < colWithin.size(); ++i) {
            ((SparseVector)colWithin.get(i)).sortElements(within, without, z1, z2);
        }
        for (i = 0; i < colWithout.size(); ++i) {
            ((SparseVector)colWithout.get(i)).sortElements(within, without, z1, z2);
        }
    }
}

