/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.general;

import java.io.IOException;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.AnalogDeviceComponent;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.listeners.InputStateListener;
import org.jagatoo.util.arrays.ArrayUtils;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.sound.ExtensionSoundLoader;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.OperationScheduler;
import org.xith3d.loop.opscheduler.impl.ScheduledOperationImpl;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPass;
import org.xith3d.scenegraph.BackgroundSound;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.RectBillboard;
import org.xith3d.scenegraph.utils.ShapeUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;

public class Xith3DLogo {
    private static final HUDFont font;
    private Colorf oldCanvasBackgroundColor;
    private SceneGraph sceneGraph;
    private RenderPass renderPass;
    private PointLight light;
    private TransformGroup modelTrans;
    private BackgroundSound sound;
    private HUD hud;
    private Label label;
    private boolean finished;

    private static final float interpolate(float time, float startTime, float endTime, float startValue, float endValue, float preValue, float postValue) {
        if (time < startTime) {
            return preValue;
        }
        if (time <= endTime) {
            return startValue + (endValue - startValue) * (time - startTime) / (endTime - startTime);
        }
        return postValue;
    }

    private void setupInterpolators(final Canvas3D canvas, OperationScheduler opScheder) {
        opScheder.scheduleOperation(new ScheduledOperationImpl(true){
            private long startTime;
            {
                super(x0);
                this.startTime = -1L;
            }

            public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                float time;
                if (Xith3DLogo.this.finished) {
                    this.setAlive(false);
                    return;
                }
                if (this.startTime == -1L) {
                    this.startTime = gameTime;
                }
                if ((time = timingMode.getSecondsAsFloat(gameTime - this.startTime)) <= 2.1f) {
                    Tuple3f tmp = Tuple3f.fromPool();
                    Xith3DLogo.this.modelTrans.getTransform().getRotation(tmp);
                    tmp.setY(Xith3DLogo.interpolate(time, 0.0f, 2.1f, (float)Math.PI * 2, 0.0f, 0.0f, 0.0f));
                    Xith3DLogo.this.modelTrans.getTransform().setRotation(tmp);
                    Xith3DLogo.this.modelTrans.getTransform().getTranslation(tmp);
                    tmp.setZ(Xith3DLogo.interpolate(time, 0.0f, 2.1f, -50.0f, -0.5f, -50.0f, -0.5f));
                    Xith3DLogo.this.modelTrans.getTransform().setTranslation(tmp);
                    Tuple3f.toPool(tmp);
                }
                float alpha = Xith3DLogo.interpolate(time, 2.0f, 3.0f, 1.0f, 0.0f, 1.0f, 0.0f);
                if (time >= 2.0f && time <= 3.0f) {
                    Xith3DLogo.this.label.setTransparency(alpha);
                }
                canvas.setBackgroundColor(alpha, alpha, alpha);
                if (time <= 4.0f) {
                    float lightXPos = Xith3DLogo.interpolate(time, 2.0f, 4.0f, -20.0f, 50.0f, -20.0f, 50.0f);
                    Xith3DLogo.this.light.setLocation(lightXPos, 10.0f, 0.0f);
                } else {
                    float lightXPos = Xith3DLogo.interpolate(time, 4.0f, 5.0f, 50.0f, 0.0f, 50.0f, 0.0f);
                    Xith3DLogo.this.light.setLocation(lightXPos, 10.0f, 0.0f);
                }
            }
        });
    }

    private void loadLogoModel(GroupNode parentGroup) throws IOException {
        this.light = new PointLight(1.0f, 1.0f, 1.0f, 0.0f, 10.0f, 0.0f, 5.0E-4f);
        parentGroup.addChild(this.light);
        this.modelTrans = new TransformGroup();
        Model model = ModelLoader.getInstance().loadModel(this.getClass().getClassLoader().getResource("resources/org/xith3d/models/Xith3DLogo.obj"));
        this.modelTrans.addChild(model);
        parentGroup.addChild(this.modelTrans);
    }

    private void setupSound(GroupNode parentGroup) {
        String soundFile = "resources/org/xith3d/sounds/Du Rififi a Noubaka - Extrait.ogg";
        try {
            this.sound = new BackgroundSound(new ExtensionSoundLoader().loadSound(this.getClass().getClassLoader().getResource("resources/org/xith3d/sounds/Du Rififi a Noubaka - Extrait.ogg")), 1.0f);
            this.sound.setEnabled(false);
            this.sound.setLoopType(-1);
            parentGroup.addChild(this.sound);
        }
        catch (IOException e) {
            System.err.println("Could not find sound file resources/org/xith3d/sounds/Du Rififi a Noubaka - Extrait.ogg");
        }
    }

    private HUD createHUD() {
        HUD hud = new HUD(800, 600, 800.0f);
        this.label = new Label(800.0f, 175.0f, "Xith3D\nEnjoyable creativity", font, new Colorf(0.8f, 0.0f, 0.0f), TextAlignment.CENTER_CENTER);
        this.label.setTransparency(1.0f);
        hud.getContentPane().addWidget(this.label, (hud.getResX() - this.label.getWidth()) / 2.0f, hud.getResY() - this.label.getHeight() - 10.0f);
        return hud;
    }

    protected void end(Canvas3D canvas, Xith3DLogoFinishListener finishListener) {
        this.sound.setEnabled(false);
        canvas.setBackgroundColor(this.oldCanvasBackgroundColor);
        this.sceneGraph.removeHUD(this.hud);
        this.sceneGraph.removeRenderPass(this.renderPass);
        if (finishListener != null) {
            finishListener.onLogoFinished();
        }
    }

    protected void end(OperationScheduler opScheder, final Canvas3D canvas, final Xith3DLogoFinishListener finishListener) {
        this.finished = true;
        final RectBillboard blackFader = new RectBillboard(100.0f, 100.0f, new Colorf(0.0f, 0.0f, 0.0f, 0.0f));
        TransformGroup tg = new TransformGroup(0.0f, 0.0f, 8.9f);
        tg.addChild(blackFader);
        this.renderPass.getBranchGroup().addChild(tg);
        opScheder.scheduleOperation(new ScheduledOperationImpl(true){
            private long startTime;
            {
                super(x0);
                this.startTime = -1L;
            }

            public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                float time;
                if (this.startTime == -1L) {
                    this.startTime = gameTime;
                }
                if ((time = timingMode.getSecondsAsFloat(gameTime - this.startTime)) <= 0.5f) {
                    float alpha = Xith3DLogo.interpolate(time, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f);
                    ShapeUtils.setTransparency(blackFader, 1.0f - alpha);
                    Xith3DLogo.this.label.setTransparency(alpha);
                } else {
                    this.setAlive(false);
                    Xith3DLogo.this.end(canvas, finishListener);
                }
            }
        });
    }

    public void play(final OperationScheduler opScheder, final Canvas3D canvas, final DeviceComponent[] stopComponents, final InputSystem inputSystem, final Xith3DLogoFinishListener finishListener) {
        if (this.finished) {
            throw new IllegalStateException("This logo has already been finished!");
        }
        this.oldCanvasBackgroundColor = new Colorf(canvas.getBackgroundColor());
        this.sceneGraph.addRenderPass(this.renderPass);
        this.sceneGraph.addHUD(this.hud);
        this.sound.setEnabled(true);
        this.setupInterpolators(canvas, opScheder);
        inputSystem.addInputStateListener(new InputStateListener(){

            public void onInputStateChanged(InputEvent e, DeviceComponent comp, int delta, int state) {
                if (delta <= 0) {
                    return;
                }
                boolean isStopComp = false;
                if (stopComponents == null) {
                    if (comp != null && !(comp instanceof AnalogDeviceComponent)) {
                        isStopComp = true;
                    }
                } else if (ArrayUtils.contains(stopComponents, comp, true)) {
                    isStopComp = true;
                }
                if (isStopComp) {
                    inputSystem.removeInputStateListener(this);
                    Xith3DLogo.this.end(opScheder, canvas, finishListener);
                }
            }
        });
    }

    public void play(OperationScheduler opScheder, Canvas3D canvas, DeviceComponent[] stopComponents, Xith3DLogoFinishListener finishListener) {
        this.play(opScheder, canvas, stopComponents, InputSystem.getInstance(), finishListener);
    }

    public void play(OperationScheduler opScheder, Canvas3D canvas, Xith3DLogoFinishListener finishListener) {
        this.play(opScheder, canvas, null, finishListener);
    }

    public Xith3DLogo(SceneGraph sceneGraph) throws IOException {
        this.sceneGraph = sceneGraph;
        this.renderPass = RenderPass.createPerspective();
        Transform3D viewTransform = new Transform3D();
        viewTransform.lookAt(0.0f, 0.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.renderPass.getConfig().setBackClipDistance(60.0f);
        this.renderPass.getConfig().setFrontClipDistance(1.0f);
        this.renderPass.getConfig().setViewTransform(viewTransform);
        this.renderPass.getConfig().setRenderOptions(new RenderOptions());
        this.renderPass.getConfig().getRenderOptions().setLightingEnabled(true);
        this.loadLogoModel(this.renderPass.getBranchGroup());
        this.setupSound(this.renderPass.getBranchGroup());
        this.hud = this.createHUD();
        this.finished = false;
    }

    static {
        HUDFont f = null;
        try {
            f = HUDFont.getFont(Xith3DLogo.class.getClassLoader().getResource("resources/org/xith3d/fonts/DirtyEgo.ttf"), HUDFont.PLAIN, 75);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        font = f;
    }

    public static interface Xith3DLogoFinishListener {
        public void onLogoFinished();
    }
}

