/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.geometry;

import java.util.ArrayList;
import java.util.List;
import org.jagatoo.util.arrays.ArrayUtils;
import org.openmali.spatial.TriangleContainer;
import org.openmali.spatial.VertexContainer;
import org.openmali.spatial.polygons.Triangle;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedGeometryArray;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TriangleArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryUtils {
    public static final void getVertexCoords(VertexContainer vc, Tuple3f[] coords) {
        int n = vc.getVertexCount();
        for (int i = 0; i < n; ++i) {
            if (coords[i] == null) {
                coords[i] = new Point3f();
            }
            vc.getVertex(i, coords[i]);
        }
    }

    public static final Point3f[] getVertexCoords(VertexContainer vc) {
        Tuple3f[] coords = new Point3f[vc.getVertexCount()];
        GeometryUtils.getVertexCoords(vc, coords);
        return coords;
    }

    public static final Point3f[] getVertexCoords(Shape3D shape) {
        if (shape.getGeometry() == null) {
            return null;
        }
        return GeometryUtils.getVertexCoords(shape.getGeometry());
    }

    public static final void getNormals(Geometry geom, Vector3f[] normals) {
        int n = geom.getVertexCount();
        for (int i = 0; i < n; ++i) {
            if (normals[i] == null) {
                normals[i] = new Vector3f();
            }
            geom.getNormal(i, normals[i]);
        }
    }

    public static final Vector3f[] getNormals(Geometry geom) {
        Vector3f[] normals = new Vector3f[geom.getVertexCount()];
        GeometryUtils.getNormals(geom, normals);
        return normals;
    }

    public static final Vector3f[] getNormals(Shape3D shape) {
        if (shape.getGeometry() == null) {
            return null;
        }
        return GeometryUtils.getNormals(shape.getGeometry());
    }

    public static TriangleArray mergeGeometriesTA(Geometry ... geoms) {
        if (geoms.length == 0) {
            return null;
        }
        int numTriangles = 0;
        int features = -1;
        for (int i = 0; i < geoms.length; ++i) {
            TriangleContainer tc = (TriangleContainer)((Object)geoms[i]);
            numTriangles += tc.getTriangleCount();
            features &= geoms[i].getVertexFormat();
        }
        int numVertices = numTriangles * 3;
        TriangleArray targetTA = new TriangleArray(numVertices);
        Triangle triangle = new Triangle(features, 2);
        int offset = 0;
        for (int i = 0; i < geoms.length; ++i) {
            TriangleContainer tc = (TriangleContainer)((Object)geoms[i]);
            numTriangles = tc.getTriangleCount();
            for (int t = 0; t < numTriangles; ++t) {
                tc.getTriangle(t, triangle);
                targetTA.setTriangle(offset + t, triangle);
            }
            offset += numTriangles;
        }
        return targetTA;
    }

    private static int findVertex(Point3f[] coords, Vector3f[] normals, Colorf[] colors, TexCoord2f[] texCoords, int searchStart, int searchEnd, int sampleIndex) {
        int index = ArrayUtils.indexOf(coords, searchStart, searchEnd, coords[sampleIndex], false);
        if (index < 0) {
            return index;
        }
        if (normals != null && !((TupleNf)normals[index]).equals(normals[sampleIndex])) {
            if (index < searchEnd) {
                return GeometryUtils.findVertex(coords, normals, colors, texCoords, index + 1, searchEnd, sampleIndex);
            }
            return -1;
        }
        if (colors != null && !colors[index].equals(colors[sampleIndex])) {
            if (index < searchEnd) {
                return GeometryUtils.findVertex(coords, normals, colors, texCoords, index + 1, searchEnd, sampleIndex);
            }
            return -1;
        }
        if (texCoords != null && !texCoords[index].equals(texCoords[sampleIndex])) {
            if (index < searchEnd) {
                return GeometryUtils.findVertex(coords, normals, colors, texCoords, index + 1, searchEnd, sampleIndex);
            }
            return -1;
        }
        return index;
    }

    public static IndexedTriangleArray mergeGeometriesITA(Geometry ... geoms) {
        if (geoms.length == 0) {
            return null;
        }
        int numTriangles = 0;
        int features = -1;
        for (int i = 0; i < geoms.length; ++i) {
            TriangleContainer tc = (TriangleContainer)((Object)geoms[i]);
            numTriangles += tc.getTriangleCount();
            features &= geoms[i].getVertexFormat();
        }
        int numVertices = numTriangles * 3;
        Point3f[] coords = (features & 1) != 0 ? new Point3f[numVertices] : null;
        Vector3f[] normals = (features & 2) != 0 ? new Vector3f[numVertices] : null;
        Colorf[] colors = (features & 4) != 0 ? new Colorf[numVertices] : null;
        TexCoord2f[] texCoords = (features & 8) != 0 ? new TexCoord2f[numVertices] : null;
        Triangle triangle = new Triangle(features, 2);
        int offset = 0;
        for (int i = 0; i < geoms.length; ++i) {
            TriangleContainer tc = (TriangleContainer)((Object)geoms[i]);
            numTriangles = tc.getTriangleCount();
            for (int t = 0; t < numTriangles; ++t) {
                tc.getTriangle(t, triangle);
                coords[offset + t * 3 + 0] = new Point3f(triangle.getVertexCoordA());
                coords[offset + t * 3 + 1] = new Point3f(triangle.getVertexCoordB());
                coords[offset + t * 3 + 2] = new Point3f(triangle.getVertexCoordC());
                if (normals != null) {
                    normals[offset + t * 3 + 0] = new Vector3f(triangle.getVertexNormalA());
                    normals[offset + t * 3 + 1] = new Vector3f(triangle.getVertexNormalB());
                    normals[offset + t * 3 + 2] = new Vector3f(triangle.getVertexNormalC());
                }
                if (colors != null) {
                    colors[offset + t * 3 + 0] = new Colorf(triangle.getVertexColorA());
                    colors[offset + t * 3 + 1] = new Colorf(triangle.getVertexColorB());
                    colors[offset + t * 3 + 2] = new Colorf(triangle.getVertexColorC());
                }
                if (texCoords == null) continue;
                texCoords[offset + t * 3 + 0] = new TexCoord2f(triangle.getVertexTexCoordA());
                texCoords[offset + t * 3 + 1] = new TexCoord2f(triangle.getVertexTexCoordB());
                texCoords[offset + t * 3 + 2] = new TexCoord2f(triangle.getVertexTexCoordC());
            }
            offset += geoms[i].getVertexCount();
        }
        int[] index = new int[numVertices];
        index[0] = 0;
        index[1] = 1;
        index[2] = 2;
        int numUniqueVertices = 3;
        for (int i = 3; i < numVertices; ++i) {
            int j = GeometryUtils.findVertex(coords, normals, colors, texCoords, 0, i - 1, i);
            if (j < 0) {
                index[i] = i;
                ++numUniqueVertices;
                continue;
            }
            index[i] = index[j];
        }
        Tuple3f[] uniqueCoords = (features & 1) != 0 ? new Point3f[numUniqueVertices] : null;
        Vector3f[] uniqueNormals = (features & 2) != 0 ? new Vector3f[numUniqueVertices] : null;
        Colorf[] uniqueColors = (features & 4) != 0 ? new Colorf[numUniqueVertices] : null;
        TexCoord2f[] uniqueTexCoords = (features & 8) != 0 ? new TexCoord2f[numUniqueVertices] : null;
        int j = 0;
        for (int i = 0; i < numVertices; ++i) {
            if (index[i] != i) continue;
            for (int k = 0; k < numVertices; ++k) {
                if (index[k] != i) continue;
                index[k] = j;
            }
            uniqueCoords[j] = coords[i];
            if (normals != null) {
                uniqueNormals[j] = normals[i];
            }
            if (colors != null) {
                uniqueColors[j] = colors[i];
            }
            if (normals != null) {
                uniqueTexCoords[j] = texCoords[i];
            }
            ++j;
        }
        IndexedTriangleArray targetITA = new IndexedTriangleArray(numUniqueVertices, numVertices);
        targetITA.setCoordinates(0, uniqueCoords);
        if (uniqueNormals != null) {
            targetITA.setNormals(0, uniqueNormals);
        }
        if (uniqueColors != null) {
            targetITA.setColors(0, uniqueColors);
        }
        if (uniqueTexCoords != null) {
            targetITA.setTextureCoordinates(0, 0, uniqueTexCoords);
        }
        targetITA.setIndex(index);
        return targetITA;
    }

    public static List<Shape3D> split(Shape3D shape, int maxFacesPerPart) {
        Geometry src = shape.getGeometry();
        if (src == null) {
            return null;
        }
        int vertexCount = src.getVertexCount();
        float[] origCoords = src.getCoordRefFloat();
        float[] origNormals = src.getNormalRefFloat();
        ArrayList<Shape3D> parts = new ArrayList<Shape3D>();
        for (int start = 0; start < vertexCount; start += maxFacesPerPart * 3) {
            if (start + maxFacesPerPart * 3 > vertexCount) {
                maxFacesPerPart = start + maxFacesPerPart * 3 - vertexCount;
            }
            float[] coords = new float[maxFacesPerPart * 3];
            System.arraycopy(origCoords, start, coords, 0, coords.length);
            float[] normals = new float[maxFacesPerPart * 3];
            System.arraycopy(origNormals, start, normals, 0, normals.length);
            TriangleArray ta = new TriangleArray(coords.length);
            ta.setOptimization(shape.getGeometry().getOptimization());
            ta.setCoordinates(0, coords);
            ta.setNormals(0, normals);
            parts.add(new Shape3D(ta, shape.getAppearance()));
        }
        return parts;
    }

    public static void subdivide(Shape3D shape, int n) {
        TriangleArray dst;
        Geometry geom;
        if (n > 1) {
            GeometryUtils.subdivide(shape, --n);
        }
        if ((geom = shape.getGeometry()) instanceof TriangleArray) {
            int i;
            TriangleArray src = (TriangleArray)geom;
            dst = new TriangleArray(src.getVertexCount() * 3);
            float x1 = 0.0f;
            float x2 = 0.0f;
            float x3 = 0.0f;
            float xc = 0.0f;
            float y1 = 0.0f;
            float y2 = 0.0f;
            float y3 = 0.0f;
            float yc = 0.0f;
            float z1 = 0.0f;
            float z2 = 0.0f;
            float z3 = 0.0f;
            float zc = 0.0f;
            float[] srcVerts = src.getCoordRefFloat();
            float[] dstVerts = new float[srcVerts.length * 3];
            int j = 0;
            for (int i2 = 0; i2 < srcVerts.length; i2 += 9) {
                x1 = srcVerts[i2];
                x2 = srcVerts[i2 + 3];
                x3 = srcVerts[i2 + 6];
                xc = (x1 + x2 + x3) * 0.333f;
                y1 = srcVerts[i2 + 1];
                y2 = srcVerts[i2 + 4];
                y3 = srcVerts[i2 + 7];
                yc = (y1 + y2 + y3) * 0.333f;
                z1 = srcVerts[i2 + 2];
                z2 = srcVerts[i2 + 5];
                z3 = srcVerts[i2 + 8];
                zc = (z1 + z2 + z3) * 0.333f;
                dstVerts[j++] = x1;
                dstVerts[j++] = y1;
                dstVerts[j++] = z1;
                dstVerts[j++] = x2;
                dstVerts[j++] = y2;
                dstVerts[j++] = z2;
                dstVerts[j++] = xc;
                dstVerts[j++] = yc;
                dstVerts[j++] = zc;
                dstVerts[j++] = x2;
                dstVerts[j++] = y2;
                dstVerts[j++] = z2;
                dstVerts[j++] = x3;
                dstVerts[j++] = y3;
                dstVerts[j++] = z3;
                dstVerts[j++] = xc;
                dstVerts[j++] = yc;
                dstVerts[j++] = zc;
                dstVerts[j++] = x3;
                dstVerts[j++] = y3;
                dstVerts[j++] = z3;
                dstVerts[j++] = x1;
                dstVerts[j++] = y1;
                dstVerts[j++] = z1;
                dstVerts[j++] = xc;
                dstVerts[j++] = yc;
                dstVerts[j++] = zc;
            }
            dst.setCoordinates(0, dstVerts);
            if ((src.getVertexFormat() & 2) != 0) {
                float[] srcNormals = src.getNormalRefFloat();
                float[] dstNormals = new float[srcNormals.length * 3];
                j = 0;
                for (i = 0; i < srcNormals.length; i += 9) {
                    x1 = srcNormals[i];
                    x2 = srcNormals[i + 3];
                    x3 = srcNormals[i + 6];
                    xc = (x1 + x2 + x3) * 0.333f;
                    y1 = srcNormals[i + 1];
                    y2 = srcNormals[i + 4];
                    y3 = srcNormals[i + 7];
                    yc = (y1 + y2 + y3) * 0.333f;
                    z1 = srcNormals[i + 2];
                    z2 = srcNormals[i + 5];
                    z3 = srcNormals[i + 8];
                    zc = (z1 + z2 + z3) * 0.333f;
                    dstNormals[j++] = x1;
                    dstNormals[j++] = y1;
                    dstNormals[j++] = z1;
                    dstNormals[j++] = x2;
                    dstNormals[j++] = y2;
                    dstNormals[j++] = z2;
                    dstNormals[j++] = xc;
                    dstNormals[j++] = yc;
                    dstNormals[j++] = zc;
                    dstNormals[j++] = x2;
                    dstNormals[j++] = y2;
                    dstNormals[j++] = z2;
                    dstNormals[j++] = x3;
                    dstNormals[j++] = y3;
                    dstNormals[j++] = z3;
                    dstNormals[j++] = xc;
                    dstNormals[j++] = yc;
                    dstNormals[j++] = zc;
                    dstNormals[j++] = x3;
                    dstNormals[j++] = y3;
                    dstNormals[j++] = z3;
                    dstNormals[j++] = x1;
                    dstNormals[j++] = y1;
                    dstNormals[j++] = z1;
                    dstNormals[j++] = xc;
                    dstNormals[j++] = yc;
                    dstNormals[j++] = zc;
                }
                dst.setNormals(0, dstNormals);
            }
            if ((src.getVertexFormat() & 8) != 0 && src.getTexCoordSize(0) == 2) {
                for (int tu = 0; tu < src.getNumTextureUnits(); ++tu) {
                    float[] srcTexCoords = src.getTexCoordRefFloat(src.getTexCoordSetMap()[tu]);
                    float[] dstTexCoords = new float[srcTexCoords.length * 3];
                    j = 0;
                    for (int i3 = 0; i3 < srcTexCoords.length; i3 += 6) {
                        x1 = srcTexCoords[i3];
                        x2 = srcTexCoords[i3 + 2];
                        x3 = srcTexCoords[i3 + 4];
                        xc = (x1 + x2 + x3) * 0.333f;
                        y1 = srcTexCoords[i3 + 1];
                        y2 = srcTexCoords[i3 + 3];
                        y3 = srcTexCoords[i3 + 5];
                        yc = (y1 + y2 + y3) * 0.333f;
                        dstTexCoords[j++] = x1;
                        dstTexCoords[j++] = y1;
                        dstTexCoords[j++] = x2;
                        dstTexCoords[j++] = y2;
                        dstTexCoords[j++] = xc;
                        dstTexCoords[j++] = yc;
                        dstTexCoords[j++] = x2;
                        dstTexCoords[j++] = y2;
                        dstTexCoords[j++] = x3;
                        dstTexCoords[j++] = y3;
                        dstTexCoords[j++] = xc;
                        dstTexCoords[j++] = yc;
                        dstTexCoords[j++] = x3;
                        dstTexCoords[j++] = y3;
                        dstTexCoords[j++] = x1;
                        dstTexCoords[j++] = y1;
                        dstTexCoords[j++] = xc;
                        dstTexCoords[j++] = yc;
                    }
                    dst.setTextureCoordinates(src.getTexCoordSetMap()[tu], 0, 2, dstTexCoords);
                }
            }
            if ((src.getVertexFormat() & 4) != 0 && !src.hasColorAlpha()) {
                float[] srcColors = src.getColorRefFloat();
                float[] dstColors = new float[srcColors.length * 3];
                j = 0;
                for (i = 0; i < srcColors.length; i += 9) {
                    x1 = srcColors[i];
                    x2 = srcColors[i + 3];
                    x3 = srcColors[i + 6];
                    xc = (x1 + x2 + x3) * 0.333f;
                    y1 = srcColors[i + 1];
                    y2 = srcColors[i + 4];
                    y3 = srcColors[i + 7];
                    yc = (y1 + y2 + y3) * 0.333f;
                    z1 = srcColors[i + 2];
                    z2 = srcColors[i + 5];
                    z3 = srcColors[i + 8];
                    zc = (z1 + z2 + z3) * 0.333f;
                    dstColors[j++] = x1;
                    dstColors[j++] = y1;
                    dstColors[j++] = z1;
                    dstColors[j++] = x2;
                    dstColors[j++] = y2;
                    dstColors[j++] = z2;
                    dstColors[j++] = xc;
                    dstColors[j++] = yc;
                    dstColors[j++] = zc;
                    dstColors[j++] = x2;
                    dstColors[j++] = y2;
                    dstColors[j++] = z2;
                    dstColors[j++] = x3;
                    dstColors[j++] = y3;
                    dstColors[j++] = z3;
                    dstColors[j++] = xc;
                    dstColors[j++] = yc;
                    dstColors[j++] = zc;
                    dstColors[j++] = x3;
                    dstColors[j++] = y3;
                    dstColors[j++] = z3;
                    dstColors[j++] = x1;
                    dstColors[j++] = y1;
                    dstColors[j++] = z1;
                    dstColors[j++] = xc;
                    dstColors[j++] = yc;
                    dstColors[j++] = zc;
                }
                dst.setColors(0, 3, dstColors);
            }
        } else {
            throw new Error("Error! Cannot subdivide a Geometry of type : " + geom.getClass().getName() + "." + " Sorry :( (it's just not implemented yet)");
        }
        shape.setGeometry(dst);
    }

    public static final void generateTexCoordsXY(Geometry geom, TexCoord2f[] texCoords) {
        if (!geom.hasTextureCoordinates() || geom.getTexCoordSize(0) != 2) {
            throw new UnsupportedOperationException("The Geometry cannot receive 2D-texture-coords");
        }
        Point3f coord = Point3f.fromPool();
        float xmin = Float.MAX_VALUE;
        float xmax = -3.4028235E38f;
        float ymin = Float.MAX_VALUE;
        float ymax = -3.4028235E38f;
        float n = geom.getVertexCount();
        int i = 0;
        while ((float)i < n) {
            geom.getVertex(i, coord);
            xmin = Math.min(xmin, coord.getX());
            xmax = Math.max(xmax, coord.getX());
            ymin = Math.min(ymin, coord.getY());
            ymax = Math.max(ymax, coord.getY());
            ++i;
        }
        float xscale = 1.0f / (xmax - xmin);
        float yscale = 1.0f / (ymax - ymin);
        TexCoord2f texCoord = new TexCoord2f();
        int i2 = 0;
        while ((float)i2 < n) {
            geom.getVertex(i2, coord);
            texCoord.setS((coord.getX() - xmin) * xscale);
            texCoord.setT((coord.getY() - ymin) * yscale);
            if (texCoords != null) {
                if (texCoords[i2] == null) {
                    texCoords[i2] = new TexCoord2f();
                }
                texCoords[i2].set(texCoord);
            }
            geom.setTextureCoordinate(0, i2, texCoord);
            ++i2;
        }
        Point3f.toPool(coord);
    }

    public static final void generateTexCoordsXZ(Geometry geom, TexCoord2f[] texCoords) {
        if (!geom.hasTextureCoordinates() || geom.getTexCoordSize(0) != 2) {
            throw new UnsupportedOperationException("The Geometry cannot receive texture-coords");
        }
        Point3f coord = Point3f.fromPool();
        float xmin = Float.MAX_VALUE;
        float xmax = -3.4028235E38f;
        float zmin = Float.MAX_VALUE;
        float zmax = -3.4028235E38f;
        float n = geom.getVertexCount();
        int i = 0;
        while ((float)i < n) {
            geom.getVertex(i, coord);
            xmin = Math.min(xmin, coord.getX());
            xmax = Math.max(xmax, coord.getX());
            zmin = Math.min(zmin, coord.getZ());
            zmax = Math.max(zmax, coord.getZ());
            ++i;
        }
        float xscale = 1.0f / (xmax - xmin);
        float zscale = 1.0f / (zmax - zmin);
        TexCoord2f texCoord = new TexCoord2f();
        int i2 = 0;
        while ((float)i2 < n) {
            geom.getVertex(i2, coord);
            texCoord.setS((coord.getX() - xmin) * xscale);
            texCoord.setT((coord.getY() - zmin) * zscale);
            if (texCoords != null) {
                if (texCoords[i2] == null) {
                    texCoords[i2] = new TexCoord2f();
                }
                texCoords[i2].set(texCoord);
            }
            geom.setTextureCoordinate(0, i2, texCoord);
            ++i2;
        }
        Point3f.toPool(coord);
    }

    public static final void generateTexCoordsZY(Geometry geom, TexCoord2f[] texCoords) {
        if (!geom.hasTextureCoordinates() || geom.getTexCoordSize(0) != 2) {
            throw new UnsupportedOperationException("The Geometry cannot receive texture-coords");
        }
        Point3f coord = Point3f.fromPool();
        float zmin = Float.MAX_VALUE;
        float zmax = -3.4028235E38f;
        float ymin = Float.MAX_VALUE;
        float ymax = -3.4028235E38f;
        float n = geom.getVertexCount();
        int i = 0;
        while ((float)i < n) {
            geom.getVertex(i, coord);
            zmin = Math.min(zmin, coord.getZ());
            zmax = Math.max(zmax, coord.getZ());
            ymin = Math.min(ymin, coord.getY());
            ymax = Math.max(ymax, coord.getY());
            ++i;
        }
        float zscale = 1.0f / (zmax - zmin);
        float yscale = 1.0f / (ymax - ymin);
        TexCoord2f texCoord = new TexCoord2f();
        int i2 = 0;
        while ((float)i2 < n) {
            geom.getVertex(i2, coord);
            texCoord.setS((coord.getZ() - zmin) * zscale);
            texCoord.setT((coord.getY() - ymin) * yscale);
            if (texCoords != null) {
                if (texCoords[i2] == null) {
                    texCoords[i2] = new TexCoord2f();
                }
                texCoords[i2].set(texCoord);
            }
            geom.setTextureCoordinate(0, i2, texCoord);
            ++i2;
        }
        Point3f.toPool(coord);
    }

    public static void computeVertexNormals(Geometry geom, int initialIndex, int indexCount, boolean flipNormals) {
        int i;
        int i2;
        int[] indices;
        float EPSILON = 0.001f;
        Tuple3f[] coords = new Point3f[geom.getValidVertexCount()];
        for (int i3 = 0; i3 < coords.length; ++i3) {
            coords[geom.getInitialVertexIndex() + i3] = new Point3f();
        }
        geom.getCoordinates(0, coords);
        if (geom instanceof IndexedGeometryArray) {
            IndexedGeometryArray idxGeom = (IndexedGeometryArray)geom;
            indices = idxGeom.getIndex();
            if (initialIndex < 0) {
                initialIndex = idxGeom.getInitialIndexIndex();
            }
            if (indexCount < 0) {
                indexCount = idxGeom.getValidIndexCount();
            }
        } else {
            indices = new int[coords.length];
            if (initialIndex < 0) {
                initialIndex = 0;
            }
            if (indexCount < 0) {
                indexCount = indices.length;
            }
            for (int i4 = 0; i4 < indices.length; ++i4) {
                indices[i4] = i4;
            }
        }
        Vector3f[] normals = new Vector3f[coords.length];
        for (i2 = 0; i2 < normals.length; ++i2) {
            normals[i2] = new Vector3f();
        }
        geom.getNormals(0, normals);
        for (i2 = 0; i2 < normals.length; ++i2) {
            normals[i2].normalize();
        }
        Vector3f[] newNormals = new Vector3f[coords.length];
        for (int i5 = 0; i5 < newNormals.length; ++i5) {
            newNormals[i5] = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        TriangleContainer trianCont = (TriangleContainer)((Object)geom);
        Triangle[] triangles = new Triangle[trianCont.getTriangleCount()];
        for (int i6 = 0; i6 < triangles.length; ++i6) {
            triangles[i6] = new Triangle();
            trianCont.getTriangle(i6, triangles[i6]);
        }
        Vector3f normal = new Vector3f();
        for (i = initialIndex; i < initialIndex + indexCount; ++i) {
            int j;
            int idx = indices[i];
            float angleSum = 0.0f;
            for (j = 0; j < triangles.length; ++j) {
                if (((Point3f)coords[idx]).distance(triangles[j].getVertexCoordA()) <= 0.001f) {
                    angleSum += triangles[j].getAngleA();
                    continue;
                }
                if (((Point3f)coords[idx]).distance(triangles[j].getVertexCoordB()) <= 0.001f) {
                    angleSum += triangles[j].getAngleB();
                    continue;
                }
                if (!(((Point3f)coords[idx]).distance(triangles[j].getVertexCoordC()) <= 0.001f)) continue;
                angleSum += triangles[j].getAngleC();
            }
            for (j = 0; j < triangles.length; ++j) {
                float angle;
                if (((Point3f)coords[idx]).distance(triangles[j].getVertexCoordA()) <= 0.001f) {
                    triangles[j].getFaceNormal(normal);
                    angle = triangles[j].getAngleA();
                    normal.scale(angle / angleSum);
                    newNormals[idx].add(normal);
                    continue;
                }
                if (((Point3f)coords[idx]).distance(triangles[j].getVertexCoordB()) <= 0.001f) {
                    triangles[j].getFaceNormal(normal);
                    angle = triangles[j].getAngleB();
                    normal.scale(angle / angleSum);
                    newNormals[idx].add(normal);
                    continue;
                }
                if (!(((Point3f)coords[idx]).distance(triangles[j].getVertexCoordC()) <= 0.001f)) continue;
                triangles[j].getFaceNormal(normal);
                angle = triangles[j].getAngleC();
                normal.scale(angle / angleSum);
                newNormals[idx].add(normal);
            }
        }
        if (flipNormals) {
            for (i = 0; i < newNormals.length; ++i) {
                newNormals[i].normalize();
                newNormals[i].negate();
            }
        } else {
            for (i = 0; i < newNormals.length; ++i) {
                newNormals[i].normalize();
            }
        }
        geom.setNormals(0, newNormals);
    }

    public static void computeVertexNormals(Geometry geom, int initialIndex, int indexCount) {
        GeometryUtils.computeVertexNormals(geom, initialIndex, indexCount, false);
    }

    private static void _computeVertexNormals(Geometry geom, int initialIndex, int indexCount, boolean flipNormals) {
        int i;
        int i2;
        int[] indices;
        float EPSILON = 0.001f;
        Tuple3f[] coords = new Point3f[geom.getValidVertexCount()];
        for (int i3 = 0; i3 < coords.length; ++i3) {
            coords[geom.getInitialVertexIndex() + i3] = new Point3f();
        }
        geom.getCoordinates(0, coords);
        if (geom instanceof IndexedGeometryArray) {
            IndexedGeometryArray idxGeom = (IndexedGeometryArray)geom;
            indices = idxGeom.getIndex();
            if (initialIndex < 0) {
                initialIndex = idxGeom.getInitialIndexIndex();
            }
            if (indexCount < 0) {
                indexCount = idxGeom.getValidIndexCount();
            }
        } else {
            int i4;
            indices = new int[coords.length];
            if (initialIndex < 0) {
                initialIndex = 0;
            }
            if (indexCount < 0) {
                indexCount = indices.length;
            }
            for (i4 = 0; i4 < indices.length; ++i4) {
                indices[i4] = i4;
            }
            for (i4 = 0; i4 < coords.length; ++i4) {
                if (indices[i4] != i4) continue;
                for (int j = i4 + 1; j < coords.length; ++j) {
                    if (indices[j] != j || !(((Point3f)coords[i4]).distance((Point3f)coords[j]) <= 0.001f)) continue;
                    indices[j] = indices[i4];
                }
            }
        }
        Vector3f[] normals = new Vector3f[coords.length];
        for (i2 = 0; i2 < normals.length; ++i2) {
            normals[i2] = new Vector3f();
        }
        geom.getNormals(0, normals);
        for (i2 = 0; i2 < normals.length; ++i2) {
            normals[i2].normalize();
        }
        Vector3f[] newNormals = new Vector3f[coords.length];
        for (int i5 = 0; i5 < newNormals.length; ++i5) {
            newNormals[i5] = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        TriangleContainer trianCont = (TriangleContainer)((Object)geom);
        Triangle[] triangles = new Triangle[trianCont.getTriangleCount()];
        for (i = 0; i < triangles.length; ++i) {
            triangles[i] = new Triangle();
            trianCont.getTriangle(i, triangles[i]);
        }
        for (i = initialIndex; i < initialIndex + indexCount; ++i) {
            int idx = indices[i];
            for (int j = 0; j < triangles.length; ++j) {
                if (((Point3f)coords[idx]).distance(triangles[j].getVertexCoordA()) <= 0.001f) {
                    triangles[j].getFaceNormalACAB(newNormals[idx]);
                    continue;
                }
                if (((Point3f)coords[idx]).distance(triangles[j].getVertexCoordB()) <= 0.001f) {
                    triangles[j].getFaceNormalBABC(newNormals[idx]);
                    continue;
                }
                if (!(((Point3f)coords[idx]).distance(triangles[j].getVertexCoordC()) <= 0.001f)) continue;
                triangles[j].getFaceNormalCBCA(newNormals[idx]);
            }
        }
        if (flipNormals) {
            for (i = 0; i < newNormals.length; ++i) {
                newNormals[i].negate();
            }
        }
        geom.setNormals(0, newNormals);
    }

    public static void computeVertexNormals(Geometry geom, boolean flipNormals) {
        GeometryUtils.computeVertexNormals(geom, -1, -1, flipNormals);
    }

    public static void computeVertexNormals(Geometry geom) {
        GeometryUtils.computeVertexNormals(geom, -1, -1);
    }
}

