/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.geometry;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VertexData
implements Comparable<VertexData> {
    public int smoothGroup = -1;
    public Point3f coord = null;
    public Vector3f normal = null;
    public Colorf color = null;
    public TexCoord2f[] texCoords = null;

    public VertexData() {
    }

    public VertexData(VertexData vd) {
        this.smoothGroup = vd.smoothGroup;
        if (vd.coord != null) {
            this.coord = new Point3f(vd.coord);
        }
        if (vd.normal != null) {
            this.normal = new Vector3f(vd.normal);
        }
        if (vd.color != null) {
            this.color = new Colorf(vd.color);
        }
        if (vd.texCoords != null) {
            this.texCoords = new TexCoord2f[vd.texCoords.length];
            for (int i = 0; i < this.texCoords.length; ++i) {
                this.texCoords[i] = vd.texCoords[i] == null ? null : new TexCoord2f(vd.texCoords[i]);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (this.coord != null) {
            sb.append("P").append(this.coord);
        }
        if (this.normal != null) {
            sb.append("N").append(this.coord);
        }
        if (this.color != null) {
            sb.append("C").append(this.coord);
        }
        for (int i = 0; this.texCoords != null && i < this.texCoords.length; ++i) {
            sb.append("T").append(this.texCoords[i]);
        }
        if (this.smoothGroup >= 0) {
            sb.append("S").append(this.smoothGroup);
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int h = 0;
        if (this.coord != null) {
            h ^= this.coord.hashCode();
        }
        if (this.normal != null) {
            h ^= this.normal.hashCode();
        }
        if (this.color != null) {
            h ^= this.color.hashCode();
        }
        return h;
    }

    @Override
    public int compareTo(VertexData o) {
        int d = this.compare(this.coord, o.coord);
        if (d != 0) {
            return d;
        }
        d = this.compare(this.normal, o.normal);
        if (d != 0) {
            return d;
        }
        d = this.compare(this.color, o.color);
        if (d != 0) {
            return d;
        }
        d = this.compare(this.texCoords, o.texCoords);
        if (d != 0) {
            return d;
        }
        d = this.smoothGroup - o.smoothGroup;
        if (d != 0) {
            return d;
        }
        return 0;
    }

    public boolean equals(Object o) {
        VertexData vd = (VertexData)o;
        return VertexData.isEqual(this.coord, vd.coord) && VertexData.isEqual(this.normal, vd.normal) && VertexData.isEqual(this.color, vd.color) && VertexData.isEqual(this.texCoords, vd.texCoords) && this.smoothGroup == vd.smoothGroup;
    }

    private static int fdiff(float diff) {
        if (diff < 0.0f) {
            return -1;
        }
        if (diff > 0.0f) {
            return 1;
        }
        return 0;
    }

    private int compare(TexCoord2f t1, TexCoord2f t2) {
        if (t1 == null && t2 == null) {
            return 0;
        }
        if (t1 == null) {
            return -1;
        }
        if (t2 == null) {
            return 1;
        }
        float d = t1.getS() - t2.getS();
        if (d != 0.0f) {
            return VertexData.fdiff(d);
        }
        d = t1.getT() - t2.getT();
        if (d != 0.0f) {
            return VertexData.fdiff(d);
        }
        return 0;
    }

    private int compare(TexCoord2f[] t1, TexCoord2f[] t2) {
        if (t1 == null && t2 == null) {
            return 0;
        }
        if (t1 == null) {
            return -1;
        }
        if (t2 == null) {
            return 1;
        }
        if (t1.length != t2.length) {
            return t1.length - t2.length;
        }
        for (int i = 0; i < t1.length; ++i) {
            int d = this.compare(t1[i], t2[i]);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    private int compare(Tuple3f t1, Tuple3f t2) {
        if (t1 == null && t2 == null) {
            return 0;
        }
        if (t1 == null) {
            return -1;
        }
        if (t2 == null) {
            return 1;
        }
        float d = t1.getX() - t2.getX();
        if (d != 0.0f) {
            return VertexData.fdiff(d);
        }
        d = t1.getY() - t2.getY();
        if (d != 0.0f) {
            return VertexData.fdiff(d);
        }
        d = t1.getZ() - t2.getZ();
        if (d != 0.0f) {
            return VertexData.fdiff(d);
        }
        return 0;
    }

    private int compare(Colorf c1, Colorf c2) {
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        float d = c1.getRed() - c2.getRed();
        if (d != 0.0f) {
            return VertexData.fdiff(d);
        }
        d = c1.getGreen() - c2.getGreen();
        if (d != 0.0f) {
            return VertexData.fdiff(d);
        }
        d = c1.getBlue() - c2.getBlue();
        if (d != 0.0f) {
            return VertexData.fdiff(d);
        }
        if ((c1.hasAlpha() || c2.hasAlpha()) && (d = c1.getAlpha() - c2.getAlpha()) != 0.0f) {
            return VertexData.fdiff(d);
        }
        return 0;
    }

    private static boolean isEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private static boolean isEqual(Object[] o1, Object[] o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1.length != o2.length) {
            return false;
        }
        for (int i = 0; i < o1.length; ++i) {
            if (VertexData.isEqual(o1[i], o2[i])) continue;
            return false;
        }
        return true;
    }
}

