/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.hud;

import org.openmali.vecmath2.Colorf;
import org.xith3d.loop.opscheduler.OperationScheduler;
import org.xith3d.schedops.properties.ValueInterpolator;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.widgets.Image;

public class HUDFadeOutHandler
extends ValueInterpolator {
    private final Image image;
    private Colorf color;

    protected void applyValue(float value) {
        this.color.setAlpha(value);
        this.image.setColor(this.color);
    }

    protected void onInterpolationFinished() {
        super.onInterpolationFinished();
        this.image.detach();
    }

    public HUDFadeOutHandler(HUD hud, OperationScheduler opScheder, long fadeTime, Colorf color) {
        super(fadeTime, 20L, 1.0f, 0.0f);
        this.color = new Colorf(color.getRed(), color.getGreen(), color.getBlue(), 1.0f);
        this.image = new Image(hud.getResX(), hud.getResY(), color);
        hud.getContentPane().addWidget((Widget)this.image, 0.0f, 0.0f, 1000);
        opScheder.addInterval(this);
    }

    public HUDFadeOutHandler(HUD hud, OperationScheduler opScheder, long fadeTime) {
        this(hud, opScheder, fadeTime, Colorf.BLACK);
    }

    public static void fade(HUD hud, OperationScheduler opScheder, long fadeTime, Colorf color) {
        new HUDFadeOutHandler(hud, opScheder, fadeTime, color);
    }

    public static void fade(HUD hud, OperationScheduler opScheder, long fadeTime) {
        HUDFadeOutHandler.fade(hud, opScheder, fadeTime, Colorf.BLACK);
    }
}

