/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.math;

import org.xith3d.utility.logging.X3DLog;
import org.xith3d.utility.math.Interpolator;

public class LinearFloatInterpolator
implements Interpolator {
    private float value;
    private float value1;
    private float value2;

    public LinearFloatInterpolator(float value1, float value2) {
        this.value1 = value1;
        this.value2 = value2;
        this.setAlpha(0.0f);
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            Error er = new Error("Alpha = " + alpha + " !! outside [0f-1f] range !!");
            X3DLog.print(er);
            throw er;
        }
        float beta = 1.0f - alpha;
        this.value = beta * this.value1 + alpha * this.value2;
    }

    public float getValue() {
        return this.value;
    }

    public float getValue1() {
        return this.value1;
    }

    public void setValue1(float value1) {
        this.value1 = value1;
    }

    public float getValue2() {
        return this.value2;
    }

    public void setValue2(float value2) {
        this.value2 = value2;
    }
}

